/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.ch.qos.logback.core.helpers;

import java.util.regex.Pattern;

public class Transform {
    private static final int CDATA_END_LEN = "]]>".length();
    private static final Pattern UNSAFE_XML_CHARS = Pattern.compile("[\u0000-\b\u000b\f\u000e-\u001f<>&'\"]");

    public static String escapeTags(String input) {
        if (input == null || input.length() == 0 || !UNSAFE_XML_CHARS.matcher(input).find()) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input);
        return Transform.escapeTags(buf);
    }

    public static String escapeTags(StringBuffer buf) {
        block8: for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '&': {
                    buf.replace(i, i + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    buf.replace(i, i + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    buf.replace(i, i + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    buf.replace(i, i + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    buf.replace(i, i + 1, "&#39;");
                    continue block8;
                }
                default: {
                    if (ch >= ' ') continue block8;
                    buf.replace(i, i + 1, "\ufffd");
                }
            }
        }
        return buf.toString();
    }
}

