/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.play;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.checker.Nullable;

class Routes {
    private static final Pattern routePattern = Pattern.compile("\\$[^<]+<([^>]+)>");
    private static final ConcurrentMap<String, String> simplifiedRoutes = new ConcurrentHashMap<String, String>();

    private Routes() {
    }

    static String simplifiedRoute(String route) {
        String simplifiedRoute = (String)simplifiedRoutes.get(route);
        if (simplifiedRoute == null) {
            Matcher matcher = routePattern.matcher(route);
            StringBuilder sb = new StringBuilder();
            int end = 0;
            while (matcher.find()) {
                if (end == 0) {
                    sb.append(route.substring(0, matcher.start()));
                }
                String regex = Routes.nullToEmpty(matcher.group(1));
                regex = regex.replace("[^/]+", "*");
                regex = regex.replace(".+", "**");
                sb.append(regex);
                end = matcher.end();
            }
            sb.append(route.substring(end));
            simplifiedRoute = sb.toString();
            simplifiedRoutes.put(route, simplifiedRoute);
        }
        return simplifiedRoute;
    }

    private static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }
}

