/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.kafka;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;

public class CallbackWrapper
implements Callback {
    private final Callback delegate;
    private final AsyncTraceEntry asyncTraceEntry;
    private final AuxThreadContext auxContext;

    public CallbackWrapper(Callback delegate, AsyncTraceEntry asyncTraceEntry, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.asyncTraceEntry = asyncTraceEntry;
        this.auxContext = auxContext;
    }

    public void onCompletion(@Nullable RecordMetadata metadata, @Nullable Exception exception) {
        if (exception == null) {
            this.asyncTraceEntry.end();
        } else {
            this.asyncTraceEntry.endWithError(exception);
        }
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.onCompletion(metadata, exception);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw CallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        CallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

