/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc.message;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.glowroot.agent.plugin.api.checker.Nullable;

public class BindParameterList
implements Iterable<Object> {
    @Nullable
    private Object[] parameters;
    private int size;

    public static BindParameterList copyOf(BindParameterList bindParameterList) {
        return new BindParameterList(bindParameterList.parameters, bindParameterList.size);
    }

    public BindParameterList(int capacity) {
        this.parameters = new Object[capacity];
    }

    private BindParameterList(@Nullable Object[] parameters, int size) {
        if (parameters.length == size) {
            this.parameters = (Object[])parameters.clone();
        } else {
            this.parameters = new Object[size];
            System.arraycopy(parameters, 0, this.parameters, 0, size);
        }
        this.size = size;
    }

    public void set(int i, @Nullable Object parameter) {
        int capacity = this.parameters.length;
        if (i >= capacity) {
            if (i >= (capacity += capacity >> 1)) {
                capacity = i + 1;
            }
            this.parameters = Arrays.copyOf(this.parameters, capacity);
        }
        this.parameters[i] = parameter;
        int newSize = i + 1;
        if (newSize > this.size) {
            this.size = newSize;
        }
    }

    public int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.parameters, null);
        this.size = 0;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ParameterIterator();
    }

    private class ParameterIterator
    implements Iterator<Object> {
        private int i;

        private ParameterIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < BindParameterList.this.size;
        }

        @Override
        @Nullable
        public Object next() {
            if (this.i < BindParameterList.this.size) {
                return BindParameterList.this.parameters[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

