/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import java.net.URI;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.httpclient._.Uris;
import wiremock.org.apache.http.HttpHost;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.RequestLine;
import wiremock.org.apache.http.client.methods.HttpUriRequest;

public class WiremockApacheHttpClientAspect {

    @Pointcut(className="wiremock.org.apache.http.client.HttpClient", methodName="execute", methodParameterTypes={"wiremock.org.apache.http.HttpHost", "wiremock.org.apache.http.HttpRequest", ".."}, nestingGroup="http-client", timerName="http client request")
    public static class ExecuteWithHostAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteWithHostAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(ThreadContext context, @BindParameter @Nullable HttpHost hostObj, @BindParameter @Nullable HttpRequest request) {
            if (request == null) {
                return null;
            }
            RequestLine requestLine = request.getRequestLine();
            if (requestLine == null) {
                return null;
            }
            String method = requestLine.getMethod();
            method = method == null ? "" : method + " ";
            String host = hostObj == null ? "" : hostObj.toURI();
            String uri = requestLine.getUri();
            if (uri == null) {
                uri = "";
            }
            return context.startServiceCallEntry("HTTP", method + Uris.stripQueryString(uri), MessageSupplier.create("http client request: {}{}{}", method, host, uri), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="wiremock.org.apache.http.client.HttpClient", methodName="execute", methodParameterTypes={"wiremock.org.apache.http.client.methods.HttpUriRequest", ".."}, nestingGroup="http-client", timerName="http client request")
    public static class ExecuteAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(ThreadContext context, @BindParameter @Nullable HttpUriRequest request) {
            if (request == null) {
                return null;
            }
            String method = request.getMethod();
            method = method == null ? "" : method + " ";
            URI uriObj = request.getURI();
            String uri = uriObj == null ? "" : uriObj.toString();
            return context.startServiceCallEntry("HTTP", method + Uris.stripQueryString(uri), MessageSupplier.create("http client request: {}{}", method, uri), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }
}

