/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import org.apache.http.concurrent.FutureCallback;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class FutureCallbackWithoutEntryWrapper<T>
implements FutureCallback<T> {
    private final FutureCallback<T> delegate;
    private final AuxThreadContext auxContext;

    public FutureCallbackWithoutEntryWrapper(FutureCallback<T> delegate, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.auxContext = auxContext;
    }

    public void completed(T result) {
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.completed(result);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWithoutEntryWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void failed(Exception exception) {
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.failed(exception);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWithoutEntryWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void cancelled() {
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.cancelled();
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWithoutEntryWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        FutureCallbackWithoutEntryWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

