/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.executor;

import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class RunnableWrapper
implements Runnable {
    private final Runnable delegate;
    private final AuxThreadContext auxContext;

    public RunnableWrapper(Runnable delegate, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.auxContext = auxContext;
    }

    @Override
    public void run() {
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.run();
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw RunnableWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        RunnableWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

