/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SyncQueryData
implements QueryData {
    private final String queryType;
    private final String queryText;
    @Nullable
    private final SyncQueryData nextQueryData;
    @Nullable
    private final SyncQueryData limitExceededBucket;
    private long sumOfStartTicks;
    private long sumOfEndTicks;
    private long executionCount;
    private long activeCount;
    private long totalRows = -1L;

    public SyncQueryData(String queryType, String queryText, @Nullable SyncQueryData nextQueryData, @Nullable SyncQueryData limitExceededBucket) {
        this.queryType = queryType;
        this.queryText = queryText;
        this.nextQueryData = nextQueryData;
        this.limitExceededBucket = limitExceededBucket;
    }

    public String getQueryType() {
        return this.queryType;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Nullable
    public SyncQueryData getNextQueryData() {
        return this.nextQueryData;
    }

    @Override
    public void start(long startTick, long batchSize) {
        this.sumOfStartTicks += startTick;
        this.executionCount += batchSize;
        ++this.activeCount;
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.start(startTick, batchSize);
        }
    }

    public long getTotalDurationNanos(Ticker ticker) {
        if (this.activeCount > 0L) {
            long currTick = ticker.read();
            return this.sumOfEndTicks + currTick * this.activeCount - this.sumOfStartTicks;
        }
        return this.sumOfEndTicks - this.sumOfStartTicks;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public boolean hasTotalRows() {
        return this.totalRows != -1L;
    }

    public long getTotalRows() {
        return this.totalRows == -1L ? 0L : this.totalRows;
    }

    public boolean isActive() {
        return this.activeCount > 0L;
    }

    @Override
    public void end(long endTick) {
        this.sumOfEndTicks += endTick;
        --this.activeCount;
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.end(endTick);
        }
    }

    @Override
    public void setHasTotalRows() {
        if (this.totalRows == -1L) {
            this.totalRows = 0L;
        }
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.setHasTotalRows();
        }
    }

    @Override
    public void incrementRowCount(long inc) {
        if (this.totalRows == -1L) {
            this.totalRows = 0L;
        }
        this.totalRows += inc;
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.incrementRowCount(inc);
        }
    }

    @Override
    public void extend(long startTick) {
        this.sumOfStartTicks += startTick;
        ++this.activeCount;
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.extend(startTick);
        }
    }
}

