/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.model.MutableQuery;
import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.hash.Hashing;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class QueryCollector {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final Map<String, Map<String, MutableQuery>> queries = Maps.newHashMap();
    private final Map<String, MutableQuery> limitExceededBuckets = Maps.newHashMap();
    private final int limit;
    private final int hardLimitMultiplierWhileBuilding;
    private int queryCount;

    public QueryCollector(int limit, int hardLimitMultiplierWhileBuilding) {
        this.limit = limit;
        this.hardLimitMultiplierWhileBuilding = hardLimitMultiplierWhileBuilding;
    }

    public List<AggregateOuterClass.Aggregate.Query> toAggregateProto(SharedQueryTextCollection sharedQueryTextCollection, boolean includeActive) {
        ArrayList<AggregateOuterClass.Aggregate.Query> allQueries = Lists.newArrayListWithCapacity(Math.min(this.queryCount, this.limit) + this.queries.size());
        for (Map.Entry<String, Map<String, MutableQuery>> entry : this.queries.entrySet()) {
            for (Map.Entry<String, MutableQuery> innerEntry : entry.getValue().entrySet()) {
                allQueries.add(innerEntry.getValue().toAggregateProto(entry.getKey(), innerEntry.getKey(), sharedQueryTextCollection, includeActive));
            }
        }
        if (allQueries.size() <= this.limit) {
            for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
                allQueries.add(((MutableQuery)entry.getValue()).toAggregateProto(entry.getKey(), LIMIT_EXCEEDED_BUCKET, sharedQueryTextCollection, includeActive));
            }
            QueryCollector.sort(allQueries);
            return allQueries;
        }
        QueryCollector.sort(allQueries);
        List exceededQueries = allQueries.subList(this.limit, allQueries.size());
        allQueries = Lists.newArrayList(allQueries.subList(0, this.limit));
        Map<String, MutableQuery> map = this.copyLimitExceededBuckets();
        for (AggregateOuterClass.Aggregate.Query exceededQuery : exceededQueries) {
            String queryType = exceededQuery.getType();
            MutableQuery limitExceededBucket = map.get(queryType);
            if (limitExceededBucket == null) {
                limitExceededBucket = new MutableQuery();
                map.put(queryType, limitExceededBucket);
            }
            limitExceededBucket.add(exceededQuery);
        }
        for (Map.Entry<String, MutableQuery> entry : map.entrySet()) {
            allQueries.add(entry.getValue().toAggregateProto(entry.getKey(), LIMIT_EXCEEDED_BUCKET, sharedQueryTextCollection, includeActive));
        }
        QueryCollector.sort(allQueries);
        return allQueries;
    }

    public void mergeQuery(String queryType, String queryText, double totalDurationNanos, long executionCount, boolean hasTotalRows, long totalRows, boolean active) {
        MutableQuery aggregateQuery;
        Map<String, MutableQuery> queriesForType = this.queries.get(queryType);
        if (queriesForType == null) {
            queriesForType = Maps.newHashMap();
            this.queries.put(queryType, queriesForType);
        }
        if ((aggregateQuery = queriesForType.get(queryText)) == null) {
            if (this.queryCount < this.limit * this.hardLimitMultiplierWhileBuilding) {
                aggregateQuery = new MutableQuery();
                queriesForType.put(queryText, aggregateQuery);
                ++this.queryCount;
            } else {
                aggregateQuery = this.getOrCreateLimitExceededBucket(queryType);
            }
        }
        aggregateQuery.addToTotalDurationNanos(totalDurationNanos);
        aggregateQuery.addToExecutionCount(executionCount);
        aggregateQuery.addToTotalRows(hasTotalRows, totalRows);
        aggregateQuery.setActive(active);
    }

    public void mergeQueriesInto(QueryCollector collector) {
        for (Map.Entry<String, Map<String, MutableQuery>> entry : this.queries.entrySet()) {
            for (Map.Entry<String, MutableQuery> entry2 : entry.getValue().entrySet()) {
                MutableQuery query = entry2.getValue();
                collector.mergeQuery(entry.getKey(), entry2.getKey(), query.getTotalDurationNanos(), query.getExecutionCount(), query.hasTotalRows(), query.getTotalRows(), query.isActive());
            }
        }
        for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
            collector.mergeLimitExceededBucket(entry.getKey(), (MutableQuery)entry.getValue());
        }
    }

    public void mergeQueriesInto(org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector collector) {
        for (Map.Entry<String, Map<String, MutableQuery>> entry : this.queries.entrySet()) {
            for (Map.Entry<String, MutableQuery> entry2 : entry.getValue().entrySet()) {
                String fullQueryTextSha1;
                String truncatedQueryText;
                String fullQueryText = entry2.getKey();
                if (fullQueryText.length() > 120) {
                    truncatedQueryText = fullQueryText.substring(0, 120);
                    fullQueryTextSha1 = Hashing.sha1().hashString(fullQueryText, Charsets.UTF_8).toString();
                } else {
                    truncatedQueryText = fullQueryText;
                    fullQueryTextSha1 = null;
                }
                MutableQuery query = entry2.getValue();
                collector.mergeQuery(entry.getKey(), truncatedQueryText, fullQueryTextSha1, query.getTotalDurationNanos(), query.getExecutionCount(), query.hasTotalRows(), query.getTotalRows());
            }
        }
        for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
            MutableQuery query = (MutableQuery)entry.getValue();
            collector.mergeQuery(entry.getKey(), LIMIT_EXCEEDED_BUCKET, null, query.getTotalDurationNanos(), query.getExecutionCount(), query.hasTotalRows(), query.getTotalRows());
        }
    }

    @Nullable
    public String getFullQueryText(String fullQueryTextSha1) {
        for (Map.Entry<String, Map<String, MutableQuery>> entry : this.queries.entrySet()) {
            for (String fullQueryText : entry.getValue().keySet()) {
                String sha1;
                if (fullQueryText.length() <= 120 || !fullQueryTextSha1.equals(sha1 = Hashing.sha1().hashString(fullQueryText, Charsets.UTF_8).toString())) continue;
                return fullQueryText;
            }
        }
        return null;
    }

    private void mergeLimitExceededBucket(String queryType, MutableQuery limitExceededBucket) {
        MutableQuery query = this.getOrCreateLimitExceededBucket(queryType);
        query.add(limitExceededBucket);
    }

    private MutableQuery getOrCreateLimitExceededBucket(String queryType) {
        MutableQuery query = this.limitExceededBuckets.get(queryType);
        if (query == null) {
            query = new MutableQuery();
            this.limitExceededBuckets.put(queryType, query);
        }
        return query;
    }

    private Map<String, MutableQuery> copyLimitExceededBuckets() {
        HashMap<String, MutableQuery> copies = Maps.newHashMap();
        for (Map.Entry<String, MutableQuery> entry : this.limitExceededBuckets.entrySet()) {
            String queryType = entry.getKey();
            MutableQuery limitExceededBucket = entry.getValue();
            MutableQuery copy = new MutableQuery();
            copy.add(limitExceededBucket);
            copies.put(queryType, copy);
        }
        return copies;
    }

    private static void sort(List<AggregateOuterClass.Aggregate.Query> queries) {
        Collections.sort(queries, new Comparator<AggregateOuterClass.Aggregate.Query>(){

            @Override
            public int compare(AggregateOuterClass.Aggregate.Query left, AggregateOuterClass.Aggregate.Query right) {
                return Doubles.compare(right.getTotalDurationNanos(), left.getTotalDurationNanos());
            }
        });
    }
}

