/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.List;
import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.ImmutableTransactionTimerSnapshot;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

public class MergedThreadTimer
implements AggregatedTimer,
TransactionTimer {
    private final String name;
    private final boolean extended;
    private long totalNanos;
    private long count;
    private boolean active;
    private final List<MergedThreadTimer> childTimers;

    public static MergedThreadTimer createAuxThreadRootTimer() {
        return new MergedThreadTimer("auxiliary thread", false);
    }

    public MergedThreadTimer(String name, boolean extended) {
        this.name = name;
        this.extended = extended;
        this.childTimers = Lists.newArrayList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public long getTotalNanos() {
        return this.totalNanos;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void mergeChildTimersInto(AggregatedTimer timer) {
        for (MergedThreadTimer curr : this.childTimers) {
            String currName = curr.getName();
            boolean extended = curr.isExtended();
            AggregatedTimer matchingChildTimer = null;
            for (AggregatedTimer aggregatedTimer : timer.getChildTimers()) {
                if (!currName.equals(aggregatedTimer.getName()) || extended != aggregatedTimer.isExtended()) continue;
                matchingChildTimer = aggregatedTimer;
                break;
            }
            if (matchingChildTimer == null) {
                matchingChildTimer = timer.newChildTimer(curr.getName(), curr.isExtended());
            }
            matchingChildTimer.addDataFrom(curr);
        }
    }

    @Override
    public TransactionTimer.TransactionTimerSnapshot getSnapshot() {
        return ImmutableTransactionTimerSnapshot.builder().totalNanos(this.totalNanos).count(this.count).active(this.active).build();
    }

    public List<MergedThreadTimer> getChildTimers() {
        return this.childTimers;
    }

    @Override
    public AggregatedTimer newChildTimer(String name, boolean extended) {
        MergedThreadTimer childTimer = new MergedThreadTimer(name, extended);
        this.childTimers.add(childTimer);
        return childTimer;
    }

    @Override
    public void addDataFrom(TransactionTimer timer) {
        TransactionTimer.TransactionTimerSnapshot snapshot = timer.getSnapshot();
        this.count += snapshot.count();
        this.totalNanos += snapshot.totalNanos();
        this.active = this.active || snapshot.active();
        timer.mergeChildTimersInto(this);
    }

    public TraceOuterClass.Trace.Timer toProto() {
        TraceOuterClass.Trace.Timer.Builder builder = TraceOuterClass.Trace.Timer.newBuilder().setName(this.name).setExtended(this.extended).setTotalNanos(this.totalNanos).setCount(this.count).setActive(this.active);
        for (MergedThreadTimer childTimer : this.childTimers) {
            builder.addChildTimer(childTimer.toProto());
        }
        return builder.build();
    }
}

