/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.ImmutableTransactionTimerSnapshot;
import org.glowroot.agent.model.TimerNameImpl;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.util.Tickers;

public class AsyncTimer
implements TransactionTimer {
    private static final Ticker ticker = Tickers.getTicker();
    private final TimerNameImpl timerName;
    private volatile long startTick;
    private volatile boolean active;
    private volatile long totalNanos = 0L;

    public AsyncTimer(TimerNameImpl timerName, long startTick) {
        this.timerName = timerName;
        this.startTick = startTick;
        this.active = true;
    }

    public void end(long endTick) {
        this.totalNanos += endTick - this.startTick;
        this.active = false;
    }

    public void extend(long startTick) {
        this.startTick = startTick;
        this.active = true;
    }

    @Override
    public String getName() {
        return this.timerName.name();
    }

    @Override
    public boolean isExtended() {
        return false;
    }

    @Override
    public long getTotalNanos() {
        long totalNanos = this.totalNanos;
        if (this.active) {
            totalNanos += ticker.read() - this.startTick;
        }
        return totalNanos;
    }

    @Override
    public long getCount() {
        return 1L;
    }

    @Override
    public void mergeChildTimersInto(AggregatedTimer timer) {
    }

    public boolean active() {
        return this.active;
    }

    @Override
    public TransactionTimer.TransactionTimerSnapshot getSnapshot() {
        return ImmutableTransactionTimerSnapshot.builder().totalNanos(this.getTotalNanos()).count(1L).active(this.active).build();
    }
}

