/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.TraceCreator;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableEntries;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableQueries;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableTracePoint;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

public class LiveTraceRepositoryImpl
implements LiveTraceRepository {
    private static final String AGENT_ID = "";
    private final TransactionRegistry transactionRegistry;
    private final TraceCollector traceCollector;
    private final Clock clock;
    private final Ticker ticker;

    public LiveTraceRepositoryImpl(TransactionRegistry transactionRegistry, TraceCollector traceCollector, Clock clock, Ticker ticker) {
        this.transactionRegistry = transactionRegistry;
        this.traceCollector = traceCollector;
        this.clock = clock;
        this.ticker = ticker;
    }

    @Override
    public TraceOuterClass.Trace.Header getHeader(String agentId, String traceId) {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!transaction.getTraceId().equals(traceId)) continue;
            return this.createTraceHeader(transaction);
        }
        return null;
    }

    @Override
    @Nullable
    public LiveTraceRepository.Entries getEntries(String agentId, String traceId) {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!transaction.getTraceId().equals(traceId)) continue;
            CollectingEntryVisitor visitor = new CollectingEntryVisitor();
            transaction.visitEntries(this.ticker.read(), visitor);
            return ImmutableEntries.builder().addAllEntries(visitor.entries).addAllSharedQueryTexts(TraceCreator.toProto(transaction.getSharedQueryTexts())).build();
        }
        return null;
    }

    @Override
    @Nullable
    public LiveTraceRepository.Queries getQueries(String agentId, String traceId) {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!transaction.getTraceId().equals(traceId)) continue;
            return ImmutableQueries.builder().addAllQueries(transaction.getQueries()).addAllSharedQueryTexts(TraceCreator.toProto(transaction.getSharedQueryTexts())).build();
        }
        return null;
    }

    @Override
    @Nullable
    public ProfileOuterClass.Profile getMainThreadProfile(String agentId, String traceId) {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!transaction.getTraceId().equals(traceId)) continue;
            return transaction.getMainThreadProfileProtobuf();
        }
        return null;
    }

    @Override
    @Nullable
    public ProfileOuterClass.Profile getAuxThreadProfile(String agentId, String traceId) {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!transaction.getTraceId().equals(traceId)) continue;
            return transaction.getAuxThreadProfileProtobuf();
        }
        return null;
    }

    @Override
    @Nullable
    public TraceOuterClass.Trace getFullTrace(String agentId, String traceId) throws Exception {
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            ProfileOuterClass.Profile auxThreadProfile;
            if (!transaction.getTraceId().equals(traceId)) continue;
            CollectingTraceVisitor traceVisitor = new CollectingTraceVisitor();
            Collector.TraceReader traceReader = this.createTraceReader(transaction);
            traceReader.accept(traceVisitor);
            TraceOuterClass.Trace.Builder builder = TraceOuterClass.Trace.newBuilder().setId(traceId).setUpdate(transaction.isPartiallyStored());
            ProfileOuterClass.Profile mainThreadProfile = traceVisitor.mainThreadProfile;
            if (mainThreadProfile != null) {
                builder.setMainThreadProfile(mainThreadProfile);
            }
            if ((auxThreadProfile = traceVisitor.auxThreadProfile) != null) {
                builder.setAuxThreadProfile(auxThreadProfile);
            }
            return builder.setHeader(Preconditions.checkNotNull(traceVisitor.header)).addAllEntry(traceVisitor.entries).addAllQuery(traceVisitor.queries).addAllSharedQueryText(TraceCreator.toProto(traceVisitor.sharedQueryTexts)).build();
        }
        return null;
    }

    @Override
    public int getMatchingTraceCount(String transactionType, @Nullable String transactionName) {
        int count = 0;
        for (Transaction transaction : this.transactionRegistry.getTransactions()) {
            if (!this.matchesActive(transaction, transactionType, transactionName) || transaction.isPartiallyStored()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<LiveTraceRepository.TracePoint> getMatchingActiveTracePoints(LiveTraceRepository.TraceKind traceKind, String transactionType, @Nullable String transactionName, LiveTraceRepository.TracePointFilter filter, int limit, long captureTime, long captureTick) {
        List<LiveTraceRepository.TracePoint> activeTracePoints = Lists.newArrayList();
        for (Transaction transaction : this.transactionRegistry.getTransactions()) {
            long startTick = transaction.getStartTick();
            if (!this.matches(transaction, traceKind, transactionType, transactionName, filter) || startTick >= captureTick) continue;
            activeTracePoints.add(ImmutableTracePoint.builder().agentId(AGENT_ID).traceId(transaction.getTraceId()).captureTime(captureTime).durationNanos(captureTick - startTick).partial(true).error(transaction.getErrorMessage() != null).checkLiveTraces(true).build());
        }
        Collections.sort(activeTracePoints, Ordering.natural().reverse().onResultOf(new Function<LiveTraceRepository.TracePoint, Long>(){

            @Override
            public Long apply(@Nullable LiveTraceRepository.TracePoint tracePoint) {
                Preconditions.checkNotNull(tracePoint);
                return tracePoint.durationNanos();
            }
        }));
        if (limit != 0 && activeTracePoints.size() > limit) {
            activeTracePoints = activeTracePoints.subList(0, limit);
        }
        return activeTracePoints;
    }

    @Override
    public List<LiveTraceRepository.TracePoint> getMatchingPendingPoints(LiveTraceRepository.TraceKind traceKind, String transactionType, @Nullable String transactionName, LiveTraceRepository.TracePointFilter filter, long captureTime) {
        ArrayList<LiveTraceRepository.TracePoint> points = Lists.newArrayList();
        for (Transaction transaction : this.traceCollector.getPendingTransactions()) {
            if (!this.matches(transaction, traceKind, transactionType, transactionName, filter)) continue;
            points.add(ImmutableTracePoint.builder().agentId(AGENT_ID).traceId(transaction.getTraceId()).captureTime(transaction.getCaptureTime()).durationNanos(transaction.getDurationNanos()).partial(false).error(transaction.getErrorMessage() != null).checkLiveTraces(true).build());
        }
        return points;
    }

    @Override
    public Set<String> getTransactionTypes(String agentId) {
        HashSet<String> transactionTypes = Sets.newHashSet();
        for (Transaction transaction : Iterables.concat(this.transactionRegistry.getTransactions(), this.traceCollector.getPendingTransactions())) {
            if (!this.traceCollector.shouldStoreSlow(transaction)) continue;
            transactionTypes.add(transaction.getTransactionType());
        }
        return transactionTypes;
    }

    boolean matchesActive(Transaction transaction, String transactionType, @Nullable String transactionName) {
        if (!this.traceCollector.shouldStoreSlow(transaction)) {
            return false;
        }
        if (!transactionType.equals(transaction.getTransactionType())) {
            return false;
        }
        return transactionName == null || transactionName.equals(transaction.getTransactionName());
    }

    private TraceOuterClass.Trace.Header createTraceHeader(Transaction transaction) {
        long captureTime = this.clock.currentTimeMillis();
        long captureTick = this.ticker.read();
        if (transaction.isFullyCompleted()) {
            return TraceCreator.createCompletedTraceHeader(transaction);
        }
        return TraceCreator.createPartialTraceHeader(transaction, captureTime, captureTick);
    }

    private Collector.TraceReader createTraceReader(Transaction transaction) {
        if (transaction.isFullyCompleted()) {
            return TraceCreator.createTraceReaderForCompleted(transaction, true);
        }
        return TraceCreator.createTraceReaderForPartial(transaction, this.clock.currentTimeMillis(), this.ticker.read());
    }

    private boolean matches(Transaction transaction, LiveTraceRepository.TraceKind traceKind, String transactionType, @Nullable String transactionName, LiveTraceRepository.TracePointFilter filter) {
        ErrorMessage errorMessage = transaction.getErrorMessage();
        return this.matchesKind(transaction, traceKind) && LiveTraceRepositoryImpl.matchesTransactionType(transaction, transactionType) && LiveTraceRepositoryImpl.matchesTransactionName(transaction, transactionName) && filter.matchesDuration(transaction.getDurationNanos()) && filter.matchesHeadline(transaction.getHeadline()) && filter.matchesError(errorMessage == null ? AGENT_ID : errorMessage.message()) && filter.matchesUser(transaction.getUser()) && filter.matchesAttributes(transaction.getAttributes().asMap());
    }

    private boolean matchesKind(Transaction transaction, LiveTraceRepository.TraceKind traceKind) {
        if (traceKind == LiveTraceRepository.TraceKind.SLOW) {
            return this.traceCollector.shouldStoreSlow(transaction);
        }
        return this.traceCollector.shouldStoreError(transaction);
    }

    private static boolean matchesTransactionType(Transaction transaction, String transactionType) {
        return transactionType.equals(transaction.getTransactionType());
    }

    private static boolean matchesTransactionName(Transaction transaction, @Nullable String transactionName) {
        return transactionName == null || transactionName.equals(transaction.getTransactionName());
    }

    private static class CollectingEntryVisitor
    implements Transaction.TraceEntryVisitor {
        private final List<TraceOuterClass.Trace.Entry> entries = Lists.newArrayList();

        private CollectingEntryVisitor() {
        }

        @Override
        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            this.entries.add(entry);
        }
    }

    private static class CollectingTraceVisitor
    implements Collector.TraceVisitor {
        private final List<TraceOuterClass.Trace.Entry> entries = Lists.newArrayList();
        private List<AggregateOuterClass.Aggregate.Query> queries = ImmutableList.of();
        private List<String> sharedQueryTexts = ImmutableList.of();
        @Nullable
        private ProfileOuterClass.Profile mainThreadProfile;
        @Nullable
        private ProfileOuterClass.Profile auxThreadProfile;
        private TraceOuterClass.Trace.Header header;

        private CollectingTraceVisitor() {
        }

        @Override
        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            this.entries.add(entry);
        }

        @Override
        public void visitQueries(List<AggregateOuterClass.Aggregate.Query> queries) {
            this.queries = queries;
        }

        @Override
        public void visitSharedQueryTexts(List<String> sharedQueryTexts) {
            this.sharedQueryTexts = sharedQueryTexts;
        }

        @Override
        public void visitMainThreadProfile(ProfileOuterClass.Profile profile) {
            this.mainThreadProfile = profile;
        }

        @Override
        public void visitAuxThreadProfile(ProfileOuterClass.Profile profile) {
            this.auxThreadProfile = profile;
        }

        @Override
        public void visitHeader(TraceOuterClass.Trace.Header header) {
            this.header = header;
        }
    }
}

