/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.glowroot.agent.live.ImmutableLocation;
import org.glowroot.agent.live.ImmutableUiAnalyzedMethod;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.collect.HashMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Iterators;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Multimap;
import org.glowroot.agent.shaded.com.google.common.collect.MultimapBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.SetMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.ByteStreams;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.com.google.common.io.Resources;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.glowroot.agent.weaving.ClassNames;
import org.immutables.value.Value;

class ClasspathCache {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathCache.class);
    private final AnalyzedWorld analyzedWorld;
    @Nullable
    private final Instrumentation instrumentation;
    @GuardedBy(value="this")
    private final Set<Location> classpathLocations = Sets.newHashSet();
    @GuardedBy(value="this")
    private ImmutableMultimap<String, Location> classNameLocations = ImmutableMultimap.of();

    ClasspathCache(AnalyzedWorld analyzedWorld, @Nullable Instrumentation instrumentation) {
        this.analyzedWorld = analyzedWorld;
        this.instrumentation = instrumentation;
    }

    synchronized ImmutableList<String> getMatchingClassNames(String partialClassName, int limit) {
        this.updateCache();
        PartialClassNameMatcher matcher = new PartialClassNameMatcher(partialClassName);
        LinkedHashSet<String> fullMatchingClassNames = Sets.newLinkedHashSet();
        LinkedHashSet<String> matchingClassNames = Sets.newLinkedHashSet();
        Iterator i = ((ImmutableSet)this.classNameLocations.keySet()).iterator();
        if (this.instrumentation != null) {
            ArrayList<String> loadedClassNames = Lists.newArrayList();
            for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
                if (clazz.getName().startsWith("[")) continue;
                loadedClassNames.add(clazz.getName());
            }
            i = Iterators.concat(i, loadedClassNames.iterator());
        }
        while (i.hasNext()) {
            String className = (String)i.next();
            String classNameUpper = className.toUpperCase(Locale.ENGLISH);
            boolean potentialFullMatch = matcher.isPotentialFullMatch(classNameUpper);
            if (matchingClassNames.size() == limit && !potentialFullMatch) continue;
            if (fullMatchingClassNames.size() == limit) break;
            if (!matcher.isPotentialMatch(classNameUpper)) continue;
            if (potentialFullMatch) {
                fullMatchingClassNames.add(className);
                continue;
            }
            matchingClassNames.add(className);
        }
        return ClasspathCache.combineClassNamesWithLimit(fullMatchingClassNames, matchingClassNames, limit);
    }

    synchronized ImmutableList<UiAnalyzedMethod> getAnalyzedMethods(String className) {
        this.updateCache();
        HashSet<UiAnalyzedMethod> analyzedMethods = Sets.newHashSet();
        Collection locations = this.classNameLocations.get((Object)className);
        for (Location location : locations) {
            try {
                analyzedMethods.addAll(ClasspathCache.getAnalyzedMethods(location, className));
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (this.instrumentation != null) {
            for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
                if (!clazz.getName().equals(className)) continue;
                analyzedMethods.addAll(ClasspathCache.getAnalyzedMethods(clazz));
            }
        }
        return ImmutableList.copyOf(analyzedMethods);
    }

    synchronized void updateCache() {
        HashMultimap<String, Location> newClassNameLocations = HashMultimap.create();
        for (ClassLoader loader : this.getKnownClassLoaders()) {
            this.updateCache(loader, newClassNameLocations);
        }
        this.updateCacheWithClasspathClasses(newClassNameLocations);
        this.updateCacheWithBootstrapClasses(newClassNameLocations);
        if (!newClassNameLocations.isEmpty()) {
            SetMultimap<String, Location> newMap = MultimapBuilder.treeKeys().linkedHashSetValues().build();
            newMap.putAll(this.classNameLocations);
            newMap.putAll(newClassNameLocations);
            this.classNameLocations = ImmutableMultimap.copyOf(newMap);
        }
    }

    @GuardedBy(value="this")
    private void updateCacheWithClasspathClasses(Multimap<String, Location> newClassNameLocations) {
        String javaClassPath = StandardSystemProperty.JAVA_CLASS_PATH.value();
        if (javaClassPath == null) {
            return;
        }
        for (String path : Splitter.on(File.pathSeparatorChar).split(javaClassPath)) {
            File file = new File(path);
            Location location = ClasspathCache.getLocationFromFile(file);
            if (location == null) continue;
            this.loadClassNames(location, newClassNameLocations);
        }
    }

    @GuardedBy(value="this")
    private void updateCacheWithBootstrapClasses(Multimap<String, Location> newClassNameLocations) {
        String bootClassPath = System.getProperty("sun.boot.class.path");
        if (bootClassPath == null) {
            return;
        }
        for (String path : Splitter.on(File.pathSeparatorChar).split(bootClassPath)) {
            File file = new File(path);
            Location location = ClasspathCache.getLocationFromFile(file);
            if (location == null) continue;
            this.loadClassNames(location, newClassNameLocations);
        }
    }

    @GuardedBy(value="this")
    private void updateCache(ClassLoader loader, Multimap<String, Location> newClassNameLocations) {
        List<URL> urls = ClasspathCache.getURLs(loader);
        ArrayList<Location> locations = Lists.newArrayList();
        for (URL url : urls) {
            Location location = ClasspathCache.tryToGetFileFromURL(url, loader);
            if (location == null) continue;
            locations.add(location);
        }
        for (Location location : locations) {
            this.loadClassNames(location, newClassNameLocations);
        }
    }

    private List<ClassLoader> getKnownClassLoaders() {
        ImmutableList<ClassLoader> loaders = this.analyzedWorld.getClassLoaders();
        if (loaders.isEmpty()) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(systemClassLoader);
        }
        return loaders;
    }

    @GuardedBy(value="this")
    private void loadClassNames(Location location, Multimap<String, Location> newClassNameLocations) {
        block10: {
            if (this.classpathLocations.contains(location)) {
                return;
            }
            this.classpathLocations.add(location);
            try {
                File dir = location.directory();
                File jarFile = location.jarFile();
                if (dir != null) {
                    ClasspathCache.loadClassNamesFromDirectory(dir, "", location, newClassNameLocations);
                    break block10;
                }
                if (jarFile != null) {
                    String jarFileInsideJarFile = location.jarFileInsideJarFile();
                    String directoryInsideJarFile = location.directoryInsideJarFile();
                    if (jarFileInsideJarFile == null && directoryInsideJarFile == null) {
                        this.loadClassNamesFromJarFile(jarFile, location, newClassNameLocations);
                    } else if (jarFileInsideJarFile != null) {
                        ClasspathCache.loadClassNamesFromJarFileInsideJarFile(jarFile, jarFileInsideJarFile, location, newClassNameLocations);
                    } else {
                        Preconditions.checkNotNull(directoryInsideJarFile);
                        ClasspathCache.loadClassNamesFromDirectoryInsideJarFile(jarFile, directoryInsideJarFile, location, newClassNameLocations);
                    }
                    break block10;
                }
                throw new AssertionError((Object)"Both Location directory() and jarFile() are null");
            }
            catch (IllegalArgumentException e) {
                logger.debug(e.getMessage(), e);
            }
            catch (IOException e) {
                logger.debug("error reading classes from file: {}", (Object)location, (Object)e);
            }
        }
    }

    @GuardedBy(value="this")
    private void loadClassNamesFromJarFile(File jarFile, Location location, Multimap<String, Location> newClassNameLocations) throws IOException {
        Closer closer = Closer.create();
        try {
            InputStream in = closer.register(new FileInputStream(jarFile));
            JarInputStream jarIn = closer.register(new JarInputStream(in));
            this.loadClassNamesFromManifestClassPath(jarIn, jarFile, newClassNameLocations);
            ClasspathCache.loadClassNamesFromJarInputStream(jarIn, "", location, newClassNameLocations);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    @GuardedBy(value="this")
    private void loadClassNamesFromManifestClassPath(JarInputStream jarIn, File jarFile, Multimap<String, Location> newClassNameLocations) {
        Manifest manifest = jarIn.getManifest();
        if (manifest == null) {
            return;
        }
        String classpath = manifest.getMainAttributes().getValue("Class-Path");
        if (classpath == null) {
            return;
        }
        URI baseUri = jarFile.toURI();
        for (String path : Splitter.on(' ').omitEmptyStrings().split(classpath)) {
            File file = new File(baseUri.resolve(path));
            Location location = ClasspathCache.getLocationFromFile(file);
            if (location == null) continue;
            this.loadClassNames(location, newClassNameLocations);
        }
    }

    private static ImmutableList<String> combineClassNamesWithLimit(Set<String> fullMatchingClassNames, Set<String> matchingClassNames, int limit) {
        if (fullMatchingClassNames.size() < limit) {
            int space = limit - fullMatchingClassNames.size();
            int numToAdd = Math.min(space, matchingClassNames.size());
            fullMatchingClassNames.addAll(ImmutableList.copyOf(Iterables.limit(matchingClassNames, numToAdd)));
        }
        return ImmutableList.copyOf(fullMatchingClassNames);
    }

    private static List<UiAnalyzedMethod> getAnalyzedMethods(Location location, String className) throws IOException {
        byte[] bytes = ClasspathCache.getBytes(location, className);
        return ClasspathCache.getAnalyzedMethods(bytes);
    }

    private static List<UiAnalyzedMethod> getAnalyzedMethods(byte[] bytes) {
        AnalyzingClassVisitor cv = new AnalyzingClassVisitor();
        ClassReader cr = new ClassReader(bytes);
        cr.accept(cv, 0);
        return cv.getAnalyzedMethods();
    }

    private static List<UiAnalyzedMethod> getAnalyzedMethods(Class<?> clazz) {
        ArrayList<UiAnalyzedMethod> analyzedMethods = Lists.newArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || Modifier.isNative(method.getModifiers()) || method.getName().startsWith("glowroot$")) continue;
            ImmutableUiAnalyzedMethod.Builder builder = ImmutableUiAnalyzedMethod.builder();
            builder.name(method.getName());
            for (Class<?> parameterType : method.getParameterTypes()) {
                builder.addParameterTypes(Type.getType(parameterType).getClassName());
            }
            builder.returnType(Type.getType(method.getReturnType()).getClassName());
            builder.modifiers(method.getModifiers());
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                builder.addExceptions(exceptionType.getName());
            }
            analyzedMethods.add(builder.build());
        }
        return analyzedMethods;
    }

    @Nullable
    private static Location tryToGetFileFromURL(URL url, ClassLoader loader) {
        if (url.getProtocol().equals("vfs")) {
            try {
                return ClasspathCache.getFileFromJBossVfsURL(url, loader);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
                return null;
            }
        }
        try {
            String f;
            URI uri = url.toURI();
            if (uri.getScheme().equals("file")) {
                return ClasspathCache.getLocationFromFile(new File(uri));
            }
            if (uri.getScheme().equals("jar") && (f = uri.getSchemeSpecificPart()).startsWith("file:")) {
                return ClasspathCache.getLocationFromJarFile(f);
            }
        }
        catch (URISyntaxException e) {
            logger.debug(e.getMessage(), e);
        }
        return null;
    }

    private static List<URL> getURLs(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            try {
                return Lists.newArrayList(((URLClassLoader)loader).getURLs());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                return ImmutableList.of();
            }
        }
        try {
            return Collections.list(loader.getResources("/"));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return ImmutableList.of();
        }
    }

    private static void loadClassNamesFromDirectory(File dir, String prefix, Location location, Multimap<String, Location> newClassNameLocations) throws MalformedURLException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (file.isFile() && name.endsWith(".class")) {
                String className = prefix + name.substring(0, name.lastIndexOf(46));
                newClassNameLocations.put(className, location);
                continue;
            }
            if (!file.isDirectory()) continue;
            ClasspathCache.loadClassNamesFromDirectory(file, prefix + name + ".", location, newClassNameLocations);
        }
    }

    private static void loadClassNamesFromJarFileInsideJarFile(File jarFile, String jarFileInsideJarFile, Location location, Multimap<String, Location> newClassNameLocations) throws IOException {
        URI uri;
        try {
            uri = new URI("jar", "file:" + jarFile.getPath() + "!/" + jarFileInsideJarFile, "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Closer closer = Closer.create();
        try {
            InputStream in = closer.register(uri.toURL().openStream());
            JarInputStream jarIn = closer.register(new JarInputStream(in));
            ClasspathCache.loadClassNamesFromJarInputStream(jarIn, "", location, newClassNameLocations);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static void loadClassNamesFromDirectoryInsideJarFile(File jarFile, String directoryInsideJarFile, Location location, Multimap<String, Location> newClassNameLocations) throws IOException {
        Closer closer = Closer.create();
        try {
            InputStream in = closer.register(new FileInputStream(jarFile));
            JarInputStream jarIn = closer.register(new JarInputStream(in));
            ClasspathCache.loadClassNamesFromJarInputStream(jarIn, directoryInsideJarFile, location, newClassNameLocations);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static void loadClassNamesFromJarInputStream(JarInputStream jarIn, String directory, Location location, Multimap<String, Location> newClassNameLocations) throws IOException {
        JarEntry jarEntry;
        while ((jarEntry = jarIn.getNextJarEntry()) != null) {
            String name;
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).startsWith(directory) || !name.endsWith(".class")) continue;
            name = name.substring(directory.length());
            String className = name.substring(0, name.lastIndexOf(46)).replace('/', '.');
            newClassNameLocations.put(className, location);
        }
    }

    @Nullable
    private static Location getFileFromJBossVfsURL(URL url, ClassLoader loader) throws Exception {
        Object virtualFile = url.openConnection().getContent();
        Class<?> virtualFileClass = loader.loadClass("org.jboss.vfs.VirtualFile");
        Method getPhysicalFileMethod = virtualFileClass.getMethod("getPhysicalFile", new Class[0]);
        Method getNameMethod = virtualFileClass.getMethod("getName", new Class[0]);
        File physicalFile = (File)getPhysicalFileMethod.invoke(virtualFile, new Object[0]);
        Preconditions.checkNotNull(physicalFile, "org.jboss.vfs.VirtualFile.getPhysicalFile() returned null");
        String name = (String)getNameMethod.invoke(virtualFile, new Object[0]);
        Preconditions.checkNotNull(name, "org.jboss.vfs.VirtualFile.getName() returned null");
        File file = new File(physicalFile.getParentFile(), name);
        return ClasspathCache.getLocationFromFile(file);
    }

    @Nullable
    private static Location getLocationFromFile(File file) {
        boolean exists = file.exists();
        if (exists && file.isDirectory()) {
            return ImmutableLocation.builder().directory(file).build();
        }
        if (exists && file.getName().endsWith(".jar")) {
            return ImmutableLocation.builder().jarFile(file).build();
        }
        return null;
    }

    private static Location getLocationFromJarFile(String f) {
        int index = f.indexOf("!/");
        File jarFile = new File(f.substring(5, index));
        String pathInsideJarFile = f.substring(index + 2);
        if (pathInsideJarFile.isEmpty()) {
            return ImmutableLocation.builder().jarFile(jarFile).build();
        }
        if ((pathInsideJarFile = pathInsideJarFile.substring(0, pathInsideJarFile.length() - 2)).endsWith(".jar")) {
            return ImmutableLocation.builder().jarFile(jarFile).jarFileInsideJarFile(pathInsideJarFile).build();
        }
        if (!pathInsideJarFile.endsWith("/")) {
            pathInsideJarFile = pathInsideJarFile + "/";
        }
        return ImmutableLocation.builder().jarFile(jarFile).directoryInsideJarFile(pathInsideJarFile).build();
    }

    private static byte[] getBytes(Location location, String className) throws IOException {
        String name = className.replace('.', '/') + ".class";
        File dir = location.directory();
        File jarFile = location.jarFile();
        if (dir != null) {
            URI uri = new File(dir, name).toURI();
            return Resources.toByteArray(uri.toURL());
        }
        if (jarFile != null) {
            String jarFileInsideJarFile = location.jarFileInsideJarFile();
            String directoryInsideJarFile = location.directoryInsideJarFile();
            if (jarFileInsideJarFile == null && directoryInsideJarFile == null) {
                return ClasspathCache.getBytesFromJarFile(name, jarFile);
            }
            if (jarFileInsideJarFile != null) {
                return ClasspathCache.getBytesFromJarFileInsideJarFile(name, jarFile, jarFileInsideJarFile);
            }
            Preconditions.checkNotNull(directoryInsideJarFile);
            return ClasspathCache.getBytesFromDirectoryInsideJarFile(name, jarFile, directoryInsideJarFile);
        }
        throw new AssertionError((Object)"Both Location directory() and jarFile() are null");
    }

    private static byte[] getBytesFromJarFile(String name, File jarFile) throws IOException {
        URI uri;
        String path = jarFile.getPath();
        try {
            uri = new URI("jar", "file:" + path + "!/" + name, "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Resources.toByteArray(uri.toURL());
    }

    private static byte[] getBytesFromJarFileInsideJarFile(String name, File jarFile, String jarFileInsideJarFile) throws IOException {
        URI uri;
        String path = jarFile.getPath();
        try {
            uri = new URI("jar", "file:" + path + "!/" + jarFileInsideJarFile, "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Closer closer = Closer.create();
        try {
            JarEntry jarEntry;
            InputStream in = closer.register(uri.toURL().openStream());
            JarInputStream jarIn = closer.register(new JarInputStream(in));
            while ((jarEntry = jarIn.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory() || !jarEntry.getName().equals(name)) continue;
                byte[] byArray = ByteStreams.toByteArray(jarIn);
                return byArray;
            }
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        throw new UnsupportedOperationException();
    }

    private static byte[] getBytesFromDirectoryInsideJarFile(String name, File jarFile, String directoryInsideJarFile) throws IOException {
        URI uri;
        String path = jarFile.getPath();
        try {
            uri = new URI("jar", "file:" + path + "!/" + directoryInsideJarFile + name, "");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Resources.toByteArray(uri.toURL());
    }

    @Value.Immutable
    static interface Location {
        @Nullable
        public File directory();

        @Nullable
        public File jarFile();

        @Nullable
        public String jarFileInsideJarFile();

        @Nullable
        public String directoryInsideJarFile();
    }

    private static class AnalyzingClassVisitor
    extends ClassVisitor {
        private final List<UiAnalyzedMethod> analyzedMethods = Lists.newArrayList();

        private AnalyzingClassVisitor() {
            super(458752);
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            if ((access & 0x1000) != 0 || (access & 0x100) != 0) {
                return null;
            }
            if (name.equals("<init>")) {
                return null;
            }
            ImmutableUiAnalyzedMethod.Builder builder = ImmutableUiAnalyzedMethod.builder();
            builder.name(name);
            for (Type parameterType : Type.getArgumentTypes(descriptor)) {
                builder.addParameterTypes(parameterType.getClassName());
            }
            builder.returnType(Type.getReturnType(descriptor).getClassName());
            builder.modifiers(access);
            if (exceptions != null) {
                for (String exception : exceptions) {
                    builder.addExceptions(ClassNames.fromInternalName(exception));
                }
            }
            this.analyzedMethods.add(builder.build());
            return null;
        }

        private List<UiAnalyzedMethod> getAnalyzedMethods() {
            return this.analyzedMethods;
        }
    }

    private static class PartialClassNameMatcher {
        private final String partialClassNameUpper;
        private final String prefixedPartialClassNameUpper1;
        private final String prefixedPartialClassNameUpper2;

        private PartialClassNameMatcher(String partialClassName) {
            this.partialClassNameUpper = partialClassName.toUpperCase(Locale.ENGLISH);
            this.prefixedPartialClassNameUpper1 = '.' + this.partialClassNameUpper;
            this.prefixedPartialClassNameUpper2 = '$' + this.partialClassNameUpper;
        }

        private boolean isPotentialFullMatch(String classNameUpper) {
            return classNameUpper.equals(this.partialClassNameUpper) || classNameUpper.endsWith(this.prefixedPartialClassNameUpper1) || classNameUpper.endsWith(this.prefixedPartialClassNameUpper2);
        }

        private boolean isPotentialMatch(String classNameUpper) {
            return classNameUpper.startsWith(this.partialClassNameUpper) || classNameUpper.contains(this.prefixedPartialClassNameUpper1) || classNameUpper.contains(this.prefixedPartialClassNameUpper2);
        }
    }

    @Value.Immutable(prehash=true)
    static interface UiAnalyzedMethod {
        public String name();

        public ImmutableList<String> parameterTypes();

        public String returnType();

        public int modifiers();

        @Nullable
        public String signature();

        public ImmutableList<String> exceptions();
    }
}

