/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.glowroot.agent.config.ImmutablePluginDescriptor;
import org.glowroot.agent.config.ImmutablePropertyDescriptor;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PluginDescriptor {
    public abstract String id();

    public abstract String name();

    public abstract ImmutableList<PropertyDescriptor> properties();

    @JsonProperty(value="instrumentation")
    public abstract ImmutableList<InstrumentationConfig> instrumentationConfigs();

    public abstract ImmutableList<String> aspects();

    @Value.Default
    public boolean collocate() {
        return false;
    }

    @JsonIgnore
    @Nullable
    public abstract File pluginJar();

    public static PluginDescriptor readValue(String content) throws IOException {
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(InstrumentationConfig.class, ImmutableInstrumentationConfig.class);
        module.addAbstractTypeMapping(PropertyDescriptor.class, ImmutablePropertyDescriptor.class);
        ObjectMapper mapper = ObjectMappers.create(module);
        return mapper.readValue(content, ImmutablePluginDescriptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeValue(List<PluginDescriptor> pluginDescriptors) throws IOException {
        ObjectMapper mapper = ObjectMappers.create(new Module[0]);
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));
        try {
            jg.setPrettyPrinter(ObjectMappers.getPrettyPrinter());
            jg.writeStartArray();
            for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
                ObjectNode objectNode = (ObjectNode)mapper.valueToTree(pluginDescriptor);
                ObjectMappers.stripEmptyContainerNodes(objectNode);
                jg.writeTree(objectNode);
            }
            jg.writeEndArray();
        }
        finally {
            jg.close();
        }
        sb.append(ObjectMappers.NEWLINE);
        return sb.toString();
    }
}

