/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.config.AllConfig;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AllConfig", generator="Immutables")
@Immutable
public final class ImmutableAllConfig
extends AllConfig {
    private final TransactionConfig transaction;
    private final JvmConfig jvm;
    private final UiDefaultsConfig uiDefaults;
    private final AdvancedConfig advanced;
    private final ImmutableList<GaugeConfig> gauges;
    private final ImmutableList<SyntheticMonitorConfig> syntheticMonitors;
    private final ImmutableList<AlertConfig> alerts;
    private final ImmutableList<PluginConfig> plugins;
    private final ImmutableList<InstrumentationConfig> instrumentation;

    private ImmutableAllConfig(TransactionConfig transaction, JvmConfig jvm, UiDefaultsConfig uiDefaults, AdvancedConfig advanced, ImmutableList<GaugeConfig> gauges, ImmutableList<SyntheticMonitorConfig> syntheticMonitors, ImmutableList<AlertConfig> alerts, ImmutableList<PluginConfig> plugins, ImmutableList<InstrumentationConfig> instrumentation) {
        this.transaction = transaction;
        this.jvm = jvm;
        this.uiDefaults = uiDefaults;
        this.advanced = advanced;
        this.gauges = gauges;
        this.syntheticMonitors = syntheticMonitors;
        this.alerts = alerts;
        this.plugins = plugins;
        this.instrumentation = instrumentation;
    }

    @Override
    @JsonProperty(value="transaction")
    TransactionConfig transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="jvm")
    JvmConfig jvm() {
        return this.jvm;
    }

    @Override
    @JsonProperty(value="uiDefaults")
    UiDefaultsConfig uiDefaults() {
        return this.uiDefaults;
    }

    @Override
    @JsonProperty(value="advanced")
    AdvancedConfig advanced() {
        return this.advanced;
    }

    @JsonProperty(value="gauges")
    ImmutableList<GaugeConfig> gauges() {
        return this.gauges;
    }

    @JsonProperty(value="syntheticMonitors")
    ImmutableList<SyntheticMonitorConfig> syntheticMonitors() {
        return this.syntheticMonitors;
    }

    @JsonProperty(value="alerts")
    ImmutableList<AlertConfig> alerts() {
        return this.alerts;
    }

    @JsonProperty(value="plugins")
    ImmutableList<PluginConfig> plugins() {
        return this.plugins;
    }

    @JsonProperty(value="instrumentation")
    ImmutableList<InstrumentationConfig> instrumentation() {
        return this.instrumentation;
    }

    public final ImmutableAllConfig withTransaction(TransactionConfig value) {
        if (this.transaction == value) {
            return this;
        }
        TransactionConfig newValue = Preconditions.checkNotNull(value, "transaction");
        return new ImmutableAllConfig(newValue, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withJvm(JvmConfig value) {
        if (this.jvm == value) {
            return this;
        }
        JvmConfig newValue = Preconditions.checkNotNull(value, "jvm");
        return new ImmutableAllConfig(this.transaction, newValue, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withUiDefaults(UiDefaultsConfig value) {
        if (this.uiDefaults == value) {
            return this;
        }
        UiDefaultsConfig newValue = Preconditions.checkNotNull(value, "uiDefaults");
        return new ImmutableAllConfig(this.transaction, this.jvm, newValue, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withAdvanced(AdvancedConfig value) {
        if (this.advanced == value) {
            return this;
        }
        AdvancedConfig newValue = Preconditions.checkNotNull(value, "advanced");
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, newValue, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withGauges(GaugeConfig ... elements) {
        ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, newValue, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withGauges(Iterable<? extends GaugeConfig> elements) {
        if (this.gauges == elements) {
            return this;
        }
        ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, newValue, this.syntheticMonitors, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withSyntheticMonitors(SyntheticMonitorConfig ... elements) {
        ImmutableList<SyntheticMonitorConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, newValue, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withSyntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
        if (this.syntheticMonitors == elements) {
            return this;
        }
        ImmutableList<SyntheticMonitorConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, newValue, this.alerts, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withAlerts(AlertConfig ... elements) {
        ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, newValue, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withAlerts(Iterable<? extends AlertConfig> elements) {
        if (this.alerts == elements) {
            return this;
        }
        ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, newValue, this.plugins, this.instrumentation);
    }

    public final ImmutableAllConfig withPlugins(PluginConfig ... elements) {
        ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, newValue, this.instrumentation);
    }

    public final ImmutableAllConfig withPlugins(Iterable<? extends PluginConfig> elements) {
        if (this.plugins == elements) {
            return this;
        }
        ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, newValue, this.instrumentation);
    }

    public final ImmutableAllConfig withInstrumentation(InstrumentationConfig ... elements) {
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, newValue);
    }

    public final ImmutableAllConfig withInstrumentation(Iterable<? extends InstrumentationConfig> elements) {
        if (this.instrumentation == elements) {
            return this;
        }
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, this.gauges, this.syntheticMonitors, this.alerts, this.plugins, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllConfig && this.equalTo((ImmutableAllConfig)another);
    }

    private boolean equalTo(ImmutableAllConfig another) {
        return this.transaction.equals(another.transaction) && this.jvm.equals(another.jvm) && this.uiDefaults.equals(another.uiDefaults) && this.advanced.equals(another.advanced) && this.gauges.equals(another.gauges) && this.syntheticMonitors.equals(another.syntheticMonitors) && this.alerts.equals(another.alerts) && this.plugins.equals(another.plugins) && this.instrumentation.equals(another.instrumentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + this.jvm.hashCode();
        h += (h << 5) + this.uiDefaults.hashCode();
        h += (h << 5) + this.advanced.hashCode();
        h += (h << 5) + this.gauges.hashCode();
        h += (h << 5) + this.syntheticMonitors.hashCode();
        h += (h << 5) + this.alerts.hashCode();
        h += (h << 5) + this.plugins.hashCode();
        h += (h << 5) + this.instrumentation.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AllConfig").omitNullValues().add("transaction", this.transaction).add("jvm", this.jvm).add("uiDefaults", this.uiDefaults).add("advanced", this.advanced).add("gauges", this.gauges).add("syntheticMonitors", this.syntheticMonitors).add("alerts", this.alerts).add("plugins", this.plugins).add("instrumentation", this.instrumentation).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAllConfig fromJson(Json json) {
        Builder builder = ImmutableAllConfig.builder();
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.jvm != null) {
            builder.jvm(json.jvm);
        }
        if (json.uiDefaults != null) {
            builder.uiDefaults(json.uiDefaults);
        }
        if (json.advanced != null) {
            builder.advanced(json.advanced);
        }
        if (json.gauges != null) {
            builder.addAllGauges(json.gauges);
        }
        if (json.syntheticMonitors != null) {
            builder.addAllSyntheticMonitors(json.syntheticMonitors);
        }
        if (json.alerts != null) {
            builder.addAllAlerts(json.alerts);
        }
        if (json.plugins != null) {
            builder.addAllPlugins(json.plugins);
        }
        if (json.instrumentation != null) {
            builder.addAllInstrumentation(json.instrumentation);
        }
        return builder.build();
    }

    public static ImmutableAllConfig copyOf(AllConfig instance) {
        if (instance instanceof ImmutableAllConfig) {
            return (ImmutableAllConfig)instance;
        }
        return ImmutableAllConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AllConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long INIT_BIT_JVM = 2L;
        private static final long INIT_BIT_UI_DEFAULTS = 4L;
        private static final long INIT_BIT_ADVANCED = 8L;
        private long initBits = 15L;
        @Nullable
        private TransactionConfig transaction;
        @Nullable
        private JvmConfig jvm;
        @Nullable
        private UiDefaultsConfig uiDefaults;
        @Nullable
        private AdvancedConfig advanced;
        private ImmutableList.Builder<GaugeConfig> gauges = ImmutableList.builder();
        private ImmutableList.Builder<SyntheticMonitorConfig> syntheticMonitors = ImmutableList.builder();
        private ImmutableList.Builder<AlertConfig> alerts = ImmutableList.builder();
        private ImmutableList.Builder<PluginConfig> plugins = ImmutableList.builder();
        private ImmutableList.Builder<InstrumentationConfig> instrumentation = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AllConfig instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.transaction(instance.transaction());
            this.jvm(instance.jvm());
            this.uiDefaults(instance.uiDefaults());
            this.advanced(instance.advanced());
            this.addAllGauges(instance.gauges());
            this.addAllSyntheticMonitors(instance.syntheticMonitors());
            this.addAllAlerts(instance.alerts());
            this.addAllPlugins(instance.plugins());
            this.addAllInstrumentation(instance.instrumentation());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transaction(TransactionConfig transaction) {
            this.transaction = Preconditions.checkNotNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jvm(JvmConfig jvm) {
            this.jvm = Preconditions.checkNotNull(jvm, "jvm");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uiDefaults(UiDefaultsConfig uiDefaults) {
            this.uiDefaults = Preconditions.checkNotNull(uiDefaults, "uiDefaults");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder advanced(AdvancedConfig advanced) {
            this.advanced = Preconditions.checkNotNull(advanced, "advanced");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGauges(GaugeConfig element) {
            this.gauges.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGauges(GaugeConfig ... elements) {
            this.gauges.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gauges(Iterable<? extends GaugeConfig> elements) {
            this.gauges = ImmutableList.builder();
            return this.addAllGauges(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGauges(Iterable<? extends GaugeConfig> elements) {
            this.gauges.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSyntheticMonitors(SyntheticMonitorConfig element) {
            this.syntheticMonitors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSyntheticMonitors(SyntheticMonitorConfig ... elements) {
            this.syntheticMonitors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder syntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
            this.syntheticMonitors = ImmutableList.builder();
            return this.addAllSyntheticMonitors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSyntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
            this.syntheticMonitors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlerts(AlertConfig element) {
            this.alerts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlerts(AlertConfig ... elements) {
            this.alerts.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder alerts(Iterable<? extends AlertConfig> elements) {
            this.alerts = ImmutableList.builder();
            return this.addAllAlerts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAlerts(Iterable<? extends AlertConfig> elements) {
            this.alerts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlugins(PluginConfig element) {
            this.plugins.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlugins(PluginConfig ... elements) {
            this.plugins.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder plugins(Iterable<? extends PluginConfig> elements) {
            this.plugins = ImmutableList.builder();
            return this.addAllPlugins(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPlugins(Iterable<? extends PluginConfig> elements) {
            this.plugins.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentation(InstrumentationConfig element) {
            this.instrumentation.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstrumentation(InstrumentationConfig ... elements) {
            this.instrumentation.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instrumentation(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentation = ImmutableList.builder();
            return this.addAllInstrumentation(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstrumentation(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentation.addAll(elements);
            return this;
        }

        public ImmutableAllConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAllConfig(this.transaction, this.jvm, this.uiDefaults, this.advanced, (ImmutableList)this.gauges.build(), (ImmutableList)this.syntheticMonitors.build(), (ImmutableList)this.alerts.build(), (ImmutableList)this.plugins.build(), (ImmutableList)this.instrumentation.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("jvm");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uiDefaults");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("advanced");
            }
            return "Cannot build AllConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AllConfig", generator="Immutables")
    static final class Json
    extends AllConfig {
        @Nullable
        TransactionConfig transaction;
        @Nullable
        JvmConfig jvm;
        @Nullable
        UiDefaultsConfig uiDefaults;
        @Nullable
        AdvancedConfig advanced;
        @Nullable
        List<GaugeConfig> gauges = ImmutableList.of();
        @Nullable
        List<SyntheticMonitorConfig> syntheticMonitors = ImmutableList.of();
        @Nullable
        List<AlertConfig> alerts = ImmutableList.of();
        @Nullable
        List<PluginConfig> plugins = ImmutableList.of();
        @Nullable
        List<InstrumentationConfig> instrumentation = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="transaction")
        public void setTransaction(TransactionConfig transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="jvm")
        public void setJvm(JvmConfig jvm) {
            this.jvm = jvm;
        }

        @JsonProperty(value="uiDefaults")
        public void setUiDefaults(UiDefaultsConfig uiDefaults) {
            this.uiDefaults = uiDefaults;
        }

        @JsonProperty(value="advanced")
        public void setAdvanced(AdvancedConfig advanced) {
            this.advanced = advanced;
        }

        @JsonProperty(value="gauges")
        public void setGauges(List<GaugeConfig> gauges) {
            this.gauges = gauges;
        }

        @JsonProperty(value="syntheticMonitors")
        public void setSyntheticMonitors(List<SyntheticMonitorConfig> syntheticMonitors) {
            this.syntheticMonitors = syntheticMonitors;
        }

        @JsonProperty(value="alerts")
        public void setAlerts(List<AlertConfig> alerts) {
            this.alerts = alerts;
        }

        @JsonProperty(value="plugins")
        public void setPlugins(List<PluginConfig> plugins) {
            this.plugins = plugins;
        }

        @JsonProperty(value="instrumentation")
        public void setInstrumentation(List<InstrumentationConfig> instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        TransactionConfig transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        JvmConfig jvm() {
            throw new UnsupportedOperationException();
        }

        @Override
        UiDefaultsConfig uiDefaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        AdvancedConfig advanced() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<GaugeConfig> gauges() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<SyntheticMonitorConfig> syntheticMonitors() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<AlertConfig> alerts() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<PluginConfig> plugins() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<InstrumentationConfig> instrumentation() {
            throw new UnsupportedOperationException();
        }
    }
}

