/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glowroot.agent.central.CentralConnection;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.EquivalentAddressGroup;
import org.glowroot.agent.shaded.io.grpc.NameResolver;
import org.glowroot.agent.shaded.io.grpc.NameResolverProvider;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.DnsNameResolverProvider;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

class MultipleAddressNameResolverFactory
extends NameResolver.Factory {
    private final List<CentralConnection.CollectorTarget> targets;
    private final String authority;

    MultipleAddressNameResolverFactory(List<CentralConnection.CollectorTarget> targets, String authority) {
        this.targets = targets;
        this.authority = authority;
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        return new MultipleAddressNameResolver(this.targets, this.authority, params);
    }

    @Override
    public String getDefaultScheme() {
        return "dummy-scheme";
    }

    private static class AggregatingListener
    implements NameResolver.Listener {
        private final NameResolver.Listener listener;
        private final List<NameResolver> nameResolvers;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private final List<EquivalentAddressGroup> servers = Lists.newArrayList();
        @GuardedBy(value="lock")
        @MonotonicNonNull
        private Attributes attributes;
        @GuardedBy(value="lock")
        private int onAddressesCount;
        @GuardedBy(value="lock")
        private boolean closed;

        public AggregatingListener(NameResolver.Listener listener, List<NameResolver> nameResolvers) {
            this.listener = listener;
            this.nameResolvers = nameResolvers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.servers.addAll(servers);
                if (this.attributes == null) {
                    this.attributes = attributes;
                } else if (!attributes.equals(this.attributes)) {
                    throw new IllegalStateException("New attributes \"" + attributes + "\" are not the same as existing attributes: " + this.attributes);
                }
                if (++this.onAddressesCount == this.nameResolvers.size()) {
                    Collections.shuffle(this.servers);
                    this.listener.onAddresses(this.servers, attributes);
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Status error) {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.listener.onError(error);
                this.close();
            }
        }

        @GuardedBy(value="lock")
        private void close() {
            for (NameResolver nameResolver : this.nameResolvers) {
                nameResolver.shutdown();
            }
            this.closed = true;
        }
    }

    static class MultipleAddressNameResolver
    extends NameResolver {
        private final NameResolverProvider nameResolverProvider = new DnsNameResolverProvider();
        private final List<CentralConnection.CollectorTarget> targets;
        private final String authority;
        private final Attributes params;
        @Nullable
        private volatile NameResolver.Listener listener;

        private MultipleAddressNameResolver(List<CentralConnection.CollectorTarget> targets, String authority, Attributes params) {
            this.targets = targets;
            this.authority = authority;
            this.params = params;
        }

        @Override
        public String getServiceAuthority() {
            return this.authority;
        }

        @Override
        public void start(NameResolver.Listener listener) {
            this.listener = listener;
            this.resolve();
        }

        @Override
        public void refresh() {
            this.resolve();
        }

        public void resolve() {
            ArrayList<NameResolver> nameResolvers = Lists.newArrayList();
            for (CentralConnection.CollectorTarget target : this.targets) {
                URI collectorURI;
                try {
                    collectorURI = new URI(this.nameResolverProvider.getDefaultScheme(), "", "/" + target.host() + ":" + target.port(), null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
                nameResolvers.add(Preconditions.checkNotNull(this.nameResolverProvider.newNameResolver(collectorURI, this.params)));
            }
            AggregatingListener aggregatingListener = new AggregatingListener(Preconditions.checkNotNull(this.listener), nameResolvers);
            for (NameResolver nameResolver : nameResolvers) {
                nameResolver.start(aggregatingListener);
            }
        }

        @Override
        public void shutdown() {
        }
    }
}

