/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.central.CentralConnection;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CentralConnection.ParsedCollectorAddress", generator="Immutables")
@Immutable
final class ImmutableParsedCollectorAddress
implements CentralConnection.ParsedCollectorAddress {
    private final boolean https;
    private final ImmutableList<CentralConnection.CollectorTarget> targets;

    private ImmutableParsedCollectorAddress(boolean https, ImmutableList<CentralConnection.CollectorTarget> targets) {
        this.https = https;
        this.targets = targets;
    }

    @Override
    @JsonProperty(value="https")
    public boolean https() {
        return this.https;
    }

    @JsonProperty(value="targets")
    public ImmutableList<CentralConnection.CollectorTarget> targets() {
        return this.targets;
    }

    public final ImmutableParsedCollectorAddress withHttps(boolean value) {
        if (this.https == value) {
            return this;
        }
        return new ImmutableParsedCollectorAddress(value, this.targets);
    }

    public final ImmutableParsedCollectorAddress withTargets(CentralConnection.CollectorTarget ... elements) {
        ImmutableList<CentralConnection.CollectorTarget> newValue = ImmutableList.copyOf(elements);
        return new ImmutableParsedCollectorAddress(this.https, newValue);
    }

    public final ImmutableParsedCollectorAddress withTargets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
        if (this.targets == elements) {
            return this;
        }
        ImmutableList<CentralConnection.CollectorTarget> newValue = ImmutableList.copyOf(elements);
        return new ImmutableParsedCollectorAddress(this.https, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParsedCollectorAddress && this.equalTo((ImmutableParsedCollectorAddress)another);
    }

    private boolean equalTo(ImmutableParsedCollectorAddress another) {
        return this.https == another.https && this.targets.equals(another.targets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.https);
        h += (h << 5) + this.targets.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ParsedCollectorAddress").omitNullValues().add("https", this.https).add("targets", this.targets).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableParsedCollectorAddress fromJson(Json json) {
        Builder builder = ImmutableParsedCollectorAddress.builder();
        if (json.httpsIsSet) {
            builder.https(json.https);
        }
        if (json.targets != null) {
            builder.addAllTargets(json.targets);
        }
        return builder.build();
    }

    public static ImmutableParsedCollectorAddress copyOf(CentralConnection.ParsedCollectorAddress instance) {
        if (instance instanceof ImmutableParsedCollectorAddress) {
            return (ImmutableParsedCollectorAddress)instance;
        }
        return ImmutableParsedCollectorAddress.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CentralConnection.ParsedCollectorAddress", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HTTPS = 1L;
        private long initBits = 1L;
        private boolean https;
        private ImmutableList.Builder<CentralConnection.CollectorTarget> targets = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(CentralConnection.ParsedCollectorAddress instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.https(instance.https());
            this.addAllTargets(instance.targets());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder https(boolean https) {
            this.https = https;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTargets(CentralConnection.CollectorTarget element) {
            this.targets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTargets(CentralConnection.CollectorTarget ... elements) {
            this.targets.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
            this.targets = ImmutableList.builder();
            return this.addAllTargets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTargets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
            this.targets.addAll(elements);
            return this;
        }

        public ImmutableParsedCollectorAddress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParsedCollectorAddress(this.https, (ImmutableList)this.targets.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("https");
            }
            return "Cannot build ParsedCollectorAddress, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CentralConnection.ParsedCollectorAddress", generator="Immutables")
    static final class Json
    implements CentralConnection.ParsedCollectorAddress {
        boolean https;
        boolean httpsIsSet;
        @Nullable
        List<CentralConnection.CollectorTarget> targets = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="https")
        public void setHttps(boolean https) {
            this.https = https;
            this.httpsIsSet = true;
        }

        @JsonProperty(value="targets")
        public void setTargets(List<CentralConnection.CollectorTarget> targets) {
            this.targets = targets;
        }

        @Override
        public boolean https() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CentralConnection.CollectorTarget> targets() {
            throw new UnsupportedOperationException();
        }
    }
}

