/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.bytecode.api;

import org.glowroot.agent.bytecode.api.BytecodeService;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class BytecodeServiceHolder {
    @Nullable
    private static volatile BytecodeService service;
    private static volatile boolean glowrootFailedToStart;

    private BytecodeServiceHolder() {
    }

    public static BytecodeService get() {
        if (service == null) {
            ClassLoader loader = BytecodeServiceHolder.class.getClassLoader();
            if (loader == null) {
                throw new RuntimeException("Bytecode service retrieved too early");
            }
            throw new RuntimeException("Bytecode service retrieved from class loader: " + loader);
        }
        return service;
    }

    public static void set(BytecodeService service) {
        BytecodeServiceHolder.service = service;
    }

    public static void setGlowrootFailedToStart() {
        glowrootFailedToStart = true;
    }

    static boolean isGlowrootFailedToStart() {
        return glowrootFailedToStart;
    }
}

