/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import org.glowroot.agent.AgentPremain;
import org.glowroot.agent.Directories;
import org.glowroot.agent.MainEntryPoint;
import org.glowroot.agent.shaded.org.glowroot.common.util.Version;

public abstract class ToolMain {
    public static void main(String[] args) throws Exception {
        CodeSource codeSource = AgentPremain.class.getProtectionDomain().getCodeSource();
        File glowrootJarFile = AgentPremain.getGlowrootJarFile(codeSource);
        Directories directories = new Directories(glowrootJarFile);
        MainEntryPoint.initLogging(directories.getConfDirs(), directories.getLogDir(), directories.getLoggingLogstashJarFile(), null);
        if (args.length == 1 && args[0].equals("version")) {
            System.out.println(Version.getVersion(MainEntryPoint.class));
            return;
        }
        File embeddedCollectorJarFile = Directories.getEmbeddedCollectorJarFile(glowrootJarFile);
        if (embeddedCollectorJarFile == null) {
            System.err.println("missing lib/glowroot-embedded-collector.jar");
            return;
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{embeddedCollectorJarFile.toURI().toURL()});
        Class<?> clazz = Class.forName("org.glowroot.agent.embedded.ToolMain", true, loader);
        Method method = clazz.getMethod("main", String[].class, Directories.class);
        method.invoke(null, args, directories);
    }
}

