/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.Files;

class PropertiesFiles {
    private PropertiesFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void upgradeIfNeededAndLoadInto(File confDir, Map<String, String> properties) throws IOException {
        File propFile = new File(confDir, "glowroot.properties");
        if (!propFile.exists()) {
            return;
        }
        org.glowroot.agent.shaded.org.glowroot.common.util.PropertiesFiles.upgradeIfNeeded(propFile, ImmutableMap.of("agent.rollup=", "agent.rollup.id="));
        PropertiesFiles.upgradeToCollectorAddressIfNeeded(propFile);
        PropertiesFiles.addSchemeToCollectorAddressIfNeeded(propFile);
        PropertiesFiles.prependAgentRollupToAgentIdIfNeeded(propFile);
        FileInputStream in = new FileInputStream(propFile);
        Properties props = new Properties();
        try {
            props.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            if (value == null || value.isEmpty()) continue;
            properties.put("glowroot." + key, value.trim());
        }
    }

    private static void upgradeToCollectorAddressIfNeeded(File propFile) throws IOException {
        List<String> lines = PropertiesFiles.readPropertiesFile(propFile);
        List<String> newLines = PropertiesFiles.upgradeToCollectorAddressIfNeeded(lines);
        if (!newLines.equals(lines)) {
            PropertiesFiles.writePropertiesFile(propFile, newLines);
        }
    }

    static List<String> upgradeToCollectorAddressIfNeeded(List<String> lines) {
        ArrayList<String> newLines = Lists.newArrayList();
        String host = null;
        String port = null;
        int indexForAddress = -1;
        for (String line : lines) {
            if (line.startsWith("collector.host=")) {
                host = line.substring("collector.host=".length());
                if (indexForAddress != -1) continue;
                indexForAddress = newLines.size();
                continue;
            }
            if (line.startsWith("collector.port=")) {
                port = line.substring("collector.port=".length());
                if (indexForAddress != -1) continue;
                indexForAddress = newLines.size();
                continue;
            }
            if (line.startsWith("collector.address=")) {
                return lines;
            }
            newLines.add(line);
        }
        if (indexForAddress == -1) {
            return newLines;
        }
        if (host == null) {
            return newLines;
        }
        if (host.isEmpty()) {
            newLines.add(indexForAddress, "collector.address=");
            return newLines;
        }
        if (port == null || port.isEmpty()) {
            port = "8181";
        }
        newLines.add(indexForAddress, "collector.address=" + host + ":" + port);
        return newLines;
    }

    private static void addSchemeToCollectorAddressIfNeeded(File propFile) throws IOException {
        List<String> lines = PropertiesFiles.readPropertiesFile(propFile);
        List<String> newLines = PropertiesFiles.addSchemeToCollectorAddressIfNeeded(lines);
        if (!newLines.equals(lines)) {
            PropertiesFiles.writePropertiesFile(propFile, newLines);
        }
    }

    private static List<String> addSchemeToCollectorAddressIfNeeded(List<String> lines) {
        ArrayList<String> newLines = Lists.newArrayList();
        for (String line : lines) {
            if (line.startsWith("collector.address=")) {
                String collectorAddress = line.substring("collector.address=".length());
                ArrayList<String> addrs = Lists.newArrayList();
                boolean modified = false;
                for (String addr : Splitter.on(',').trimResults().omitEmptyStrings().split(collectorAddress)) {
                    if (addr.startsWith("http://") || addr.startsWith("https://") || addr.startsWith("http\\://") || addr.startsWith("https\\://")) {
                        addrs.add(addr);
                        continue;
                    }
                    addrs.add("http://" + addr);
                    modified = true;
                }
                if (modified) {
                    newLines.add("collector.address=" + Joiner.on(',').join(addrs));
                    continue;
                }
                newLines.add(line);
                continue;
            }
            newLines.add(line);
        }
        return newLines;
    }

    private static void prependAgentRollupToAgentIdIfNeeded(File propFile) throws IOException {
        List<String> lines = PropertiesFiles.readPropertiesFile(propFile);
        List<String> newLines = PropertiesFiles.prependAgentRollupToAgentIdIfNeeded(lines);
        if (!newLines.equals(lines)) {
            PropertiesFiles.writePropertiesFile(propFile, newLines);
        }
    }

    private static List<String> prependAgentRollupToAgentIdIfNeeded(List<String> lines) {
        ArrayList<String> newLines = Lists.newArrayList();
        String agentId = null;
        String agentRollupId = null;
        int agentIdLineIndex = -1;
        for (String line : lines) {
            if (line.startsWith("agent.id=")) {
                agentId = line.substring("agent.id=".length());
                agentIdLineIndex = newLines.size();
                newLines.add(line);
                continue;
            }
            if (line.startsWith("agent.rollup.id=")) {
                agentRollupId = line.substring("agent.rollup.id=".length());
                continue;
            }
            newLines.add(line);
        }
        if (agentIdLineIndex != -1 && !Strings.isNullOrEmpty(agentRollupId)) {
            newLines.set(agentIdLineIndex, "agent.id=" + agentRollupId.replace("/", "::") + "::" + agentId);
        }
        return newLines;
    }

    private static List<String> readPropertiesFile(File propFile) throws IOException {
        return Files.readLines(propFile, Charsets.ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePropertiesFile(File propFile, List<String> newLines) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(Files.newWriter(propFile, Charsets.ISO_8859_1));
        try {
            for (String newLine : newLines) {
                out.println(newLine);
            }
        }
        finally {
            out.close();
        }
    }
}

