/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import org.glowroot.agent.DebuggingClassFileTransformer;
import org.glowroot.agent.Directories;
import org.glowroot.agent.IbmJ9Java6HackClassFileTransformer;
import org.glowroot.agent.IbmJ9Java6HackClassFileTransformer2;
import org.glowroot.agent.Java9HackClassFileTransformer;
import org.glowroot.agent.ManagementFactoryHackClassFileTransformer;
import org.glowroot.agent.PropertiesFiles;
import org.glowroot.agent.bytecode.api.BytecodeServiceHolder;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.init.AgentModule;
import org.glowroot.agent.init.GlowrootAgentInit;
import org.glowroot.agent.init.GlowrootAgentInitFactory;
import org.glowroot.agent.init.NonEmbeddedGlowrootAgentInit;
import org.glowroot.agent.init.PreCheckLoadedClasses;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Version;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;
import org.glowroot.agent.weaving.Java9;

public class MainEntryPoint {
    private static final boolean PRE_CHECK_LOADED_CLASSES = Boolean.getBoolean("glowroot.debug.preCheckLoadedClasses");
    public static final boolean PRINT_CLASS_LOADING = Boolean.getBoolean("glowroot.debug.printClassLoading");
    @MonotonicNonNull
    private static volatile Logger startupLogger;
    @OnlyUsedByTests
    @MonotonicNonNull
    private static GlowrootAgentInit glowrootAgentInit;

    private MainEntryPoint() {
    }

    public static void premain(Instrumentation instrumentation, Class<?>[] allPriorLoadedClasses, @Nullable File glowrootJarFile) {
        ImmutableMap<String, String> properties;
        Directories directories;
        if (startupLogger != null) {
            return;
        }
        PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer = null;
        try {
            if (PRE_CHECK_LOADED_CLASSES) {
                preCheckClassFileTransformer = new PreCheckLoadedClasses.PreCheckClassFileTransformer();
                instrumentation.addTransformer(preCheckClassFileTransformer);
            }
            if (PRINT_CLASS_LOADING) {
                DebuggingClassFileTransformer transformer = new DebuggingClassFileTransformer();
                instrumentation.addTransformer(transformer, true);
                instrumentation.retransformClasses(Class.forName("sun.misc.Launcher$AppClassLoader"));
                instrumentation.removeTransformer(transformer);
            }
            directories = new Directories(glowrootJarFile);
            MainEntryPoint.initLogging(directories.getConfDirs(), directories.getLogDir(), directories.getLoggingLogstashJarFile(), instrumentation);
            PreCheckLoadedClasses.PreCheckClassFileTransformer.initLogger();
            DebuggingClassFileTransformer.initLogger();
            if (directories.logStartupErrorMultiDirWithMissingAgentId()) {
                startupLogger.error("Glowroot failed to start: multi.dir is true, but missing agent.id");
                return;
            }
            if (directories.getAgentDirLockCloseable() == null) {
                properties = MainEntryPoint.getGlowrootProperties(directories.getConfDirs());
                MainEntryPoint.logAgentDirsLockedException(directories.getConfDir(), new File(directories.getTmpDir(), ".lock"), properties);
                return;
            }
        }
        catch (Throwable t) {
            System.err.println("Glowroot failed to start: " + t.getMessage());
            t.printStackTrace();
            return;
        }
        if (PRE_CHECK_LOADED_CLASSES) {
            if (AgentModule.logAnyImportantClassLoadedPriorToWeavingInit(allPriorLoadedClasses, glowrootJarFile, true)) {
                ArrayList<String> classNames = Lists.newArrayList();
                for (Class<?> clazz : allPriorLoadedClasses) {
                    String className = clazz.getName();
                    if (className.startsWith("[")) continue;
                    classNames.add(className);
                }
                Collections.sort(classNames);
                startupLogger.warn("PRE-CHECK: full list of classes already loaded: {}", (Object)Joiner.on(", ").join(classNames));
            } else {
                startupLogger.info("PRE-CHECK: successful");
            }
        }
        try {
            instrumentation.addTransformer(new ManagementFactoryHackClassFileTransformer());
            ManagementFactory.getThreadMXBean();
            if (JavaVersion.isGreaterThanOrEqualToJava9()) {
                Object baseModule = Java9.getModule(ClassLoader.class);
                Java9.grantAccessToGlowroot(instrumentation, baseModule);
                Java9.grantAccess(instrumentation, "org.glowroot.agent.weaving.ClassLoaders", "java.lang.ClassLoader", false);
                Java9.grantAccess(instrumentation, "org.glowroot.agent.shaded.io.netty.util.internal.ReflectionUtil", "java.nio.DirectByteBuffer", false);
                Java9.grantAccess(instrumentation, "org.glowroot.agent.shaded.io.netty.util.internal.ReflectionUtil", "sun.nio.ch.SelectorImpl", false);
                instrumentation.addTransformer(new Java9HackClassFileTransformer());
                Class.forName("org.glowroot.agent.weaving.WeavingClassFileTransformer");
            }
            if (JavaVersion.isJ9Jvm() && JavaVersion.isJava6()) {
                instrumentation.addTransformer(new IbmJ9Java6HackClassFileTransformer());
                Class.forName("org.glowroot.agent.shaded.com.google.protobuf.UnsafeUtil");
            }
            properties = MainEntryPoint.getGlowrootProperties(directories.getConfDirs());
            MainEntryPoint.start(directories, properties, instrumentation, preCheckClassFileTransformer);
        }
        catch (Throwable t) {
            startupLogger.error("Glowroot failed to start: {}", (Object)t.getMessage(), (Object)t);
            BytecodeServiceHolder.setGlowrootFailedToStart();
        }
    }

    public static void runOfflineViewer(Directories directories, GlowrootAgentInitFactory glowrootAgentInitFactory) {
        Preconditions.checkNotNull(startupLogger);
        try {
            String version = Version.getVersion(MainEntryPoint.class);
            startupLogger.info("Glowroot version: {}", (Object)version);
            startupLogger.info("Java version: {}", (Object)MainEntryPoint.getJavaVersion());
            ImmutableMap<String, String> properties = MainEntryPoint.getGlowrootProperties(directories.getConfDirs());
            glowrootAgentInitFactory.newGlowrootAgentInit(directories.getDataDir(), true, null).init(directories.getPluginsDir(), directories.getConfDirs(), directories.getLogDir(), directories.getTmpDir(), directories.getGlowrootJarFile(), properties, null, null, version, Preconditions.checkNotNull(directories.getAgentDirLockCloseable()));
        }
        catch (Throwable t) {
            startupLogger.error("Glowroot cannot start: {}", (Object)t.getMessage(), (Object)t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"startupLogger"})
    public static void initLogging(List<File> confDirs, File logDir, @Nullable File loggingLogstashJarFile, @Nullable Instrumentation instrumentation) throws IOException {
        if (loggingLogstashJarFile != null && instrumentation != null) {
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(loggingLogstashJarFile));
        }
        if (JavaVersion.isJava6() && "IBM J9 VM".equals(System.getProperty("java.vm.name")) && instrumentation != null) {
            instrumentation.addTransformer(new IbmJ9Java6HackClassFileTransformer2());
        }
        for (File confDir : confDirs) {
            File logbackXmlOverride = new File(confDir, "glowroot.logback.xml");
            if (!logbackXmlOverride.exists()) continue;
            System.setProperty("glowroot.logback.configurationFile", logbackXmlOverride.getAbsolutePath());
            break;
        }
        String priorProperty = System.getProperty("glowroot.log.dir");
        System.setProperty("glowroot.log.dir", logDir.getPath());
        ClassLoader priorLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ClassLoader(null){

            @Override
            @Nullable
            public InputStream getResourceAsStream(String name) {
                if (name.equals("META-INF/services/javax.xml.parsers.SAXParserFactory")) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return null;
            }
        });
        try {
            startupLogger = LoggerFactory.getLogger("org.glowroot");
        }
        finally {
            Thread.currentThread().setContextClassLoader(priorLoader);
            if (priorProperty == null) {
                System.clearProperty("glowroot.log.dir");
            } else {
                System.setProperty("glowroot.log.dir", priorProperty);
            }
            System.clearProperty("glowroot.logback.configurationFile");
        }
        Preconditions.checkNotNull(startupLogger);
    }

    @RequiresNonNull(value={"startupLogger"})
    private static void start(Directories directories, Map<String, String> properties, @Nullable Instrumentation instrumentation, @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer) throws Exception {
        String version = Version.getVersion(MainEntryPoint.class);
        startupLogger.info("Glowroot version: {}", (Object)version);
        startupLogger.info("Java version: {}", (Object)MainEntryPoint.getJavaVersion());
        startupLogger.info("Java args: {}", (Object)MainEntryPoint.getJvmArgs());
        glowrootAgentInit = MainEntryPoint.createGlowrootAgentInit(directories, properties, instrumentation);
        glowrootAgentInit.init(directories.getPluginsDir(), directories.getConfDirs(), directories.getLogDir(), directories.getTmpDir(), directories.getGlowrootJarFile(), properties, instrumentation, preCheckClassFileTransformer, version, Preconditions.checkNotNull(directories.getAgentDirLockCloseable()));
    }

    @RequiresNonNull(value={"startupLogger"})
    private static GlowrootAgentInit createGlowrootAgentInit(Directories directories, Map<String, String> properties, @Nullable Instrumentation instrumentation) throws Exception {
        String collectorAddress = properties.get("glowroot.collector.address");
        Class<? extends Collector> customCollectorClass = MainEntryPoint.loadCustomCollectorClass(directories.getGlowrootDir());
        Constructor<? extends Collector> collectorProxyConstructor = null;
        if (customCollectorClass != null) {
            try {
                collectorProxyConstructor = customCollectorClass.getConstructor(Collector.class);
            }
            catch (NoSuchMethodException e) {
                startupLogger.debug(e.getMessage(), e);
            }
        }
        if (customCollectorClass != null && collectorProxyConstructor == null) {
            startupLogger.info("using collector: {}", (Object)customCollectorClass.getName());
            return new NonEmbeddedGlowrootAgentInit(null, null, customCollectorClass);
        }
        if (collectorAddress == null) {
            Class<?> factoryClass;
            File embeddedCollectorJarFile = directories.getEmbeddedCollectorJarFile();
            ClassLoader embeddedLoader = embeddedCollectorJarFile == null ? ClassLoader.getSystemClassLoader() : new URLClassLoader(new URL[]{embeddedCollectorJarFile.toURI().toURL()}, ClassLoader.getSystemClassLoader());
            try {
                factoryClass = Class.forName("org.glowroot.agent.embedded.init.EmbeddedGlowrootAgentInitFactory", true, embeddedLoader);
            }
            catch (ClassNotFoundException e) {
                if (embeddedCollectorJarFile == null) {
                    startupLogger.error("missing lib/glowroot-embedded-collector.jar");
                }
                throw e;
            }
            GlowrootAgentInitFactory glowrootAgentInitFactory = (GlowrootAgentInitFactory)factoryClass.newInstance();
            return glowrootAgentInitFactory.newGlowrootAgentInit(directories.getDataDir(), false, customCollectorClass);
        }
        if (collectorAddress.startsWith("https://") && instrumentation != null) {
            String normalizedOsName = MainEntryPoint.getNormalizedOsName();
            if (normalizedOsName == null) {
                throw new IllegalStateException("HTTPS connection to central collector is only supported on linux, windows and osx, detected os.name: " + System.getProperty("os.name"));
            }
            File centralCollectorHttpsJarFile = directories.getCentralCollectorHttpsJarFile(normalizedOsName);
            if (centralCollectorHttpsJarFile == null) {
                throw new IllegalStateException("Missing lib/glowroot-central-collector-https-" + normalizedOsName + ".jar");
            }
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(centralCollectorHttpsJarFile));
            instrumentation.appendToSystemClassLoaderSearch(new JarFile(centralCollectorHttpsJarFile));
        }
        String collectorAuthority = properties.get("glowroot.collector.authority");
        return new NonEmbeddedGlowrootAgentInit(collectorAddress, collectorAuthority, customCollectorClass);
    }

    private static ImmutableMap<String, String> getGlowrootProperties(List<File> confDirs) throws IOException {
        HashMap<String, String> properties = Maps.newHashMap();
        ListIterator<File> i = confDirs.listIterator(confDirs.size());
        while (i.hasPrevious()) {
            PropertiesFiles.upgradeIfNeededAndLoadInto(i.previous(), properties);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getKey()).startsWith("glowroot.")) continue;
            String key = (String)entry.getKey();
            properties.put(key, (String)entry.getValue());
        }
        return ImmutableMap.copyOf(properties);
    }

    @RequiresNonNull(value={"startupLogger"})
    private static void logAgentDirsLockedException(File confDir, File lockFile, Map<String, String> properties) {
        if (!MainEntryPoint.isTomcatStop()) {
            String extraExplanation = "";
            extraExplanation = ".  If you are trying to monitor multiple JVM processes on one box from the same agent installation, please see instructions for how to do this on the wiki: ";
            extraExplanation = properties.containsKey("glowroot.collector.address") ? extraExplanation + "https://github.com/glowroot/glowroot/wiki/Agent-Installation-(for-Central-Collector)#monitoring-multiple-jvm-processes-on-one-box" : extraExplanation + "https://github.com/glowroot/glowroot/wiki/Agent-Installation-(with-Embedded-Collector)#monitoring-multiple-jvm-processes-on-one-box";
            startupLogger.error("Glowroot failed to start, directory in use by another jvm process: {} (unable to obtain lock on {}){}", confDir.getAbsolutePath(), lockFile.getAbsolutePath(), extraExplanation);
        }
    }

    private static boolean isTomcatStop() {
        return Objects.equal(System.getProperty("sun.java.command"), "org.apache.catalina.startup.Bootstrap stop");
    }

    @Nullable
    private static Class<? extends Collector> loadCustomCollectorClass(File glowrootDir) throws Exception {
        ClassLoader classLoader = MainEntryPoint.class.getClassLoader();
        Class<? extends Collector> collectorClass = MainEntryPoint.loadCollectorClass(classLoader);
        if (collectorClass != null) {
            return collectorClass;
        }
        File servicesDir = new File(glowrootDir, "services");
        if (!servicesDir.exists()) {
            return null;
        }
        if (!servicesDir.isDirectory()) {
            return null;
        }
        File[] files = servicesDir.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<URL> urls = Lists.newArrayList();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            urls.add(file.toURI().toURL());
        }
        if (urls.isEmpty()) {
            return null;
        }
        URLClassLoader servicesClassLoader = new URLClassLoader(urls.toArray(new URL[0]));
        return MainEntryPoint.loadCollectorClass(servicesClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Class<? extends Collector> loadCollectorClass(@Nullable ClassLoader classLoader) throws Exception {
        InputStream in = classLoader == null ? ClassLoader.getSystemResourceAsStream("META-INF/services/org.glowroot.agent.collector.Collector") : classLoader.getResourceAsStream("META-INF/services/org.glowroot.agent.collector.Collector");
        if (in == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
        try {
            String line = reader.readLine();
            while (line != null && ((line = line.trim()).isEmpty() || line.startsWith("#"))) {
                line = reader.readLine();
            }
            if (line == null) {
                Class<? extends Collector> clazz = null;
                return clazz;
            }
            Class<?> clazz = Class.forName(line, false, classLoader);
            Class<Collector> clazz2 = clazz.asSubclass(Collector.class);
            return clazz2;
        }
        finally {
            reader.close();
        }
    }

    @Nullable
    private static String getNormalizedOsName() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return null;
        }
        String lowerOsName = osName.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]+", "");
        if (lowerOsName.startsWith("linux")) {
            if (new File("/etc/alpine-release").exists()) {
                return "linux-alpine";
            }
            return "linux";
        }
        if (lowerOsName.startsWith("windows")) {
            return "windows";
        }
        if (lowerOsName.startsWith("macosx") || lowerOsName.startsWith("osx")) {
            return "linux";
        }
        return null;
    }

    private static StringBuilder getJavaVersion() {
        boolean appendOS;
        StringBuilder sb = new StringBuilder();
        sb.append(StandardSystemProperty.JAVA_VERSION.value());
        String vendor = System.getProperty("java.vm.vendor");
        String os = System.getProperty("os.name");
        boolean appendVendor = !Strings.isNullOrEmpty(vendor);
        boolean bl = appendOS = !Strings.isNullOrEmpty(os);
        if (appendVendor && appendOS) {
            sb.append(" (");
            if (appendVendor) {
                sb.append(vendor);
                if (appendOS) {
                    sb.append(" / ");
                }
            }
            if (appendOS) {
                sb.append(os);
            }
            sb.append(")");
        }
        return sb;
    }

    private static StringBuilder getJvmArgs() {
        StringBuilder sb = new StringBuilder();
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (jvmArg.startsWith("-D")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(jvmArg);
        }
        return sb;
    }

    @OnlyUsedByTests
    public static void start(Map<String, String> properties) throws Exception {
        String testDirPath = Preconditions.checkNotNull(properties.get("glowroot.test.dir"));
        File testDir = new File(testDirPath);
        MainEntryPoint.initLogging(Arrays.asList(testDir), testDir, null, null);
        Directories directories = new Directories(testDir, false);
        MainEntryPoint.start(directories, properties, null, null);
    }

    @OnlyUsedByTests
    @Nullable
    public static GlowrootAgentInit getGlowrootAgentInit() {
        return glowrootAgentInit;
    }
}

