package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;

/**
 * Immutable implementation of {@link PluginDetail.ShimClass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableShimClass.builder()}.
 */
@Generated(from = "PluginDetail.ShimClass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableShimClass extends PluginDetail.ShimClass {
  private final Type type;

  private ImmutableShimClass(Type type) {
    this.type = type;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  Type type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.ShimClass#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableShimClass withType(Type value) {
    if (this.type == value) return this;
    Type newValue = Preconditions.checkNotNull(value, "type");
    return new ImmutableShimClass(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableShimClass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableShimClass
        && equalTo((ImmutableShimClass) another);
  }

  private boolean equalTo(ImmutableShimClass another) {
    return type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ShimClass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ShimClass")
        .omitNullValues()
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDetail.ShimClass", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PluginDetail.ShimClass {
    @Nullable Type type;
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @Override
    Type type() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableShimClass fromJson(Json json) {
    ImmutableShimClass.Builder builder = ImmutableShimClass.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDetail.ShimClass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ShimClass instance
   */
  public static ImmutableShimClass copyOf(PluginDetail.ShimClass instance) {
    if (instance instanceof ImmutableShimClass) {
      return (ImmutableShimClass) instance;
    }
    return ImmutableShimClass.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableShimClass ImmutableShimClass}.
   * <pre>
   * ImmutableShimClass.builder()
   *    .type(org.glowroot.agent.shaded.org.objectweb.asm.Type) // required {@link PluginDetail.ShimClass#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableShimClass builder
   */
  public static ImmutableShimClass.Builder builder() {
    return new ImmutableShimClass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableShimClass ImmutableShimClass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDetail.ShimClass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShimClass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDetail.ShimClass instance) {
      Preconditions.checkNotNull(instance, "instance");
      type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.ShimClass#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Type type) {
      this.type = Preconditions.checkNotNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableShimClass ImmutableShimClass}.
     * @return An immutable instance of ShimClass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableShimClass build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableShimClass(type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ShimClass, some of required attributes are not set " + attributes;
    }
  }
}
