package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PluginDetail}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePluginDetail.builder()}.
 */
@Generated(from = "PluginDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutablePluginDetail implements PluginDetail {
  private final ImmutableList<PluginDetail.PointcutClass> pointcutClasses;
  private final ImmutableList<PluginDetail.MixinClass> mixinClasses;
  private final ImmutableList<PluginDetail.ShimClass> shimClasses;

  private ImmutablePluginDetail(
      ImmutableList<PluginDetail.PointcutClass> pointcutClasses,
      ImmutableList<PluginDetail.MixinClass> mixinClasses,
      ImmutableList<PluginDetail.ShimClass> shimClasses) {
    this.pointcutClasses = pointcutClasses;
    this.mixinClasses = mixinClasses;
    this.shimClasses = shimClasses;
  }

  /**
   * @return The value of the {@code pointcutClasses} attribute
   */
  @JsonProperty("pointcutClasses")
  @Override
  public ImmutableList<PluginDetail.PointcutClass> pointcutClasses() {
    return pointcutClasses;
  }

  /**
   * @return The value of the {@code mixinClasses} attribute
   */
  @JsonProperty("mixinClasses")
  @Override
  public ImmutableList<PluginDetail.MixinClass> mixinClasses() {
    return mixinClasses;
  }

  /**
   * @return The value of the {@code shimClasses} attribute
   */
  @JsonProperty("shimClasses")
  @Override
  public ImmutableList<PluginDetail.ShimClass> shimClasses() {
    return shimClasses;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#pointcutClasses() pointcutClasses}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withPointcutClasses(PluginDetail.PointcutClass... elements) {
    ImmutableList<PluginDetail.PointcutClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(newValue, this.mixinClasses, this.shimClasses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#pointcutClasses() pointcutClasses}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pointcutClasses elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withPointcutClasses(Iterable<? extends PluginDetail.PointcutClass> elements) {
    if (this.pointcutClasses == elements) return this;
    ImmutableList<PluginDetail.PointcutClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(newValue, this.mixinClasses, this.shimClasses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#mixinClasses() mixinClasses}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withMixinClasses(PluginDetail.MixinClass... elements) {
    ImmutableList<PluginDetail.MixinClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(this.pointcutClasses, newValue, this.shimClasses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#mixinClasses() mixinClasses}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mixinClasses elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withMixinClasses(Iterable<? extends PluginDetail.MixinClass> elements) {
    if (this.mixinClasses == elements) return this;
    ImmutableList<PluginDetail.MixinClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(this.pointcutClasses, newValue, this.shimClasses);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#shimClasses() shimClasses}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withShimClasses(PluginDetail.ShimClass... elements) {
    ImmutableList<PluginDetail.ShimClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(this.pointcutClasses, this.mixinClasses, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail#shimClasses() shimClasses}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of shimClasses elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDetail withShimClasses(Iterable<? extends PluginDetail.ShimClass> elements) {
    if (this.shimClasses == elements) return this;
    ImmutableList<PluginDetail.ShimClass> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDetail(this.pointcutClasses, this.mixinClasses, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePluginDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePluginDetail
        && equalTo((ImmutablePluginDetail) another);
  }

  private boolean equalTo(ImmutablePluginDetail another) {
    return pointcutClasses.equals(another.pointcutClasses)
        && mixinClasses.equals(another.mixinClasses)
        && shimClasses.equals(another.shimClasses);
  }

  /**
   * Computes a hash code from attributes: {@code pointcutClasses}, {@code mixinClasses}, {@code shimClasses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pointcutClasses.hashCode();
    h += (h << 5) + mixinClasses.hashCode();
    h += (h << 5) + shimClasses.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PluginDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginDetail")
        .omitNullValues()
        .add("pointcutClasses", pointcutClasses)
        .add("mixinClasses", mixinClasses)
        .add("shimClasses", shimClasses)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDetail", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PluginDetail {
    @Nullable List<PluginDetail.PointcutClass> pointcutClasses = ImmutableList.of();
    @Nullable List<PluginDetail.MixinClass> mixinClasses = ImmutableList.of();
    @Nullable List<PluginDetail.ShimClass> shimClasses = ImmutableList.of();
    @JsonProperty("pointcutClasses")
    public void setPointcutClasses(List<PluginDetail.PointcutClass> pointcutClasses) {
      this.pointcutClasses = pointcutClasses;
    }
    @JsonProperty("mixinClasses")
    public void setMixinClasses(List<PluginDetail.MixinClass> mixinClasses) {
      this.mixinClasses = mixinClasses;
    }
    @JsonProperty("shimClasses")
    public void setShimClasses(List<PluginDetail.ShimClass> shimClasses) {
      this.shimClasses = shimClasses;
    }
    @Override
    public List<PluginDetail.PointcutClass> pointcutClasses() { throw new UnsupportedOperationException(); }
    @Override
    public List<PluginDetail.MixinClass> mixinClasses() { throw new UnsupportedOperationException(); }
    @Override
    public List<PluginDetail.ShimClass> shimClasses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePluginDetail fromJson(Json json) {
    ImmutablePluginDetail.Builder builder = ImmutablePluginDetail.builder();
    if (json.pointcutClasses != null) {
      builder.addAllPointcutClasses(json.pointcutClasses);
    }
    if (json.mixinClasses != null) {
      builder.addAllMixinClasses(json.mixinClasses);
    }
    if (json.shimClasses != null) {
      builder.addAllShimClasses(json.shimClasses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDetail} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PluginDetail instance
   */
  public static ImmutablePluginDetail copyOf(PluginDetail instance) {
    if (instance instanceof ImmutablePluginDetail) {
      return (ImmutablePluginDetail) instance;
    }
    return ImmutablePluginDetail.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePluginDetail ImmutablePluginDetail}.
   * <pre>
   * ImmutablePluginDetail.builder()
   *    .addPointcutClasses|addAllPointcutClasses(org.glowroot.agent.weaving.PluginDetail.PointcutClass) // {@link PluginDetail#pointcutClasses() pointcutClasses} elements
   *    .addMixinClasses|addAllMixinClasses(org.glowroot.agent.weaving.PluginDetail.MixinClass) // {@link PluginDetail#mixinClasses() mixinClasses} elements
   *    .addShimClasses|addAllShimClasses(org.glowroot.agent.weaving.PluginDetail.ShimClass) // {@link PluginDetail#shimClasses() shimClasses} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePluginDetail builder
   */
  public static ImmutablePluginDetail.Builder builder() {
    return new ImmutablePluginDetail.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePluginDetail ImmutablePluginDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDetail", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<PluginDetail.PointcutClass> pointcutClasses = ImmutableList.builder();
    private ImmutableList.Builder<PluginDetail.MixinClass> mixinClasses = ImmutableList.builder();
    private ImmutableList.Builder<PluginDetail.ShimClass> shimClasses = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PluginDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDetail instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllPointcutClasses(instance.pointcutClasses());
      addAllMixinClasses(instance.mixinClasses());
      addAllShimClasses(instance.shimClasses());
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail#pointcutClasses() pointcutClasses} list.
     * @param element A pointcutClasses element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPointcutClasses(PluginDetail.PointcutClass element) {
      this.pointcutClasses.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail#pointcutClasses() pointcutClasses} list.
     * @param elements An array of pointcutClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPointcutClasses(PluginDetail.PointcutClass... elements) {
      this.pointcutClasses.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail#pointcutClasses() pointcutClasses} list.
     * @param elements An iterable of pointcutClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutClasses(Iterable<? extends PluginDetail.PointcutClass> elements) {
      this.pointcutClasses = ImmutableList.builder();
      return addAllPointcutClasses(elements);
    }

    /**
     * Adds elements to {@link PluginDetail#pointcutClasses() pointcutClasses} list.
     * @param elements An iterable of pointcutClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPointcutClasses(Iterable<? extends PluginDetail.PointcutClass> elements) {
      this.pointcutClasses.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail#mixinClasses() mixinClasses} list.
     * @param element A mixinClasses element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMixinClasses(PluginDetail.MixinClass element) {
      this.mixinClasses.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail#mixinClasses() mixinClasses} list.
     * @param elements An array of mixinClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMixinClasses(PluginDetail.MixinClass... elements) {
      this.mixinClasses.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail#mixinClasses() mixinClasses} list.
     * @param elements An iterable of mixinClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mixinClasses(Iterable<? extends PluginDetail.MixinClass> elements) {
      this.mixinClasses = ImmutableList.builder();
      return addAllMixinClasses(elements);
    }

    /**
     * Adds elements to {@link PluginDetail#mixinClasses() mixinClasses} list.
     * @param elements An iterable of mixinClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMixinClasses(Iterable<? extends PluginDetail.MixinClass> elements) {
      this.mixinClasses.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail#shimClasses() shimClasses} list.
     * @param element A shimClasses element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addShimClasses(PluginDetail.ShimClass element) {
      this.shimClasses.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail#shimClasses() shimClasses} list.
     * @param elements An array of shimClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addShimClasses(PluginDetail.ShimClass... elements) {
      this.shimClasses.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail#shimClasses() shimClasses} list.
     * @param elements An iterable of shimClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shimClasses(Iterable<? extends PluginDetail.ShimClass> elements) {
      this.shimClasses = ImmutableList.builder();
      return addAllShimClasses(elements);
    }

    /**
     * Adds elements to {@link PluginDetail#shimClasses() shimClasses} list.
     * @param elements An iterable of shimClasses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllShimClasses(Iterable<? extends PluginDetail.ShimClass> elements) {
      this.shimClasses.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePluginDetail ImmutablePluginDetail}.
     * @return An immutable instance of PluginDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePluginDetail build() {
      return new ImmutablePluginDetail(pointcutClasses.build(), mixinClasses.build(), shimClasses.build());
    }
  }
}
