package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AnalyzedWorld.AnalyzedClassAndLoader}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnalyzedClassAndLoader.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAnalyzedClassAndLoader.of()}.
 */
@Generated(from = "AnalyzedWorld.AnalyzedClassAndLoader", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAnalyzedClassAndLoader
    implements AnalyzedWorld.AnalyzedClassAndLoader {
  private final AnalyzedClass analyzedClass;
  private final @Nullable ClassLoader analyzedClassLoader;

  private ImmutableAnalyzedClassAndLoader(
      AnalyzedClass analyzedClass,
      @Nullable ClassLoader analyzedClassLoader) {
    this.analyzedClass = Preconditions.checkNotNull(analyzedClass, "analyzedClass");
    this.analyzedClassLoader = analyzedClassLoader;
  }

  private ImmutableAnalyzedClassAndLoader(
      ImmutableAnalyzedClassAndLoader original,
      AnalyzedClass analyzedClass,
      @Nullable ClassLoader analyzedClassLoader) {
    this.analyzedClass = analyzedClass;
    this.analyzedClassLoader = analyzedClassLoader;
  }

  /**
   * @return The value of the {@code analyzedClass} attribute
   */
  @JsonProperty("analyzedClass")
  @Override
  public AnalyzedClass analyzedClass() {
    return analyzedClass;
  }

  /**
   * @return The value of the {@code analyzedClassLoader} attribute
   */
  @JsonProperty("analyzedClassLoader")
  @Override
  public @Nullable ClassLoader analyzedClassLoader() {
    return analyzedClassLoader;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClass() analyzedClass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for analyzedClass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClassAndLoader withAnalyzedClass(AnalyzedClass value) {
    if (this.analyzedClass == value) return this;
    AnalyzedClass newValue = Preconditions.checkNotNull(value, "analyzedClass");
    return new ImmutableAnalyzedClassAndLoader(this, newValue, this.analyzedClassLoader);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClassLoader() analyzedClassLoader} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for analyzedClassLoader (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClassAndLoader withAnalyzedClassLoader(@Nullable ClassLoader value) {
    if (this.analyzedClassLoader == value) return this;
    return new ImmutableAnalyzedClassAndLoader(this, this.analyzedClass, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnalyzedClassAndLoader} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnalyzedClassAndLoader
        && equalTo((ImmutableAnalyzedClassAndLoader) another);
  }

  private boolean equalTo(ImmutableAnalyzedClassAndLoader another) {
    return analyzedClass.equals(another.analyzedClass)
        && Objects.equal(analyzedClassLoader, another.analyzedClassLoader);
  }

  /**
   * Computes a hash code from attributes: {@code analyzedClass}, {@code analyzedClassLoader}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + analyzedClass.hashCode();
    h += (h << 5) + Objects.hashCode(analyzedClassLoader);
    return h;
  }

  /**
   * Prints the immutable value {@code AnalyzedClassAndLoader} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedClassAndLoader")
        .omitNullValues()
        .add("analyzedClass", analyzedClass)
        .add("analyzedClassLoader", analyzedClassLoader)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AnalyzedWorld.AnalyzedClassAndLoader", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AnalyzedWorld.AnalyzedClassAndLoader {
    @org.glowroot.agent.shaded.javax.annotation.Nullable AnalyzedClass analyzedClass;
    @org.glowroot.agent.shaded.javax.annotation.Nullable ClassLoader analyzedClassLoader;
    @JsonProperty("analyzedClass")
    public void setAnalyzedClass(AnalyzedClass analyzedClass) {
      this.analyzedClass = analyzedClass;
    }
    @JsonProperty("analyzedClassLoader")
    public void setAnalyzedClassLoader(@Nullable ClassLoader analyzedClassLoader) {
      this.analyzedClassLoader = analyzedClassLoader;
    }
    @Override
    public AnalyzedClass analyzedClass() { throw new UnsupportedOperationException(); }
    @Override
    public ClassLoader analyzedClassLoader() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnalyzedClassAndLoader fromJson(Json json) {
    ImmutableAnalyzedClassAndLoader.Builder builder = ImmutableAnalyzedClassAndLoader.builder();
    if (json.analyzedClass != null) {
      builder.analyzedClass(json.analyzedClass);
    }
    if (json.analyzedClassLoader != null) {
      builder.analyzedClassLoader(json.analyzedClassLoader);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code AnalyzedClassAndLoader} instance.
   * @param analyzedClass The value for the {@code analyzedClass} attribute
   * @param analyzedClassLoader The value for the {@code analyzedClassLoader} attribute
   * @return An immutable AnalyzedClassAndLoader instance
   */
  public static ImmutableAnalyzedClassAndLoader of(AnalyzedClass analyzedClass, @Nullable ClassLoader analyzedClassLoader) {
    return new ImmutableAnalyzedClassAndLoader(analyzedClass, analyzedClassLoader);
  }

  /**
   * Creates an immutable copy of a {@link AnalyzedWorld.AnalyzedClassAndLoader} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnalyzedClassAndLoader instance
   */
  public static ImmutableAnalyzedClassAndLoader copyOf(AnalyzedWorld.AnalyzedClassAndLoader instance) {
    if (instance instanceof ImmutableAnalyzedClassAndLoader) {
      return (ImmutableAnalyzedClassAndLoader) instance;
    }
    return ImmutableAnalyzedClassAndLoader.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnalyzedClassAndLoader ImmutableAnalyzedClassAndLoader}.
   * <pre>
   * ImmutableAnalyzedClassAndLoader.builder()
   *    .analyzedClass(org.glowroot.agent.weaving.AnalyzedClass) // required {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClass() analyzedClass}
   *    .analyzedClassLoader(ClassLoader | null) // nullable {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClassLoader() analyzedClassLoader}
   *    .build();
   * </pre>
   * @return A new ImmutableAnalyzedClassAndLoader builder
   */
  public static ImmutableAnalyzedClassAndLoader.Builder builder() {
    return new ImmutableAnalyzedClassAndLoader.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnalyzedClassAndLoader ImmutableAnalyzedClassAndLoader}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnalyzedWorld.AnalyzedClassAndLoader", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ANALYZED_CLASS = 0x1L;
    private long initBits = 0x1L;

    private @org.glowroot.agent.shaded.javax.annotation.Nullable AnalyzedClass analyzedClass;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable ClassLoader analyzedClassLoader;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnalyzedClassAndLoader} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AnalyzedWorld.AnalyzedClassAndLoader instance) {
      Preconditions.checkNotNull(instance, "instance");
      analyzedClass(instance.analyzedClass());
      @Nullable ClassLoader analyzedClassLoaderValue = instance.analyzedClassLoader();
      if (analyzedClassLoaderValue != null) {
        analyzedClassLoader(analyzedClassLoaderValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClass() analyzedClass} attribute.
     * @param analyzedClass The value for analyzedClass 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analyzedClass(AnalyzedClass analyzedClass) {
      this.analyzedClass = Preconditions.checkNotNull(analyzedClass, "analyzedClass");
      initBits &= ~INIT_BIT_ANALYZED_CLASS;
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedWorld.AnalyzedClassAndLoader#analyzedClassLoader() analyzedClassLoader} attribute.
     * @param analyzedClassLoader The value for analyzedClassLoader (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analyzedClassLoader(@Nullable ClassLoader analyzedClassLoader) {
      this.analyzedClassLoader = analyzedClassLoader;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnalyzedClassAndLoader ImmutableAnalyzedClassAndLoader}.
     * @return An immutable instance of AnalyzedClassAndLoader
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnalyzedClassAndLoader build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAnalyzedClassAndLoader(null, analyzedClass, analyzedClassLoader);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ANALYZED_CLASS) != 0) attributes.add("analyzedClass");
      return "Cannot build AnalyzedClassAndLoader, some of required attributes are not set " + attributes;
    }
  }
}
