package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AnalyzedClass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnalyzedClass.builder()}.
 */
@Generated(from = "AnalyzedClass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAnalyzedClass extends AnalyzedClass {
  private final int modifiers;
  private final String name;
  private final @Nullable String superName;
  private final ImmutableList<String> interfaceNames;
  private final ImmutableList<AnalyzedMethod> analyzedMethods;
  private final ImmutableList<PublicFinalMethod> publicFinalMethods;
  private final ImmutableList<ShimType> shimTypes;
  private final ImmutableList<MixinType> mixinTypes;
  private final ImmutableList<MixinType> nonReweavableMixinTypes;
  private final boolean ejbRemote;

  private ImmutableAnalyzedClass(
      int modifiers,
      String name,
      @Nullable String superName,
      ImmutableList<String> interfaceNames,
      ImmutableList<AnalyzedMethod> analyzedMethods,
      ImmutableList<PublicFinalMethod> publicFinalMethods,
      ImmutableList<ShimType> shimTypes,
      ImmutableList<MixinType> mixinTypes,
      ImmutableList<MixinType> nonReweavableMixinTypes,
      boolean ejbRemote) {
    this.modifiers = modifiers;
    this.name = name;
    this.superName = superName;
    this.interfaceNames = interfaceNames;
    this.analyzedMethods = analyzedMethods;
    this.publicFinalMethods = publicFinalMethods;
    this.shimTypes = shimTypes;
    this.mixinTypes = mixinTypes;
    this.nonReweavableMixinTypes = nonReweavableMixinTypes;
    this.ejbRemote = ejbRemote;
  }

  /**
   * @return The value of the {@code modifiers} attribute
   */
  @JsonProperty("modifiers")
  @Override
  int modifiers() {
    return modifiers;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  String name() {
    return name;
  }

  /**
   * @return The value of the {@code superName} attribute
   */
  @JsonProperty("superName")
  @Override
  @Nullable String superName() {
    return superName;
  }

  /**
   * @return The value of the {@code interfaceNames} attribute
   */
  @JsonProperty("interfaceNames")
  @Override
  ImmutableList<String> interfaceNames() {
    return interfaceNames;
  }

  /**
   * @return The value of the {@code analyzedMethods} attribute
   */
  @JsonProperty("analyzedMethods")
  @Override
  ImmutableList<AnalyzedMethod> analyzedMethods() {
    return analyzedMethods;
  }

  /**
   * @return The value of the {@code publicFinalMethods} attribute
   */
  @JsonProperty("publicFinalMethods")
  @Override
  ImmutableList<PublicFinalMethod> publicFinalMethods() {
    return publicFinalMethods;
  }

  /**
   * @return The value of the {@code shimTypes} attribute
   */
  @JsonProperty("shimTypes")
  @Override
  ImmutableList<ShimType> shimTypes() {
    return shimTypes;
  }

  /**
   * @return The value of the {@code mixinTypes} attribute
   */
  @JsonProperty("mixinTypes")
  @Override
  ImmutableList<MixinType> mixinTypes() {
    return mixinTypes;
  }

  /**
   * @return The value of the {@code nonReweavableMixinTypes} attribute
   */
  @JsonProperty("nonReweavableMixinTypes")
  @Override
  ImmutableList<MixinType> nonReweavableMixinTypes() {
    return nonReweavableMixinTypes;
  }

  /**
   * @return The value of the {@code ejbRemote} attribute
   */
  @JsonProperty("ejbRemote")
  @Override
  boolean ejbRemote() {
    return ejbRemote;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedClass#modifiers() modifiers} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifiers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClass withModifiers(int value) {
    if (this.modifiers == value) return this;
    return new ImmutableAnalyzedClass(
        value,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedClass#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClass withName(String value) {
    String newValue = Preconditions.checkNotNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableAnalyzedClass(
        this.modifiers,
        newValue,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedClass#superName() superName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for superName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClass withSuperName(@Nullable String value) {
    if (Objects.equal(this.superName, value)) return this;
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        value,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#interfaceNames() interfaceNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withInterfaceNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        newValue,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#interfaceNames() interfaceNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of interfaceNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withInterfaceNames(Iterable<String> elements) {
    if (this.interfaceNames == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        newValue,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#analyzedMethods() analyzedMethods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withAnalyzedMethods(AnalyzedMethod... elements) {
    ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        newValue,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#analyzedMethods() analyzedMethods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of analyzedMethods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
    if (this.analyzedMethods == elements) return this;
    ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        newValue,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#publicFinalMethods() publicFinalMethods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withPublicFinalMethods(PublicFinalMethod... elements) {
    ImmutableList<PublicFinalMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        newValue,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#publicFinalMethods() publicFinalMethods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of publicFinalMethods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withPublicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
    if (this.publicFinalMethods == elements) return this;
    ImmutableList<PublicFinalMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        newValue,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#shimTypes() shimTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withShimTypes(ShimType... elements) {
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        newValue,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#shimTypes() shimTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of shimTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withShimTypes(Iterable<? extends ShimType> elements) {
    if (this.shimTypes == elements) return this;
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        newValue,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#mixinTypes() mixinTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withMixinTypes(MixinType... elements) {
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        newValue,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#mixinTypes() mixinTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mixinTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withMixinTypes(Iterable<? extends MixinType> elements) {
    if (this.mixinTypes == elements) return this;
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        newValue,
        this.nonReweavableMixinTypes,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withNonReweavableMixinTypes(MixinType... elements) {
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        newValue,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nonReweavableMixinTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedClass withNonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
    if (this.nonReweavableMixinTypes == elements) return this;
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        newValue,
        this.ejbRemote);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AnalyzedClass#ejbRemote() ejbRemote} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ejbRemote
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedClass withEjbRemote(boolean value) {
    if (this.ejbRemote == value) return this;
    return new ImmutableAnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.publicFinalMethods,
        this.shimTypes,
        this.mixinTypes,
        this.nonReweavableMixinTypes,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnalyzedClass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnalyzedClass
        && equalTo((ImmutableAnalyzedClass) another);
  }

  private boolean equalTo(ImmutableAnalyzedClass another) {
    return modifiers == another.modifiers
        && name.equals(another.name)
        && Objects.equal(superName, another.superName)
        && interfaceNames.equals(another.interfaceNames)
        && analyzedMethods.equals(another.analyzedMethods)
        && publicFinalMethods.equals(another.publicFinalMethods)
        && shimTypes.equals(another.shimTypes)
        && mixinTypes.equals(another.mixinTypes)
        && nonReweavableMixinTypes.equals(another.nonReweavableMixinTypes)
        && ejbRemote == another.ejbRemote;
  }

  /**
   * Computes a hash code from attributes: {@code modifiers}, {@code name}, {@code superName}, {@code interfaceNames}, {@code analyzedMethods}, {@code publicFinalMethods}, {@code shimTypes}, {@code mixinTypes}, {@code nonReweavableMixinTypes}, {@code ejbRemote}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + modifiers;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(superName);
    h += (h << 5) + interfaceNames.hashCode();
    h += (h << 5) + analyzedMethods.hashCode();
    h += (h << 5) + publicFinalMethods.hashCode();
    h += (h << 5) + shimTypes.hashCode();
    h += (h << 5) + mixinTypes.hashCode();
    h += (h << 5) + nonReweavableMixinTypes.hashCode();
    h += (h << 5) + Booleans.hashCode(ejbRemote);
    return h;
  }

  /**
   * Prints the immutable value {@code AnalyzedClass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedClass")
        .omitNullValues()
        .add("modifiers", modifiers)
        .add("name", name)
        .add("superName", superName)
        .add("interfaceNames", interfaceNames)
        .add("analyzedMethods", analyzedMethods)
        .add("publicFinalMethods", publicFinalMethods)
        .add("shimTypes", shimTypes)
        .add("mixinTypes", mixinTypes)
        .add("nonReweavableMixinTypes", nonReweavableMixinTypes)
        .add("ejbRemote", ejbRemote)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AnalyzedClass", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AnalyzedClass {
    int modifiers;
    boolean modifiersIsSet;
    @org.glowroot.agent.shaded.javax.annotation.Nullable String name;
    @org.glowroot.agent.shaded.javax.annotation.Nullable String superName;
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<String> interfaceNames = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<AnalyzedMethod> analyzedMethods = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<PublicFinalMethod> publicFinalMethods = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<ShimType> shimTypes = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<MixinType> mixinTypes = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable ImmutableList<MixinType> nonReweavableMixinTypes = ImmutableList.of();
    boolean ejbRemote;
    boolean ejbRemoteIsSet;
    @JsonProperty("modifiers")
    public void setModifiers(int modifiers) {
      this.modifiers = modifiers;
      this.modifiersIsSet = true;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("superName")
    public void setSuperName(@Nullable String superName) {
      this.superName = superName;
    }
    @JsonProperty("interfaceNames")
    public void setInterfaceNames(ImmutableList<String> interfaceNames) {
      this.interfaceNames = interfaceNames;
    }
    @JsonProperty("analyzedMethods")
    public void setAnalyzedMethods(ImmutableList<AnalyzedMethod> analyzedMethods) {
      this.analyzedMethods = analyzedMethods;
    }
    @JsonProperty("publicFinalMethods")
    public void setPublicFinalMethods(ImmutableList<PublicFinalMethod> publicFinalMethods) {
      this.publicFinalMethods = publicFinalMethods;
    }
    @JsonProperty("shimTypes")
    public void setShimTypes(ImmutableList<ShimType> shimTypes) {
      this.shimTypes = shimTypes;
    }
    @JsonProperty("mixinTypes")
    public void setMixinTypes(ImmutableList<MixinType> mixinTypes) {
      this.mixinTypes = mixinTypes;
    }
    @JsonProperty("nonReweavableMixinTypes")
    public void setNonReweavableMixinTypes(ImmutableList<MixinType> nonReweavableMixinTypes) {
      this.nonReweavableMixinTypes = nonReweavableMixinTypes;
    }
    @JsonProperty("ejbRemote")
    public void setEjbRemote(boolean ejbRemote) {
      this.ejbRemote = ejbRemote;
      this.ejbRemoteIsSet = true;
    }
    @Override
    int modifiers() { throw new UnsupportedOperationException(); }
    @Override
    String name() { throw new UnsupportedOperationException(); }
    @Override
    String superName() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<String> interfaceNames() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<AnalyzedMethod> analyzedMethods() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<PublicFinalMethod> publicFinalMethods() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<ShimType> shimTypes() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<MixinType> mixinTypes() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<MixinType> nonReweavableMixinTypes() { throw new UnsupportedOperationException(); }
    @Override
    boolean ejbRemote() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnalyzedClass fromJson(Json json) {
    ImmutableAnalyzedClass.Builder builder = ImmutableAnalyzedClass.builder();
    if (json.modifiersIsSet) {
      builder.modifiers(json.modifiers);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.superName != null) {
      builder.superName(json.superName);
    }
    if (json.interfaceNames != null) {
      builder.addAllInterfaceNames(json.interfaceNames);
    }
    if (json.analyzedMethods != null) {
      builder.addAllAnalyzedMethods(json.analyzedMethods);
    }
    if (json.publicFinalMethods != null) {
      builder.addAllPublicFinalMethods(json.publicFinalMethods);
    }
    if (json.shimTypes != null) {
      builder.addAllShimTypes(json.shimTypes);
    }
    if (json.mixinTypes != null) {
      builder.addAllMixinTypes(json.mixinTypes);
    }
    if (json.nonReweavableMixinTypes != null) {
      builder.addAllNonReweavableMixinTypes(json.nonReweavableMixinTypes);
    }
    if (json.ejbRemoteIsSet) {
      builder.ejbRemote(json.ejbRemote);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AnalyzedClass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnalyzedClass instance
   */
  public static ImmutableAnalyzedClass copyOf(AnalyzedClass instance) {
    if (instance instanceof ImmutableAnalyzedClass) {
      return (ImmutableAnalyzedClass) instance;
    }
    return ImmutableAnalyzedClass.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnalyzedClass ImmutableAnalyzedClass}.
   * <pre>
   * ImmutableAnalyzedClass.builder()
   *    .modifiers(int) // required {@link AnalyzedClass#modifiers() modifiers}
   *    .name(String) // required {@link AnalyzedClass#name() name}
   *    .superName(String | null) // nullable {@link AnalyzedClass#superName() superName}
   *    .addInterfaceNames|addAllInterfaceNames(String) // {@link AnalyzedClass#interfaceNames() interfaceNames} elements
   *    .addAnalyzedMethods|addAllAnalyzedMethods(org.glowroot.agent.weaving.AnalyzedMethod) // {@link AnalyzedClass#analyzedMethods() analyzedMethods} elements
   *    .addPublicFinalMethods|addAllPublicFinalMethods(org.glowroot.agent.weaving.PublicFinalMethod) // {@link AnalyzedClass#publicFinalMethods() publicFinalMethods} elements
   *    .addShimTypes|addAllShimTypes(org.glowroot.agent.weaving.ShimType) // {@link AnalyzedClass#shimTypes() shimTypes} elements
   *    .addMixinTypes|addAllMixinTypes(org.glowroot.agent.weaving.MixinType) // {@link AnalyzedClass#mixinTypes() mixinTypes} elements
   *    .addNonReweavableMixinTypes|addAllNonReweavableMixinTypes(org.glowroot.agent.weaving.MixinType) // {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes} elements
   *    .ejbRemote(boolean) // required {@link AnalyzedClass#ejbRemote() ejbRemote}
   *    .build();
   * </pre>
   * @return A new ImmutableAnalyzedClass builder
   */
  public static ImmutableAnalyzedClass.Builder builder() {
    return new ImmutableAnalyzedClass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnalyzedClass ImmutableAnalyzedClass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AnalyzedClass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MODIFIERS = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_EJB_REMOTE = 0x4L;
    private long initBits = 0x7L;

    private int modifiers;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable String name;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable String superName;
    private ImmutableList.Builder<String> interfaceNames = ImmutableList.builder();
    private ImmutableList.Builder<AnalyzedMethod> analyzedMethods = ImmutableList.builder();
    private ImmutableList.Builder<PublicFinalMethod> publicFinalMethods = ImmutableList.builder();
    private ImmutableList.Builder<ShimType> shimTypes = ImmutableList.builder();
    private ImmutableList.Builder<MixinType> mixinTypes = ImmutableList.builder();
    private ImmutableList.Builder<MixinType> nonReweavableMixinTypes = ImmutableList.builder();
    private boolean ejbRemote;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnalyzedClass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AnalyzedClass instance) {
      Preconditions.checkNotNull(instance, "instance");
      modifiers(instance.modifiers());
      name(instance.name());
      @Nullable String superNameValue = instance.superName();
      if (superNameValue != null) {
        superName(superNameValue);
      }
      addAllInterfaceNames(instance.interfaceNames());
      addAllAnalyzedMethods(instance.analyzedMethods());
      addAllPublicFinalMethods(instance.publicFinalMethods());
      addAllShimTypes(instance.shimTypes());
      addAllMixinTypes(instance.mixinTypes());
      addAllNonReweavableMixinTypes(instance.nonReweavableMixinTypes());
      ejbRemote(instance.ejbRemote());
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedClass#modifiers() modifiers} attribute.
     * @param modifiers The value for modifiers 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder modifiers(int modifiers) {
      this.modifiers = modifiers;
      initBits &= ~INIT_BIT_MODIFIERS;
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedClass#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedClass#superName() superName} attribute.
     * @param superName The value for superName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder superName(@Nullable String superName) {
      this.superName = superName;
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#interfaceNames() interfaceNames} list.
     * @param element A interfaceNames element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInterfaceNames(String element) {
      this.interfaceNames.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#interfaceNames() interfaceNames} list.
     * @param elements An array of interfaceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInterfaceNames(String... elements) {
      this.interfaceNames.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#interfaceNames() interfaceNames} list.
     * @param elements An iterable of interfaceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder interfaceNames(Iterable<String> elements) {
      this.interfaceNames = ImmutableList.builder();
      return addAllInterfaceNames(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#interfaceNames() interfaceNames} list.
     * @param elements An iterable of interfaceNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInterfaceNames(Iterable<String> elements) {
      this.interfaceNames.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#analyzedMethods() analyzedMethods} list.
     * @param element A analyzedMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnalyzedMethods(AnalyzedMethod element) {
      this.analyzedMethods.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#analyzedMethods() analyzedMethods} list.
     * @param elements An array of analyzedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnalyzedMethods(AnalyzedMethod... elements) {
      this.analyzedMethods.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#analyzedMethods() analyzedMethods} list.
     * @param elements An iterable of analyzedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
      this.analyzedMethods = ImmutableList.builder();
      return addAllAnalyzedMethods(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#analyzedMethods() analyzedMethods} list.
     * @param elements An iterable of analyzedMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
      this.analyzedMethods.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#publicFinalMethods() publicFinalMethods} list.
     * @param element A publicFinalMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPublicFinalMethods(PublicFinalMethod element) {
      this.publicFinalMethods.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#publicFinalMethods() publicFinalMethods} list.
     * @param elements An array of publicFinalMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPublicFinalMethods(PublicFinalMethod... elements) {
      this.publicFinalMethods.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#publicFinalMethods() publicFinalMethods} list.
     * @param elements An iterable of publicFinalMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder publicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
      this.publicFinalMethods = ImmutableList.builder();
      return addAllPublicFinalMethods(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#publicFinalMethods() publicFinalMethods} list.
     * @param elements An iterable of publicFinalMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPublicFinalMethods(Iterable<? extends PublicFinalMethod> elements) {
      this.publicFinalMethods.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#shimTypes() shimTypes} list.
     * @param element A shimTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addShimTypes(ShimType element) {
      this.shimTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#shimTypes() shimTypes} list.
     * @param elements An array of shimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addShimTypes(ShimType... elements) {
      this.shimTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#shimTypes() shimTypes} list.
     * @param elements An iterable of shimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shimTypes(Iterable<? extends ShimType> elements) {
      this.shimTypes = ImmutableList.builder();
      return addAllShimTypes(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#shimTypes() shimTypes} list.
     * @param elements An iterable of shimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllShimTypes(Iterable<? extends ShimType> elements) {
      this.shimTypes.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#mixinTypes() mixinTypes} list.
     * @param element A mixinTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMixinTypes(MixinType element) {
      this.mixinTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#mixinTypes() mixinTypes} list.
     * @param elements An array of mixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMixinTypes(MixinType... elements) {
      this.mixinTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#mixinTypes() mixinTypes} list.
     * @param elements An iterable of mixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mixinTypes(Iterable<? extends MixinType> elements) {
      this.mixinTypes = ImmutableList.builder();
      return addAllMixinTypes(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#mixinTypes() mixinTypes} list.
     * @param elements An iterable of mixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMixinTypes(Iterable<? extends MixinType> elements) {
      this.mixinTypes.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes} list.
     * @param element A nonReweavableMixinTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavableMixinTypes(MixinType element) {
      this.nonReweavableMixinTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes} list.
     * @param elements An array of nonReweavableMixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavableMixinTypes(MixinType... elements) {
      this.nonReweavableMixinTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes} list.
     * @param elements An iterable of nonReweavableMixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
      this.nonReweavableMixinTypes = ImmutableList.builder();
      return addAllNonReweavableMixinTypes(elements);
    }

    /**
     * Adds elements to {@link AnalyzedClass#nonReweavableMixinTypes() nonReweavableMixinTypes} list.
     * @param elements An iterable of nonReweavableMixinTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNonReweavableMixinTypes(Iterable<? extends MixinType> elements) {
      this.nonReweavableMixinTypes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link AnalyzedClass#ejbRemote() ejbRemote} attribute.
     * @param ejbRemote The value for ejbRemote 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ejbRemote(boolean ejbRemote) {
      this.ejbRemote = ejbRemote;
      initBits &= ~INIT_BIT_EJB_REMOTE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnalyzedClass ImmutableAnalyzedClass}.
     * @return An immutable instance of AnalyzedClass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnalyzedClass build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAnalyzedClass(
          modifiers,
          name,
          superName,
          interfaceNames.build(),
          analyzedMethods.build(),
          publicFinalMethods.build(),
          shimTypes.build(),
          mixinTypes.build(),
          nonReweavableMixinTypes.build(),
          ejbRemote);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_MODIFIERS) != 0) attributes.add("modifiers");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_EJB_REMOTE) != 0) attributes.add("ejbRemote");
      return "Cannot build AnalyzedClass, some of required attributes are not set " + attributes;
    }
  }
}
