package org.glowroot.agent.shaded.org.glowroot.common.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveTraceRepository.EntriesAndQueries}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntriesAndQueries.builder()}.
 */
@Generated(from = "LiveTraceRepository.EntriesAndQueries", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEntriesAndQueries
    implements LiveTraceRepository.EntriesAndQueries {
  private final ImmutableList<TraceOuterClass.Trace.Entry> entries;
  private final ImmutableList<AggregateOuterClass.Aggregate.Query> queries;
  private final ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts;

  private ImmutableEntriesAndQueries(
      ImmutableList<TraceOuterClass.Trace.Entry> entries,
      ImmutableList<AggregateOuterClass.Aggregate.Query> queries,
      ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) {
    this.entries = entries;
    this.queries = queries;
    this.sharedQueryTexts = sharedQueryTexts;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @JsonProperty("entries")
  @Override
  public ImmutableList<TraceOuterClass.Trace.Entry> entries() {
    return entries;
  }

  /**
   * @return The value of the {@code queries} attribute
   */
  @JsonProperty("queries")
  @Override
  public ImmutableList<AggregateOuterClass.Aggregate.Query> queries() {
    return queries;
  }

  /**
   * @return The value of the {@code sharedQueryTexts} attribute
   */
  @JsonProperty("sharedQueryTexts")
  @Override
  public ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts() {
    return sharedQueryTexts;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#entries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withEntries(TraceOuterClass.Trace.Entry... elements) {
    ImmutableList<TraceOuterClass.Trace.Entry> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(newValue, this.queries, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#entries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withEntries(Iterable<? extends TraceOuterClass.Trace.Entry> elements) {
    if (this.entries == elements) return this;
    ImmutableList<TraceOuterClass.Trace.Entry> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(newValue, this.queries, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#queries() queries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withQueries(AggregateOuterClass.Aggregate.Query... elements) {
    ImmutableList<AggregateOuterClass.Aggregate.Query> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(this.entries, newValue, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#queries() queries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of queries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withQueries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
    if (this.queries == elements) return this;
    ImmutableList<AggregateOuterClass.Aggregate.Query> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(this.entries, newValue, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText... elements) {
    ImmutableList<TraceOuterClass.Trace.SharedQueryText> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(this.entries, this.queries, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sharedQueryTexts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEntriesAndQueries withSharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
    if (this.sharedQueryTexts == elements) return this;
    ImmutableList<TraceOuterClass.Trace.SharedQueryText> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEntriesAndQueries(this.entries, this.queries, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntriesAndQueries} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntriesAndQueries
        && equalTo((ImmutableEntriesAndQueries) another);
  }

  private boolean equalTo(ImmutableEntriesAndQueries another) {
    return entries.equals(another.entries)
        && queries.equals(another.queries)
        && sharedQueryTexts.equals(another.sharedQueryTexts);
  }

  /**
   * Computes a hash code from attributes: {@code entries}, {@code queries}, {@code sharedQueryTexts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + entries.hashCode();
    h += (h << 5) + queries.hashCode();
    h += (h << 5) + sharedQueryTexts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EntriesAndQueries} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EntriesAndQueries")
        .omitNullValues()
        .add("entries", entries)
        .add("queries", queries)
        .add("sharedQueryTexts", sharedQueryTexts)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveTraceRepository.EntriesAndQueries", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LiveTraceRepository.EntriesAndQueries {
    @Nullable List<TraceOuterClass.Trace.Entry> entries = ImmutableList.of();
    @Nullable List<AggregateOuterClass.Aggregate.Query> queries = ImmutableList.of();
    @Nullable List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts = ImmutableList.of();
    @JsonProperty("entries")
    public void setEntries(List<TraceOuterClass.Trace.Entry> entries) {
      this.entries = entries;
    }
    @JsonProperty("queries")
    public void setQueries(List<AggregateOuterClass.Aggregate.Query> queries) {
      this.queries = queries;
    }
    @JsonProperty("sharedQueryTexts")
    public void setSharedQueryTexts(List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) {
      this.sharedQueryTexts = sharedQueryTexts;
    }
    @Override
    public List<TraceOuterClass.Trace.Entry> entries() { throw new UnsupportedOperationException(); }
    @Override
    public List<AggregateOuterClass.Aggregate.Query> queries() { throw new UnsupportedOperationException(); }
    @Override
    public List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEntriesAndQueries fromJson(Json json) {
    ImmutableEntriesAndQueries.Builder builder = ImmutableEntriesAndQueries.builder();
    if (json.entries != null) {
      builder.addAllEntries(json.entries);
    }
    if (json.queries != null) {
      builder.addAllQueries(json.queries);
    }
    if (json.sharedQueryTexts != null) {
      builder.addAllSharedQueryTexts(json.sharedQueryTexts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveTraceRepository.EntriesAndQueries} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EntriesAndQueries instance
   */
  public static ImmutableEntriesAndQueries copyOf(LiveTraceRepository.EntriesAndQueries instance) {
    if (instance instanceof ImmutableEntriesAndQueries) {
      return (ImmutableEntriesAndQueries) instance;
    }
    return ImmutableEntriesAndQueries.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntriesAndQueries ImmutableEntriesAndQueries}.
   * <pre>
   * ImmutableEntriesAndQueries.builder()
   *    .addEntries|addAllEntries(org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass.Trace.Entry) // {@link LiveTraceRepository.EntriesAndQueries#entries() entries} elements
   *    .addQueries|addAllQueries(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.Query) // {@link LiveTraceRepository.EntriesAndQueries#queries() queries} elements
   *    .addSharedQueryTexts|addAllSharedQueryTexts(org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass.Trace.SharedQueryText) // {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts} elements
   *    .build();
   * </pre>
   * @return A new ImmutableEntriesAndQueries builder
   */
  public static ImmutableEntriesAndQueries.Builder builder() {
    return new ImmutableEntriesAndQueries.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntriesAndQueries ImmutableEntriesAndQueries}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveTraceRepository.EntriesAndQueries", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<TraceOuterClass.Trace.Entry> entries = ImmutableList.builder();
    private ImmutableList.Builder<AggregateOuterClass.Aggregate.Query> queries = ImmutableList.builder();
    private ImmutableList.Builder<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EntriesAndQueries} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(LiveTraceRepository.EntriesAndQueries instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllEntries(instance.entries());
      addAllQueries(instance.queries());
      addAllSharedQueryTexts(instance.sharedQueryTexts());
      return this;
    }

    /**
     * Adds one element to {@link LiveTraceRepository.EntriesAndQueries#entries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(TraceOuterClass.Trace.Entry element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#entries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(TraceOuterClass.Trace.Entry... elements) {
      this.entries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveTraceRepository.EntriesAndQueries#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder entries(Iterable<? extends TraceOuterClass.Trace.Entry> elements) {
      this.entries = ImmutableList.builder();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#entries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntries(Iterable<? extends TraceOuterClass.Trace.Entry> elements) {
      this.entries.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link LiveTraceRepository.EntriesAndQueries#queries() queries} list.
     * @param element A queries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueries(AggregateOuterClass.Aggregate.Query element) {
      this.queries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#queries() queries} list.
     * @param elements An array of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueries(AggregateOuterClass.Aggregate.Query... elements) {
      this.queries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveTraceRepository.EntriesAndQueries#queries() queries} list.
     * @param elements An iterable of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder queries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
      this.queries = ImmutableList.builder();
      return addAllQueries(elements);
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#queries() queries} list.
     * @param elements An iterable of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllQueries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
      this.queries.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts} list.
     * @param element A sharedQueryTexts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText element) {
      this.sharedQueryTexts.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An array of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText... elements) {
      this.sharedQueryTexts.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An iterable of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
      this.sharedQueryTexts = ImmutableList.builder();
      return addAllSharedQueryTexts(elements);
    }

    /**
     * Adds elements to {@link LiveTraceRepository.EntriesAndQueries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An iterable of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
      this.sharedQueryTexts.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntriesAndQueries ImmutableEntriesAndQueries}.
     * @return An immutable instance of EntriesAndQueries
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntriesAndQueries build() {
      return new ImmutableEntriesAndQueries(entries.build(), queries.build(), sharedQueryTexts.build());
    }
  }
}
