package org.glowroot.agent.shaded.org.glowroot.common.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveAggregateRepository.AggregateQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAggregateQuery.builder()}.
 */
@Generated(from = "LiveAggregateRepository.AggregateQuery", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAggregateQuery
    implements LiveAggregateRepository.AggregateQuery {
  private final String transactionType;
  private final @Nullable String transactionName;
  private final long from;
  private final long to;
  private final int rollupLevel;

  private ImmutableAggregateQuery(
      String transactionType,
      @Nullable String transactionName,
      long from,
      long to,
      int rollupLevel) {
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.from = from;
    this.to = to;
    this.rollupLevel = rollupLevel;
  }

  /**
   * @return The value of the {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }

  /**
   * @return The value of the {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public @Nullable String transactionName() {
    return transactionName;
  }

  /**
   * @return The value of the {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }

  /**
   * @return The value of the {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }

  /**
   * @return The value of the {@code rollupLevel} attribute
   */
  @JsonProperty("rollupLevel")
  @Override
  public int rollupLevel() {
    return rollupLevel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.AggregateQuery#transactionType() transactionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregateQuery withTransactionType(String value) {
    String newValue = Preconditions.checkNotNull(value, "transactionType");
    if (this.transactionType.equals(newValue)) return this;
    return new ImmutableAggregateQuery(newValue, this.transactionName, this.from, this.to, this.rollupLevel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.AggregateQuery#transactionName() transactionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregateQuery withTransactionName(@Nullable String value) {
    if (Objects.equal(this.transactionName, value)) return this;
    return new ImmutableAggregateQuery(this.transactionType, value, this.from, this.to, this.rollupLevel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.AggregateQuery#from() from} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for from
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregateQuery withFrom(long value) {
    if (this.from == value) return this;
    return new ImmutableAggregateQuery(this.transactionType, this.transactionName, value, this.to, this.rollupLevel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.AggregateQuery#to() to} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for to
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregateQuery withTo(long value) {
    if (this.to == value) return this;
    return new ImmutableAggregateQuery(this.transactionType, this.transactionName, this.from, value, this.rollupLevel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.AggregateQuery#rollupLevel() rollupLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rollupLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregateQuery withRollupLevel(int value) {
    if (this.rollupLevel == value) return this;
    return new ImmutableAggregateQuery(this.transactionType, this.transactionName, this.from, this.to, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAggregateQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAggregateQuery
        && equalTo((ImmutableAggregateQuery) another);
  }

  private boolean equalTo(ImmutableAggregateQuery another) {
    return transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && from == another.from
        && to == another.to
        && rollupLevel == another.rollupLevel;
  }

  /**
   * Computes a hash code from attributes: {@code transactionType}, {@code transactionName}, {@code from}, {@code to}, {@code rollupLevel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + transactionType.hashCode();
    h += (h << 5) + Objects.hashCode(transactionName);
    h += (h << 5) + Longs.hashCode(from);
    h += (h << 5) + Longs.hashCode(to);
    h += (h << 5) + rollupLevel;
    return h;
  }

  /**
   * Prints the immutable value {@code AggregateQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AggregateQuery")
        .omitNullValues()
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("from", from)
        .add("to", to)
        .add("rollupLevel", rollupLevel)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveAggregateRepository.AggregateQuery", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LiveAggregateRepository.AggregateQuery {
    @org.glowroot.agent.shaded.javax.annotation.Nullable String transactionType;
    @org.glowroot.agent.shaded.javax.annotation.Nullable String transactionName;
    long from;
    boolean fromIsSet;
    long to;
    boolean toIsSet;
    int rollupLevel;
    boolean rollupLevelIsSet;
    @JsonProperty("transactionType")
    public void setTransactionType(String transactionType) {
      this.transactionType = transactionType;
    }
    @JsonProperty("transactionName")
    public void setTransactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
    }
    @JsonProperty("from")
    public void setFrom(long from) {
      this.from = from;
      this.fromIsSet = true;
    }
    @JsonProperty("to")
    public void setTo(long to) {
      this.to = to;
      this.toIsSet = true;
    }
    @JsonProperty("rollupLevel")
    public void setRollupLevel(int rollupLevel) {
      this.rollupLevel = rollupLevel;
      this.rollupLevelIsSet = true;
    }
    @Override
    public String transactionType() { throw new UnsupportedOperationException(); }
    @Override
    public String transactionName() { throw new UnsupportedOperationException(); }
    @Override
    public long from() { throw new UnsupportedOperationException(); }
    @Override
    public long to() { throw new UnsupportedOperationException(); }
    @Override
    public int rollupLevel() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAggregateQuery fromJson(Json json) {
    ImmutableAggregateQuery.Builder builder = ImmutableAggregateQuery.builder();
    if (json.transactionType != null) {
      builder.transactionType(json.transactionType);
    }
    if (json.transactionName != null) {
      builder.transactionName(json.transactionName);
    }
    if (json.fromIsSet) {
      builder.from(json.from);
    }
    if (json.toIsSet) {
      builder.to(json.to);
    }
    if (json.rollupLevelIsSet) {
      builder.rollupLevel(json.rollupLevel);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveAggregateRepository.AggregateQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AggregateQuery instance
   */
  public static ImmutableAggregateQuery copyOf(LiveAggregateRepository.AggregateQuery instance) {
    if (instance instanceof ImmutableAggregateQuery) {
      return (ImmutableAggregateQuery) instance;
    }
    return ImmutableAggregateQuery.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAggregateQuery ImmutableAggregateQuery}.
   * <pre>
   * ImmutableAggregateQuery.builder()
   *    .transactionType(String) // required {@link LiveAggregateRepository.AggregateQuery#transactionType() transactionType}
   *    .transactionName(String | null) // nullable {@link LiveAggregateRepository.AggregateQuery#transactionName() transactionName}
   *    .from(long) // required {@link LiveAggregateRepository.AggregateQuery#from() from}
   *    .to(long) // required {@link LiveAggregateRepository.AggregateQuery#to() to}
   *    .rollupLevel(int) // required {@link LiveAggregateRepository.AggregateQuery#rollupLevel() rollupLevel}
   *    .build();
   * </pre>
   * @return A new ImmutableAggregateQuery builder
   */
  public static ImmutableAggregateQuery.Builder builder() {
    return new ImmutableAggregateQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAggregateQuery ImmutableAggregateQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveAggregateRepository.AggregateQuery", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION_TYPE = 0x1L;
    private static final long INIT_BIT_FROM = 0x2L;
    private static final long INIT_BIT_TO = 0x4L;
    private static final long INIT_BIT_ROLLUP_LEVEL = 0x8L;
    private long initBits = 0xfL;

    private @org.glowroot.agent.shaded.javax.annotation.Nullable String transactionType;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable String transactionName;
    private long from;
    private long to;
    private int rollupLevel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AggregateQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(LiveAggregateRepository.AggregateQuery instance) {
      Preconditions.checkNotNull(instance, "instance");
      transactionType(instance.transactionType());
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      from(instance.from());
      to(instance.to());
      rollupLevel(instance.rollupLevel());
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.AggregateQuery#transactionType() transactionType} attribute.
     * @param transactionType The value for transactionType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType, "transactionType");
      initBits &= ~INIT_BIT_TRANSACTION_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.AggregateQuery#transactionName() transactionName} attribute.
     * @param transactionName The value for transactionName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.AggregateQuery#from() from} attribute.
     * @param from The value for from 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initBits &= ~INIT_BIT_FROM;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.AggregateQuery#to() to} attribute.
     * @param to The value for to 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initBits &= ~INIT_BIT_TO;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.AggregateQuery#rollupLevel() rollupLevel} attribute.
     * @param rollupLevel The value for rollupLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rollupLevel(int rollupLevel) {
      this.rollupLevel = rollupLevel;
      initBits &= ~INIT_BIT_ROLLUP_LEVEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAggregateQuery ImmutableAggregateQuery}.
     * @return An immutable instance of AggregateQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAggregateQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAggregateQuery(transactionType, transactionName, from, to, rollupLevel);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TRANSACTION_TYPE) != 0) attributes.add("transactionType");
      if ((initBits & INIT_BIT_FROM) != 0) attributes.add("from");
      if ((initBits & INIT_BIT_TO) != 0) attributes.add("to");
      if ((initBits & INIT_BIT_ROLLUP_LEVEL) != 0) attributes.add("rollupLevel");
      return "Cannot build AggregateQuery, some of required attributes are not set " + attributes;
    }
  }
}
