package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UiDefaultsConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUiDefaultsConfig.builder()}.
 */
@Generated(from = "UiDefaultsConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableUiDefaultsConfig extends UiDefaultsConfig {
  private final String defaultTransactionType;
  private final ImmutableList<Double> defaultPercentiles;
  private final ImmutableList<String> defaultGaugeNames;

  private ImmutableUiDefaultsConfig(ImmutableUiDefaultsConfig.Builder builder) {
    if (builder.defaultTransactionType != null) {
      initShim.defaultTransactionType(builder.defaultTransactionType);
    }
    if (builder.defaultPercentilesIsSet()) {
      initShim.defaultPercentiles(builder.defaultPercentiles.build());
    }
    if (builder.defaultGaugeNamesIsSet()) {
      initShim.defaultGaugeNames(builder.defaultGaugeNames.build());
    }
    this.defaultTransactionType = initShim.defaultTransactionType();
    this.defaultPercentiles = initShim.defaultPercentiles();
    this.defaultGaugeNames = initShim.defaultGaugeNames();
    this.initShim = null;
  }

  private ImmutableUiDefaultsConfig(
      String defaultTransactionType,
      ImmutableList<Double> defaultPercentiles,
      ImmutableList<String> defaultGaugeNames) {
    this.defaultTransactionType = defaultTransactionType;
    this.defaultPercentiles = defaultPercentiles;
    this.defaultGaugeNames = defaultGaugeNames;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "UiDefaultsConfig", generator = "Immutables")
  private final class InitShim {
    private byte defaultTransactionTypeBuildStage = STAGE_UNINITIALIZED;
    private String defaultTransactionType;

    String defaultTransactionType() {
      if (defaultTransactionTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultTransactionTypeBuildStage == STAGE_UNINITIALIZED) {
        defaultTransactionTypeBuildStage = STAGE_INITIALIZING;
        this.defaultTransactionType = Preconditions.checkNotNull(ImmutableUiDefaultsConfig.super.defaultTransactionType(), "defaultTransactionType");
        defaultTransactionTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultTransactionType;
    }

    void defaultTransactionType(String defaultTransactionType) {
      this.defaultTransactionType = defaultTransactionType;
      defaultTransactionTypeBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultPercentilesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<Double> defaultPercentiles;

    ImmutableList<Double> defaultPercentiles() {
      if (defaultPercentilesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultPercentilesBuildStage == STAGE_UNINITIALIZED) {
        defaultPercentilesBuildStage = STAGE_INITIALIZING;
        this.defaultPercentiles = Preconditions.checkNotNull(ImmutableUiDefaultsConfig.super.defaultPercentiles(), "defaultPercentiles");
        defaultPercentilesBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultPercentiles;
    }

    void defaultPercentiles(ImmutableList<Double> defaultPercentiles) {
      this.defaultPercentiles = defaultPercentiles;
      defaultPercentilesBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultGaugeNamesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> defaultGaugeNames;

    ImmutableList<String> defaultGaugeNames() {
      if (defaultGaugeNamesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultGaugeNamesBuildStage == STAGE_UNINITIALIZED) {
        defaultGaugeNamesBuildStage = STAGE_INITIALIZING;
        this.defaultGaugeNames = Preconditions.checkNotNull(ImmutableUiDefaultsConfig.super.defaultGaugeNames(), "defaultGaugeNames");
        defaultGaugeNamesBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultGaugeNames;
    }

    void defaultGaugeNames(ImmutableList<String> defaultGaugeNames) {
      this.defaultGaugeNames = defaultGaugeNames;
      defaultGaugeNamesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<String>();
      if (defaultTransactionTypeBuildStage == STAGE_INITIALIZING) attributes.add("defaultTransactionType");
      if (defaultPercentilesBuildStage == STAGE_INITIALIZING) attributes.add("defaultPercentiles");
      if (defaultGaugeNamesBuildStage == STAGE_INITIALIZING) attributes.add("defaultGaugeNames");
      return "Cannot build UiDefaultsConfig, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code defaultTransactionType} attribute
   */
  @JsonProperty("defaultTransactionType")
  @Override
  public String defaultTransactionType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultTransactionType()
        : this.defaultTransactionType;
  }

  /**
   * @return The value of the {@code defaultPercentiles} attribute
   */
  @JsonProperty("defaultPercentiles")
  @Override
  public ImmutableList<Double> defaultPercentiles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultPercentiles()
        : this.defaultPercentiles;
  }

  /**
   * @return The value of the {@code defaultGaugeNames} attribute
   */
  @JsonProperty("defaultGaugeNames")
  @Override
  public ImmutableList<String> defaultGaugeNames() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultGaugeNames()
        : this.defaultGaugeNames;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UiDefaultsConfig#defaultTransactionType() defaultTransactionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultTransactionType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUiDefaultsConfig withDefaultTransactionType(String value) {
    String newValue = Preconditions.checkNotNull(value, "defaultTransactionType");
    if (this.defaultTransactionType.equals(newValue)) return this;
    return new ImmutableUiDefaultsConfig(newValue, this.defaultPercentiles, this.defaultGaugeNames);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUiDefaultsConfig withDefaultPercentiles(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new ImmutableUiDefaultsConfig(this.defaultTransactionType, newValue, this.defaultGaugeNames);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of defaultPercentiles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUiDefaultsConfig withDefaultPercentiles(Iterable<Double> elements) {
    if (this.defaultPercentiles == elements) return this;
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUiDefaultsConfig(this.defaultTransactionType, newValue, this.defaultGaugeNames);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUiDefaultsConfig withDefaultGaugeNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUiDefaultsConfig(this.defaultTransactionType, this.defaultPercentiles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of defaultGaugeNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUiDefaultsConfig withDefaultGaugeNames(Iterable<String> elements) {
    if (this.defaultGaugeNames == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUiDefaultsConfig(this.defaultTransactionType, this.defaultPercentiles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUiDefaultsConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUiDefaultsConfig
        && equalTo((ImmutableUiDefaultsConfig) another);
  }

  private boolean equalTo(ImmutableUiDefaultsConfig another) {
    return defaultTransactionType.equals(another.defaultTransactionType)
        && defaultPercentiles.equals(another.defaultPercentiles)
        && defaultGaugeNames.equals(another.defaultGaugeNames);
  }

  /**
   * Computes a hash code from attributes: {@code defaultTransactionType}, {@code defaultPercentiles}, {@code defaultGaugeNames}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + defaultTransactionType.hashCode();
    h += (h << 5) + defaultPercentiles.hashCode();
    h += (h << 5) + defaultGaugeNames.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UiDefaultsConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UiDefaultsConfig")
        .omitNullValues()
        .add("defaultTransactionType", defaultTransactionType)
        .add("defaultPercentiles", defaultPercentiles)
        .add("defaultGaugeNames", defaultGaugeNames)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UiDefaultsConfig", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends UiDefaultsConfig {
    @Nullable String defaultTransactionType;
    @Nullable ImmutableList<Double> defaultPercentiles = ImmutableList.of();
    boolean defaultPercentilesIsSet;
    @Nullable ImmutableList<String> defaultGaugeNames = ImmutableList.of();
    boolean defaultGaugeNamesIsSet;
    @JsonProperty("defaultTransactionType")
    public void setDefaultTransactionType(String defaultTransactionType) {
      this.defaultTransactionType = defaultTransactionType;
    }
    @JsonProperty("defaultPercentiles")
    public void setDefaultPercentiles(ImmutableList<Double> defaultPercentiles) {
      this.defaultPercentiles = defaultPercentiles;
      this.defaultPercentilesIsSet = true;
    }
    @JsonProperty("defaultGaugeNames")
    public void setDefaultGaugeNames(ImmutableList<String> defaultGaugeNames) {
      this.defaultGaugeNames = defaultGaugeNames;
      this.defaultGaugeNamesIsSet = true;
    }
    @Override
    public String defaultTransactionType() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<Double> defaultPercentiles() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<String> defaultGaugeNames() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUiDefaultsConfig fromJson(Json json) {
    ImmutableUiDefaultsConfig.Builder builder = ImmutableUiDefaultsConfig.builder();
    if (json.defaultTransactionType != null) {
      builder.defaultTransactionType(json.defaultTransactionType);
    }
    if (json.defaultPercentilesIsSet) {
      builder.addAllDefaultPercentiles(json.defaultPercentiles);
    }
    if (json.defaultGaugeNamesIsSet) {
      builder.addAllDefaultGaugeNames(json.defaultGaugeNames);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UiDefaultsConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UiDefaultsConfig instance
   */
  public static ImmutableUiDefaultsConfig copyOf(UiDefaultsConfig instance) {
    if (instance instanceof ImmutableUiDefaultsConfig) {
      return (ImmutableUiDefaultsConfig) instance;
    }
    return ImmutableUiDefaultsConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUiDefaultsConfig ImmutableUiDefaultsConfig}.
   * <pre>
   * ImmutableUiDefaultsConfig.builder()
   *    .defaultTransactionType(String) // optional {@link UiDefaultsConfig#defaultTransactionType() defaultTransactionType}
   *    .addDefaultPercentiles|addAllDefaultPercentiles(double) // {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles} elements
   *    .addDefaultGaugeNames|addAllDefaultGaugeNames(String) // {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames} elements
   *    .build();
   * </pre>
   * @return A new ImmutableUiDefaultsConfig builder
   */
  public static ImmutableUiDefaultsConfig.Builder builder() {
    return new ImmutableUiDefaultsConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUiDefaultsConfig ImmutableUiDefaultsConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UiDefaultsConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_DEFAULT_PERCENTILES = 0x1L;
    private static final long OPT_BIT_DEFAULT_GAUGE_NAMES = 0x2L;
    private long optBits;

    private @Nullable String defaultTransactionType;
    private ImmutableList.Builder<Double> defaultPercentiles = ImmutableList.builder();
    private ImmutableList.Builder<String> defaultGaugeNames = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UiDefaultsConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(UiDefaultsConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      defaultTransactionType(instance.defaultTransactionType());
      addAllDefaultPercentiles(instance.defaultPercentiles());
      addAllDefaultGaugeNames(instance.defaultGaugeNames());
      return this;
    }

    /**
     * Initializes the value for the {@link UiDefaultsConfig#defaultTransactionType() defaultTransactionType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link UiDefaultsConfig#defaultTransactionType() defaultTransactionType}.</em>
     * @param defaultTransactionType The value for defaultTransactionType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultTransactionType(String defaultTransactionType) {
      this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType, "defaultTransactionType");
      return this;
    }

    /**
     * Adds one element to {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles} list.
     * @param element A defaultPercentiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDefaultPercentiles(double element) {
      this.defaultPercentiles.add(element);
      optBits |= OPT_BIT_DEFAULT_PERCENTILES;
      return this;
    }

    /**
     * Adds elements to {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles} list.
     * @param elements An array of defaultPercentiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDefaultPercentiles(double... elements) {
      this.defaultPercentiles.addAll(Doubles.asList(elements));
      optBits |= OPT_BIT_DEFAULT_PERCENTILES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles} list.
     * @param elements An iterable of defaultPercentiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultPercentiles(Iterable<Double> elements) {
      this.defaultPercentiles = ImmutableList.builder();
      return addAllDefaultPercentiles(elements);
    }

    /**
     * Adds elements to {@link UiDefaultsConfig#defaultPercentiles() defaultPercentiles} list.
     * @param elements An iterable of defaultPercentiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDefaultPercentiles(Iterable<Double> elements) {
      this.defaultPercentiles.addAll(elements);
      optBits |= OPT_BIT_DEFAULT_PERCENTILES;
      return this;
    }

    /**
     * Adds one element to {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames} list.
     * @param element A defaultGaugeNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDefaultGaugeNames(String element) {
      this.defaultGaugeNames.add(element);
      optBits |= OPT_BIT_DEFAULT_GAUGE_NAMES;
      return this;
    }

    /**
     * Adds elements to {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames} list.
     * @param elements An array of defaultGaugeNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDefaultGaugeNames(String... elements) {
      this.defaultGaugeNames.add(elements);
      optBits |= OPT_BIT_DEFAULT_GAUGE_NAMES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames} list.
     * @param elements An iterable of defaultGaugeNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultGaugeNames(Iterable<String> elements) {
      this.defaultGaugeNames = ImmutableList.builder();
      return addAllDefaultGaugeNames(elements);
    }

    /**
     * Adds elements to {@link UiDefaultsConfig#defaultGaugeNames() defaultGaugeNames} list.
     * @param elements An iterable of defaultGaugeNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDefaultGaugeNames(Iterable<String> elements) {
      this.defaultGaugeNames.addAll(elements);
      optBits |= OPT_BIT_DEFAULT_GAUGE_NAMES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUiDefaultsConfig ImmutableUiDefaultsConfig}.
     * @return An immutable instance of UiDefaultsConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUiDefaultsConfig build() {
      return new ImmutableUiDefaultsConfig(this);
    }

    private boolean defaultPercentilesIsSet() {
      return (optBits & OPT_BIT_DEFAULT_PERCENTILES) != 0;
    }

    private boolean defaultGaugeNamesIsSet() {
      return (optBits & OPT_BIT_DEFAULT_GAUGE_NAMES) != 0;
    }
  }
}
