package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransactionConfig.builder()}.
 */
@Generated(from = "TransactionConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTransactionConfig extends TransactionConfig {
  private final int slowThresholdMillis;
  private final int profilingIntervalMillis;
  private final boolean captureThreadStats;
  private final ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides;

  private ImmutableTransactionConfig(ImmutableTransactionConfig.Builder builder) {
    this.slowThresholdOverrides = builder.slowThresholdOverrides.build();
    if (builder.slowThresholdMillisIsSet()) {
      initShim.slowThresholdMillis(builder.slowThresholdMillis);
    }
    if (builder.profilingIntervalMillisIsSet()) {
      initShim.profilingIntervalMillis(builder.profilingIntervalMillis);
    }
    if (builder.captureThreadStatsIsSet()) {
      initShim.captureThreadStats(builder.captureThreadStats);
    }
    this.slowThresholdMillis = initShim.slowThresholdMillis();
    this.profilingIntervalMillis = initShim.profilingIntervalMillis();
    this.captureThreadStats = initShim.captureThreadStats();
    this.initShim = null;
  }

  private ImmutableTransactionConfig(
      int slowThresholdMillis,
      int profilingIntervalMillis,
      boolean captureThreadStats,
      ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides) {
    this.slowThresholdMillis = slowThresholdMillis;
    this.profilingIntervalMillis = profilingIntervalMillis;
    this.captureThreadStats = captureThreadStats;
    this.slowThresholdOverrides = slowThresholdOverrides;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TransactionConfig", generator = "Immutables")
  private final class InitShim {
    private byte slowThresholdMillisBuildStage = STAGE_UNINITIALIZED;
    private int slowThresholdMillis;

    int slowThresholdMillis() {
      if (slowThresholdMillisBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (slowThresholdMillisBuildStage == STAGE_UNINITIALIZED) {
        slowThresholdMillisBuildStage = STAGE_INITIALIZING;
        this.slowThresholdMillis = ImmutableTransactionConfig.super.slowThresholdMillis();
        slowThresholdMillisBuildStage = STAGE_INITIALIZED;
      }
      return this.slowThresholdMillis;
    }

    void slowThresholdMillis(int slowThresholdMillis) {
      this.slowThresholdMillis = slowThresholdMillis;
      slowThresholdMillisBuildStage = STAGE_INITIALIZED;
    }

    private byte profilingIntervalMillisBuildStage = STAGE_UNINITIALIZED;
    private int profilingIntervalMillis;

    int profilingIntervalMillis() {
      if (profilingIntervalMillisBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (profilingIntervalMillisBuildStage == STAGE_UNINITIALIZED) {
        profilingIntervalMillisBuildStage = STAGE_INITIALIZING;
        this.profilingIntervalMillis = ImmutableTransactionConfig.super.profilingIntervalMillis();
        profilingIntervalMillisBuildStage = STAGE_INITIALIZED;
      }
      return this.profilingIntervalMillis;
    }

    void profilingIntervalMillis(int profilingIntervalMillis) {
      this.profilingIntervalMillis = profilingIntervalMillis;
      profilingIntervalMillisBuildStage = STAGE_INITIALIZED;
    }

    private byte captureThreadStatsBuildStage = STAGE_UNINITIALIZED;
    private boolean captureThreadStats;

    boolean captureThreadStats() {
      if (captureThreadStatsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (captureThreadStatsBuildStage == STAGE_UNINITIALIZED) {
        captureThreadStatsBuildStage = STAGE_INITIALIZING;
        this.captureThreadStats = ImmutableTransactionConfig.super.captureThreadStats();
        captureThreadStatsBuildStage = STAGE_INITIALIZED;
      }
      return this.captureThreadStats;
    }

    void captureThreadStats(boolean captureThreadStats) {
      this.captureThreadStats = captureThreadStats;
      captureThreadStatsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<String>();
      if (slowThresholdMillisBuildStage == STAGE_INITIALIZING) attributes.add("slowThresholdMillis");
      if (profilingIntervalMillisBuildStage == STAGE_INITIALIZING) attributes.add("profilingIntervalMillis");
      if (captureThreadStatsBuildStage == STAGE_INITIALIZING) attributes.add("captureThreadStats");
      return "Cannot build TransactionConfig, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code slowThresholdMillis} attribute
   */
  @JsonProperty("slowThresholdMillis")
  @Override
  public int slowThresholdMillis() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.slowThresholdMillis()
        : this.slowThresholdMillis;
  }

  /**
   * @return The value of the {@code profilingIntervalMillis} attribute
   */
  @JsonProperty("profilingIntervalMillis")
  @Override
  public int profilingIntervalMillis() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.profilingIntervalMillis()
        : this.profilingIntervalMillis;
  }

  /**
   * @return The value of the {@code captureThreadStats} attribute
   */
  @JsonProperty("captureThreadStats")
  @Override
  public boolean captureThreadStats() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.captureThreadStats()
        : this.captureThreadStats;
  }

  /**
   * @return The value of the {@code slowThresholdOverrides} attribute
   */
  @JsonProperty("slowThresholdOverrides")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides() {
    return slowThresholdOverrides;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig#slowThresholdMillis() slowThresholdMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slowThresholdMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionConfig withSlowThresholdMillis(int value) {
    if (this.slowThresholdMillis == value) return this;
    return new ImmutableTransactionConfig(value, this.profilingIntervalMillis, this.captureThreadStats, this.slowThresholdOverrides);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig#profilingIntervalMillis() profilingIntervalMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for profilingIntervalMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionConfig withProfilingIntervalMillis(int value) {
    if (this.profilingIntervalMillis == value) return this;
    return new ImmutableTransactionConfig(this.slowThresholdMillis, value, this.captureThreadStats, this.slowThresholdOverrides);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig#captureThreadStats() captureThreadStats} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for captureThreadStats
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionConfig withCaptureThreadStats(boolean value) {
    if (this.captureThreadStats == value) return this;
    return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, value, this.slowThresholdOverrides);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransactionConfig withSlowThresholdOverrides(ImmutableSlowThresholdOverride... elements) {
    ImmutableList<ImmutableSlowThresholdOverride> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of slowThresholdOverrides elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransactionConfig withSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
    if (this.slowThresholdOverrides == elements) return this;
    ImmutableList<ImmutableSlowThresholdOverride> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransactionConfig(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransactionConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransactionConfig
        && equalTo((ImmutableTransactionConfig) another);
  }

  private boolean equalTo(ImmutableTransactionConfig another) {
    return slowThresholdMillis == another.slowThresholdMillis
        && profilingIntervalMillis == another.profilingIntervalMillis
        && captureThreadStats == another.captureThreadStats
        && slowThresholdOverrides.equals(another.slowThresholdOverrides);
  }

  /**
   * Computes a hash code from attributes: {@code slowThresholdMillis}, {@code profilingIntervalMillis}, {@code captureThreadStats}, {@code slowThresholdOverrides}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + slowThresholdMillis;
    h += (h << 5) + profilingIntervalMillis;
    h += (h << 5) + Booleans.hashCode(captureThreadStats);
    h += (h << 5) + slowThresholdOverrides.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransactionConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionConfig")
        .omitNullValues()
        .add("slowThresholdMillis", slowThresholdMillis)
        .add("profilingIntervalMillis", profilingIntervalMillis)
        .add("captureThreadStats", captureThreadStats)
        .add("slowThresholdOverrides", slowThresholdOverrides)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransactionConfig", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TransactionConfig {
    int slowThresholdMillis;
    boolean slowThresholdMillisIsSet;
    int profilingIntervalMillis;
    boolean profilingIntervalMillisIsSet;
    boolean captureThreadStats;
    boolean captureThreadStatsIsSet;
    @Nullable ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides = ImmutableList.of();
    @JsonProperty("slowThresholdMillis")
    public void setSlowThresholdMillis(int slowThresholdMillis) {
      this.slowThresholdMillis = slowThresholdMillis;
      this.slowThresholdMillisIsSet = true;
    }
    @JsonProperty("profilingIntervalMillis")
    public void setProfilingIntervalMillis(int profilingIntervalMillis) {
      this.profilingIntervalMillis = profilingIntervalMillis;
      this.profilingIntervalMillisIsSet = true;
    }
    @JsonProperty("captureThreadStats")
    public void setCaptureThreadStats(boolean captureThreadStats) {
      this.captureThreadStats = captureThreadStats;
      this.captureThreadStatsIsSet = true;
    }
    @JsonProperty("slowThresholdOverrides")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setSlowThresholdOverrides(ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides) {
      this.slowThresholdOverrides = slowThresholdOverrides;
    }
    @Override
    public int slowThresholdMillis() { throw new UnsupportedOperationException(); }
    @Override
    public int profilingIntervalMillis() { throw new UnsupportedOperationException(); }
    @Override
    public boolean captureThreadStats() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<ImmutableSlowThresholdOverride> slowThresholdOverrides() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransactionConfig fromJson(Json json) {
    ImmutableTransactionConfig.Builder builder = ImmutableTransactionConfig.builder();
    if (json.slowThresholdMillisIsSet) {
      builder.slowThresholdMillis(json.slowThresholdMillis);
    }
    if (json.profilingIntervalMillisIsSet) {
      builder.profilingIntervalMillis(json.profilingIntervalMillis);
    }
    if (json.captureThreadStatsIsSet) {
      builder.captureThreadStats(json.captureThreadStats);
    }
    if (json.slowThresholdOverrides != null) {
      builder.addAllSlowThresholdOverrides(json.slowThresholdOverrides);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TransactionConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransactionConfig instance
   */
  public static ImmutableTransactionConfig copyOf(TransactionConfig instance) {
    if (instance instanceof ImmutableTransactionConfig) {
      return (ImmutableTransactionConfig) instance;
    }
    return ImmutableTransactionConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransactionConfig ImmutableTransactionConfig}.
   * <pre>
   * ImmutableTransactionConfig.builder()
   *    .slowThresholdMillis(int) // optional {@link TransactionConfig#slowThresholdMillis() slowThresholdMillis}
   *    .profilingIntervalMillis(int) // optional {@link TransactionConfig#profilingIntervalMillis() profilingIntervalMillis}
   *    .captureThreadStats(boolean) // optional {@link TransactionConfig#captureThreadStats() captureThreadStats}
   *    .addSlowThresholdOverrides|addAllSlowThresholdOverrides(ImmutableSlowThresholdOverride) // {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTransactionConfig builder
   */
  public static ImmutableTransactionConfig.Builder builder() {
    return new ImmutableTransactionConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransactionConfig ImmutableTransactionConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SLOW_THRESHOLD_MILLIS = 0x1L;
    private static final long OPT_BIT_PROFILING_INTERVAL_MILLIS = 0x2L;
    private static final long OPT_BIT_CAPTURE_THREAD_STATS = 0x4L;
    private long optBits;

    private int slowThresholdMillis;
    private int profilingIntervalMillis;
    private boolean captureThreadStats;
    private ImmutableList.Builder<ImmutableSlowThresholdOverride> slowThresholdOverrides = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransactionConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(TransactionConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      slowThresholdMillis(instance.slowThresholdMillis());
      profilingIntervalMillis(instance.profilingIntervalMillis());
      captureThreadStats(instance.captureThreadStats());
      addAllSlowThresholdOverrides(instance.slowThresholdOverrides());
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig#slowThresholdMillis() slowThresholdMillis} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionConfig#slowThresholdMillis() slowThresholdMillis}.</em>
     * @param slowThresholdMillis The value for slowThresholdMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder slowThresholdMillis(int slowThresholdMillis) {
      this.slowThresholdMillis = slowThresholdMillis;
      optBits |= OPT_BIT_SLOW_THRESHOLD_MILLIS;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig#profilingIntervalMillis() profilingIntervalMillis} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionConfig#profilingIntervalMillis() profilingIntervalMillis}.</em>
     * @param profilingIntervalMillis The value for profilingIntervalMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
      this.profilingIntervalMillis = profilingIntervalMillis;
      optBits |= OPT_BIT_PROFILING_INTERVAL_MILLIS;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig#captureThreadStats() captureThreadStats} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionConfig#captureThreadStats() captureThreadStats}.</em>
     * @param captureThreadStats The value for captureThreadStats 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder captureThreadStats(boolean captureThreadStats) {
      this.captureThreadStats = captureThreadStats;
      optBits |= OPT_BIT_CAPTURE_THREAD_STATS;
      return this;
    }

    /**
     * Adds one element to {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides} list.
     * @param element A slowThresholdOverrides element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverride element) {
      this.slowThresholdOverrides.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides} list.
     * @param elements An array of slowThresholdOverrides elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverride... elements) {
      this.slowThresholdOverrides.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides} list.
     * @param elements An iterable of slowThresholdOverrides elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder slowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
      this.slowThresholdOverrides = ImmutableList.builder();
      return addAllSlowThresholdOverrides(elements);
    }

    /**
     * Adds elements to {@link TransactionConfig#slowThresholdOverrides() slowThresholdOverrides} list.
     * @param elements An iterable of slowThresholdOverrides elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverride> elements) {
      this.slowThresholdOverrides.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransactionConfig ImmutableTransactionConfig}.
     * @return An immutable instance of TransactionConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransactionConfig build() {
      return new ImmutableTransactionConfig(this);
    }

    private boolean slowThresholdMillisIsSet() {
      return (optBits & OPT_BIT_SLOW_THRESHOLD_MILLIS) != 0;
    }

    private boolean profilingIntervalMillisIsSet() {
      return (optBits & OPT_BIT_PROFILING_INTERVAL_MILLIS) != 0;
    }

    private boolean captureThreadStatsIsSet() {
      return (optBits & OPT_BIT_CAPTURE_THREAD_STATS) != 0;
    }
  }
}
