/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.glowroot.agent.shaded.net.logstash.logback.pattern;

import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonFactory;

import org.glowroot.agent.shaded.ch.qos.logback.classic.PatternLayout;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.ch.qos.logback.core.pattern.PatternLayoutBase;
import org.glowroot.agent.shaded.ch.qos.logback.core.spi.ContextAware;

/**
 * @author <a href="mailto:dimas@dataart.com">Dmitry Andrianov</a>
 */
public class LoggingEventJsonPatternParser extends AbstractJsonPatternParser<ILoggingEvent> {

    public LoggingEventJsonPatternParser(final ContextAware contextAware, final JsonFactory jsonFactory) {
        super(contextAware, jsonFactory);
    }

    @Override
    protected PatternLayoutBase<ILoggingEvent> createLayout() {
        return new PatternLayout();
    }

}
