package org.glowroot.agent.model;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TimerNameImpl}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTimerNameImpl.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTimerNameImpl.of()}.
 */
@Generated(from = "TimerNameImpl", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTimerNameImpl extends TimerNameImpl {
  private final String name;
  private final boolean extended;
  private transient final @Nullable TimerNameImpl extendedTimer;
  private transient final int specialHashCode;

  private ImmutableTimerNameImpl(String name, boolean extended) {
    this.name = Preconditions.checkNotNull(name, "name");
    this.extended = extended;
    this.extendedTimer = initShim.extendedTimer();
    this.specialHashCode = initShim.specialHashCode();
    this.initShim = null;
  }

  private ImmutableTimerNameImpl(ImmutableTimerNameImpl original, String name, boolean extended) {
    this.name = name;
    this.extended = extended;
    this.extendedTimer = initShim.extendedTimer();
    this.specialHashCode = initShim.specialHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TimerNameImpl", generator = "Immutables")
  private final class InitShim {
    private byte extendedTimerBuildStage = STAGE_UNINITIALIZED;
    private TimerNameImpl extendedTimer;

    TimerNameImpl extendedTimer() {
      if (extendedTimerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extendedTimerBuildStage == STAGE_UNINITIALIZED) {
        extendedTimerBuildStage = STAGE_INITIALIZING;
        this.extendedTimer = ImmutableTimerNameImpl.super.extendedTimer();
        extendedTimerBuildStage = STAGE_INITIALIZED;
      }
      return this.extendedTimer;
    }

    private byte specialHashCodeBuildStage = STAGE_UNINITIALIZED;
    private int specialHashCode;

    int specialHashCode() {
      if (specialHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (specialHashCodeBuildStage == STAGE_UNINITIALIZED) {
        specialHashCodeBuildStage = STAGE_INITIALIZING;
        this.specialHashCode = ImmutableTimerNameImpl.super.specialHashCode();
        specialHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.specialHashCode;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<String>();
      if (extendedTimerBuildStage == STAGE_INITIALIZING) attributes.add("extendedTimer");
      if (specialHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("specialHashCode");
      return "Cannot build TimerNameImpl, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code extended} attribute
   */
  @JsonProperty("extended")
  @Override
  public boolean extended() {
    return extended;
  }

  /**
   * @return The computed-at-construction value of the {@code extendedTimer} attribute
   */
  @JsonProperty("extendedTimer")
  @Override
  public @Nullable TimerNameImpl extendedTimer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.extendedTimer()
        : this.extendedTimer;
  }

  /**
   * @return The computed-at-construction value of the {@code specialHashCode} attribute
   */
  @JsonProperty("specialHashCode")
  @Override
  public int specialHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.specialHashCode()
        : this.specialHashCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerNameImpl#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerNameImpl withName(String value) {
    String newValue = Preconditions.checkNotNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTimerNameImpl(this, newValue, this.extended);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TimerNameImpl#extended() extended} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for extended
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimerNameImpl withExtended(boolean value) {
    if (this.extended == value) return this;
    return new ImmutableTimerNameImpl(this, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTimerNameImpl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTimerNameImpl
        && equalTo((ImmutableTimerNameImpl) another);
  }

  private boolean equalTo(ImmutableTimerNameImpl another) {
    return name.equals(another.name)
        && extended == another.extended
        && Objects.equal(extendedTimer, another.extendedTimer)
        && specialHashCode == another.specialHashCode;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code extended}, {@code extendedTimer}, {@code specialHashCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Booleans.hashCode(extended);
    h += (h << 5) + Objects.hashCode(extendedTimer);
    h += (h << 5) + specialHashCode;
    return h;
  }

  /**
   * Prints the immutable value {@code TimerNameImpl} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TimerNameImpl")
        .omitNullValues()
        .add("name", name)
        .add("extended", extended)
        .add("extendedTimer", extendedTimer)
        .add("specialHashCode", specialHashCode)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TimerNameImpl", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TimerNameImpl {
    @org.glowroot.agent.shaded.javax.annotation.Nullable String name;
    boolean extended;
    boolean extendedIsSet;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("extended")
    public void setExtended(boolean extended) {
      this.extended = extended;
      this.extendedIsSet = true;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public boolean extended() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public TimerNameImpl extendedTimer() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public int specialHashCode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTimerNameImpl fromJson(Json json) {
    ImmutableTimerNameImpl.Builder builder = ImmutableTimerNameImpl.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.extendedIsSet) {
      builder.extended(json.extended);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code TimerNameImpl} instance.
   * @param name The value for the {@code name} attribute
   * @param extended The value for the {@code extended} attribute
   * @return An immutable TimerNameImpl instance
   */
  public static ImmutableTimerNameImpl of(String name, boolean extended) {
    return new ImmutableTimerNameImpl(name, extended);
  }

  /**
   * Creates an immutable copy of a {@link TimerNameImpl} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TimerNameImpl instance
   */
  public static ImmutableTimerNameImpl copyOf(TimerNameImpl instance) {
    if (instance instanceof ImmutableTimerNameImpl) {
      return (ImmutableTimerNameImpl) instance;
    }
    return ImmutableTimerNameImpl.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTimerNameImpl ImmutableTimerNameImpl}.
   * <pre>
   * ImmutableTimerNameImpl.builder()
   *    .name(String) // required {@link TimerNameImpl#name() name}
   *    .extended(boolean) // required {@link TimerNameImpl#extended() extended}
   *    .build();
   * </pre>
   * @return A new ImmutableTimerNameImpl builder
   */
  public static ImmutableTimerNameImpl.Builder builder() {
    return new ImmutableTimerNameImpl.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTimerNameImpl ImmutableTimerNameImpl}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TimerNameImpl", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_EXTENDED = 0x2L;
    private long initBits = 0x3L;

    private @org.glowroot.agent.shaded.javax.annotation.Nullable String name;
    private boolean extended;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TimerNameImpl} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TimerNameImpl instance) {
      Preconditions.checkNotNull(instance, "instance");
      name(instance.name());
      extended(instance.extended());
      return this;
    }

    /**
     * Initializes the value for the {@link TimerNameImpl#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TimerNameImpl#extended() extended} attribute.
     * @param extended The value for extended 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder extended(boolean extended) {
      this.extended = extended;
      initBits &= ~INIT_BIT_EXTENDED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTimerNameImpl ImmutableTimerNameImpl}.
     * @return An immutable instance of TimerNameImpl
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTimerNameImpl build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTimerNameImpl(null, name, extended);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_EXTENDED) != 0) attributes.add("extended");
      return "Cannot build TimerNameImpl, some of required attributes are not set " + attributes;
    }
  }
}
