package org.glowroot.agent.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveWeavingServiceImpl.PointcutClassName}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePointcutClassName.builder()}.
 */
@Generated(from = "LiveWeavingServiceImpl.PointcutClassName", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePointcutClassName
    extends LiveWeavingServiceImpl.PointcutClassName {
  private final @Nullable Pattern pattern;
  private final @Nullable String nonPattern;
  private final @Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction;
  private final boolean doNotMatchSubClasses;

  private ImmutablePointcutClassName(
      @Nullable Pattern pattern,
      @Nullable String nonPattern,
      @Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction,
      boolean doNotMatchSubClasses) {
    this.pattern = pattern;
    this.nonPattern = nonPattern;
    this.subTypeRestriction = subTypeRestriction;
    this.doNotMatchSubClasses = doNotMatchSubClasses;
  }

  /**
   * @return The value of the {@code pattern} attribute
   */
  @JsonProperty("pattern")
  @Override
  @Nullable Pattern pattern() {
    return pattern;
  }

  /**
   * @return The value of the {@code nonPattern} attribute
   */
  @JsonProperty("nonPattern")
  @Override
  @Nullable String nonPattern() {
    return nonPattern;
  }

  /**
   * @return The value of the {@code subTypeRestriction} attribute
   */
  @JsonProperty("subTypeRestriction")
  @Override
  @Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction() {
    return subTypeRestriction;
  }

  /**
   * @return The value of the {@code doNotMatchSubClasses} attribute
   */
  @JsonProperty("doNotMatchSubClasses")
  @Override
  boolean doNotMatchSubClasses() {
    return doNotMatchSubClasses;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveWeavingServiceImpl.PointcutClassName#pattern() pattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClassName withPattern(@Nullable Pattern value) {
    if (this.pattern == value) return this;
    return new ImmutablePointcutClassName(value, this.nonPattern, this.subTypeRestriction, this.doNotMatchSubClasses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveWeavingServiceImpl.PointcutClassName#nonPattern() nonPattern} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nonPattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClassName withNonPattern(@Nullable String value) {
    if (Objects.equal(this.nonPattern, value)) return this;
    return new ImmutablePointcutClassName(this.pattern, value, this.subTypeRestriction, this.doNotMatchSubClasses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveWeavingServiceImpl.PointcutClassName#subTypeRestriction() subTypeRestriction} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subTypeRestriction (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClassName withSubTypeRestriction(@Nullable LiveWeavingServiceImpl.PointcutClassName value) {
    if (this.subTypeRestriction == value) return this;
    return new ImmutablePointcutClassName(this.pattern, this.nonPattern, value, this.doNotMatchSubClasses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveWeavingServiceImpl.PointcutClassName#doNotMatchSubClasses() doNotMatchSubClasses} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for doNotMatchSubClasses
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClassName withDoNotMatchSubClasses(boolean value) {
    if (this.doNotMatchSubClasses == value) return this;
    return new ImmutablePointcutClassName(this.pattern, this.nonPattern, this.subTypeRestriction, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePointcutClassName} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePointcutClassName
        && equalTo((ImmutablePointcutClassName) another);
  }

  private boolean equalTo(ImmutablePointcutClassName another) {
    return Objects.equal(pattern, another.pattern)
        && Objects.equal(nonPattern, another.nonPattern)
        && Objects.equal(subTypeRestriction, another.subTypeRestriction)
        && doNotMatchSubClasses == another.doNotMatchSubClasses;
  }

  /**
   * Computes a hash code from attributes: {@code pattern}, {@code nonPattern}, {@code subTypeRestriction}, {@code doNotMatchSubClasses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(pattern);
    h += (h << 5) + Objects.hashCode(nonPattern);
    h += (h << 5) + Objects.hashCode(subTypeRestriction);
    h += (h << 5) + Booleans.hashCode(doNotMatchSubClasses);
    return h;
  }

  /**
   * Prints the immutable value {@code PointcutClassName} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PointcutClassName")
        .omitNullValues()
        .add("pattern", pattern)
        .add("nonPattern", nonPattern)
        .add("subTypeRestriction", subTypeRestriction)
        .add("doNotMatchSubClasses", doNotMatchSubClasses)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveWeavingServiceImpl.PointcutClassName", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends LiveWeavingServiceImpl.PointcutClassName {
    @org.glowroot.agent.shaded.javax.annotation.Nullable Pattern pattern;
    @org.glowroot.agent.shaded.javax.annotation.Nullable String nonPattern;
    @org.glowroot.agent.shaded.javax.annotation.Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction;
    boolean doNotMatchSubClasses;
    boolean doNotMatchSubClassesIsSet;
    @JsonProperty("pattern")
    public void setPattern(@Nullable Pattern pattern) {
      this.pattern = pattern;
    }
    @JsonProperty("nonPattern")
    public void setNonPattern(@Nullable String nonPattern) {
      this.nonPattern = nonPattern;
    }
    @JsonProperty("subTypeRestriction")
    public void setSubTypeRestriction(@Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction) {
      this.subTypeRestriction = subTypeRestriction;
    }
    @JsonProperty("doNotMatchSubClasses")
    public void setDoNotMatchSubClasses(boolean doNotMatchSubClasses) {
      this.doNotMatchSubClasses = doNotMatchSubClasses;
      this.doNotMatchSubClassesIsSet = true;
    }
    @Override
    Pattern pattern() { throw new UnsupportedOperationException(); }
    @Override
    String nonPattern() { throw new UnsupportedOperationException(); }
    @Override
    LiveWeavingServiceImpl.PointcutClassName subTypeRestriction() { throw new UnsupportedOperationException(); }
    @Override
    boolean doNotMatchSubClasses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePointcutClassName fromJson(Json json) {
    ImmutablePointcutClassName.Builder builder = ImmutablePointcutClassName.builder();
    if (json.pattern != null) {
      builder.pattern(json.pattern);
    }
    if (json.nonPattern != null) {
      builder.nonPattern(json.nonPattern);
    }
    if (json.subTypeRestriction != null) {
      builder.subTypeRestriction(json.subTypeRestriction);
    }
    if (json.doNotMatchSubClassesIsSet) {
      builder.doNotMatchSubClasses(json.doNotMatchSubClasses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveWeavingServiceImpl.PointcutClassName} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PointcutClassName instance
   */
  public static ImmutablePointcutClassName copyOf(LiveWeavingServiceImpl.PointcutClassName instance) {
    if (instance instanceof ImmutablePointcutClassName) {
      return (ImmutablePointcutClassName) instance;
    }
    return ImmutablePointcutClassName.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePointcutClassName ImmutablePointcutClassName}.
   * <pre>
   * ImmutablePointcutClassName.builder()
   *    .pattern(regex.Pattern | null) // nullable {@link LiveWeavingServiceImpl.PointcutClassName#pattern() pattern}
   *    .nonPattern(String | null) // nullable {@link LiveWeavingServiceImpl.PointcutClassName#nonPattern() nonPattern}
   *    .subTypeRestriction(org.glowroot.agent.live.LiveWeavingServiceImpl.PointcutClassName | null) // nullable {@link LiveWeavingServiceImpl.PointcutClassName#subTypeRestriction() subTypeRestriction}
   *    .doNotMatchSubClasses(boolean) // required {@link LiveWeavingServiceImpl.PointcutClassName#doNotMatchSubClasses() doNotMatchSubClasses}
   *    .build();
   * </pre>
   * @return A new ImmutablePointcutClassName builder
   */
  public static ImmutablePointcutClassName.Builder builder() {
    return new ImmutablePointcutClassName.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePointcutClassName ImmutablePointcutClassName}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveWeavingServiceImpl.PointcutClassName", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DO_NOT_MATCH_SUB_CLASSES = 0x1L;
    private long initBits = 0x1L;

    private @org.glowroot.agent.shaded.javax.annotation.Nullable Pattern pattern;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable String nonPattern;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction;
    private boolean doNotMatchSubClasses;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PointcutClassName} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(LiveWeavingServiceImpl.PointcutClassName instance) {
      Preconditions.checkNotNull(instance, "instance");
      @Nullable Pattern patternValue = instance.pattern();
      if (patternValue != null) {
        pattern(patternValue);
      }
      @Nullable String nonPatternValue = instance.nonPattern();
      if (nonPatternValue != null) {
        nonPattern(nonPatternValue);
      }
      @Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestrictionValue = instance.subTypeRestriction();
      if (subTypeRestrictionValue != null) {
        subTypeRestriction(subTypeRestrictionValue);
      }
      doNotMatchSubClasses(instance.doNotMatchSubClasses());
      return this;
    }

    /**
     * Initializes the value for the {@link LiveWeavingServiceImpl.PointcutClassName#pattern() pattern} attribute.
     * @param pattern The value for pattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pattern(@Nullable Pattern pattern) {
      this.pattern = pattern;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveWeavingServiceImpl.PointcutClassName#nonPattern() nonPattern} attribute.
     * @param nonPattern The value for nonPattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonPattern(@Nullable String nonPattern) {
      this.nonPattern = nonPattern;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveWeavingServiceImpl.PointcutClassName#subTypeRestriction() subTypeRestriction} attribute.
     * @param subTypeRestriction The value for subTypeRestriction (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subTypeRestriction(@Nullable LiveWeavingServiceImpl.PointcutClassName subTypeRestriction) {
      this.subTypeRestriction = subTypeRestriction;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveWeavingServiceImpl.PointcutClassName#doNotMatchSubClasses() doNotMatchSubClasses} attribute.
     * @param doNotMatchSubClasses The value for doNotMatchSubClasses 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder doNotMatchSubClasses(boolean doNotMatchSubClasses) {
      this.doNotMatchSubClasses = doNotMatchSubClasses;
      initBits &= ~INIT_BIT_DO_NOT_MATCH_SUB_CLASSES;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePointcutClassName ImmutablePointcutClassName}.
     * @return An immutable instance of PointcutClassName
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePointcutClassName build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePointcutClassName(pattern, nonPattern, subTypeRestriction, doNotMatchSubClasses);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DO_NOT_MATCH_SUB_CLASSES) != 0) attributes.add("doNotMatchSubClasses");
      return "Cannot build PointcutClassName, some of required attributes are not set " + attributes;
    }
  }
}
