package org.glowroot.agent.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AllConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllConfig.builder()}.
 */
@Generated(from = "AllConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAllConfig extends AllConfig {
  private final TransactionConfig transaction;
  private final JvmConfig jvm;
  private final UiDefaultsConfig uiDefaults;
  private final AdvancedConfig advanced;
  private final ImmutableList<GaugeConfig> gauges;
  private final ImmutableList<SyntheticMonitorConfig> syntheticMonitors;
  private final ImmutableList<AlertConfig> alerts;
  private final ImmutableList<PluginConfig> plugins;
  private final ImmutableList<InstrumentationConfig> instrumentation;

  private ImmutableAllConfig(
      TransactionConfig transaction,
      JvmConfig jvm,
      UiDefaultsConfig uiDefaults,
      AdvancedConfig advanced,
      ImmutableList<GaugeConfig> gauges,
      ImmutableList<SyntheticMonitorConfig> syntheticMonitors,
      ImmutableList<AlertConfig> alerts,
      ImmutableList<PluginConfig> plugins,
      ImmutableList<InstrumentationConfig> instrumentation) {
    this.transaction = transaction;
    this.jvm = jvm;
    this.uiDefaults = uiDefaults;
    this.advanced = advanced;
    this.gauges = gauges;
    this.syntheticMonitors = syntheticMonitors;
    this.alerts = alerts;
    this.plugins = plugins;
    this.instrumentation = instrumentation;
  }

  /**
   * @return The value of the {@code transaction} attribute
   */
  @JsonProperty("transaction")
  @Override
  TransactionConfig transaction() {
    return transaction;
  }

  /**
   * @return The value of the {@code jvm} attribute
   */
  @JsonProperty("jvm")
  @Override
  JvmConfig jvm() {
    return jvm;
  }

  /**
   * @return The value of the {@code uiDefaults} attribute
   */
  @JsonProperty("uiDefaults")
  @Override
  UiDefaultsConfig uiDefaults() {
    return uiDefaults;
  }

  /**
   * @return The value of the {@code advanced} attribute
   */
  @JsonProperty("advanced")
  @Override
  AdvancedConfig advanced() {
    return advanced;
  }

  /**
   * @return The value of the {@code gauges} attribute
   */
  @JsonProperty("gauges")
  @Override
  ImmutableList<GaugeConfig> gauges() {
    return gauges;
  }

  /**
   * @return The value of the {@code syntheticMonitors} attribute
   */
  @JsonProperty("syntheticMonitors")
  @Override
  ImmutableList<SyntheticMonitorConfig> syntheticMonitors() {
    return syntheticMonitors;
  }

  /**
   * @return The value of the {@code alerts} attribute
   */
  @JsonProperty("alerts")
  @Override
  ImmutableList<AlertConfig> alerts() {
    return alerts;
  }

  /**
   * @return The value of the {@code plugins} attribute
   */
  @JsonProperty("plugins")
  @Override
  ImmutableList<PluginConfig> plugins() {
    return plugins;
  }

  /**
   * @return The value of the {@code instrumentation} attribute
   */
  @JsonProperty("instrumentation")
  @Override
  ImmutableList<InstrumentationConfig> instrumentation() {
    return instrumentation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllConfig#transaction() transaction} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transaction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllConfig withTransaction(TransactionConfig value) {
    if (this.transaction == value) return this;
    TransactionConfig newValue = Preconditions.checkNotNull(value, "transaction");
    return new ImmutableAllConfig(
        newValue,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllConfig#jvm() jvm} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jvm
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllConfig withJvm(JvmConfig value) {
    if (this.jvm == value) return this;
    JvmConfig newValue = Preconditions.checkNotNull(value, "jvm");
    return new ImmutableAllConfig(
        this.transaction,
        newValue,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllConfig#uiDefaults() uiDefaults} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uiDefaults
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllConfig withUiDefaults(UiDefaultsConfig value) {
    if (this.uiDefaults == value) return this;
    UiDefaultsConfig newValue = Preconditions.checkNotNull(value, "uiDefaults");
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        newValue,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllConfig#advanced() advanced} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advanced
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllConfig withAdvanced(AdvancedConfig value) {
    if (this.advanced == value) return this;
    AdvancedConfig newValue = Preconditions.checkNotNull(value, "advanced");
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        newValue,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#gauges() gauges}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withGauges(GaugeConfig... elements) {
    ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        newValue,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#gauges() gauges}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of gauges elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withGauges(Iterable<? extends GaugeConfig> elements) {
    if (this.gauges == elements) return this;
    ImmutableList<GaugeConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        newValue,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#syntheticMonitors() syntheticMonitors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withSyntheticMonitors(SyntheticMonitorConfig... elements) {
    ImmutableList<SyntheticMonitorConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        newValue,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#syntheticMonitors() syntheticMonitors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of syntheticMonitors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withSyntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
    if (this.syntheticMonitors == elements) return this;
    ImmutableList<SyntheticMonitorConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        newValue,
        this.alerts,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#alerts() alerts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withAlerts(AlertConfig... elements) {
    ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        newValue,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#alerts() alerts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of alerts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withAlerts(Iterable<? extends AlertConfig> elements) {
    if (this.alerts == elements) return this;
    ImmutableList<AlertConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        newValue,
        this.plugins,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#plugins() plugins}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withPlugins(PluginConfig... elements) {
    ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        newValue,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#plugins() plugins}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of plugins elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withPlugins(Iterable<? extends PluginConfig> elements) {
    if (this.plugins == elements) return this;
    ImmutableList<PluginConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        newValue,
        this.instrumentation);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#instrumentation() instrumentation}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withInstrumentation(InstrumentationConfig... elements) {
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllConfig#instrumentation() instrumentation}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of instrumentation elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllConfig withInstrumentation(Iterable<? extends InstrumentationConfig> elements) {
    if (this.instrumentation == elements) return this;
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAllConfig(
        this.transaction,
        this.jvm,
        this.uiDefaults,
        this.advanced,
        this.gauges,
        this.syntheticMonitors,
        this.alerts,
        this.plugins,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllConfig
        && equalTo((ImmutableAllConfig) another);
  }

  private boolean equalTo(ImmutableAllConfig another) {
    return transaction.equals(another.transaction)
        && jvm.equals(another.jvm)
        && uiDefaults.equals(another.uiDefaults)
        && advanced.equals(another.advanced)
        && gauges.equals(another.gauges)
        && syntheticMonitors.equals(another.syntheticMonitors)
        && alerts.equals(another.alerts)
        && plugins.equals(another.plugins)
        && instrumentation.equals(another.instrumentation);
  }

  /**
   * Computes a hash code from attributes: {@code transaction}, {@code jvm}, {@code uiDefaults}, {@code advanced}, {@code gauges}, {@code syntheticMonitors}, {@code alerts}, {@code plugins}, {@code instrumentation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + transaction.hashCode();
    h += (h << 5) + jvm.hashCode();
    h += (h << 5) + uiDefaults.hashCode();
    h += (h << 5) + advanced.hashCode();
    h += (h << 5) + gauges.hashCode();
    h += (h << 5) + syntheticMonitors.hashCode();
    h += (h << 5) + alerts.hashCode();
    h += (h << 5) + plugins.hashCode();
    h += (h << 5) + instrumentation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AllConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AllConfig")
        .omitNullValues()
        .add("transaction", transaction)
        .add("jvm", jvm)
        .add("uiDefaults", uiDefaults)
        .add("advanced", advanced)
        .add("gauges", gauges)
        .add("syntheticMonitors", syntheticMonitors)
        .add("alerts", alerts)
        .add("plugins", plugins)
        .add("instrumentation", instrumentation)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AllConfig", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AllConfig {
    @Nullable TransactionConfig transaction;
    @Nullable JvmConfig jvm;
    @Nullable UiDefaultsConfig uiDefaults;
    @Nullable AdvancedConfig advanced;
    @Nullable List<GaugeConfig> gauges = ImmutableList.of();
    @Nullable List<SyntheticMonitorConfig> syntheticMonitors = ImmutableList.of();
    @Nullable List<AlertConfig> alerts = ImmutableList.of();
    @Nullable List<PluginConfig> plugins = ImmutableList.of();
    @Nullable List<InstrumentationConfig> instrumentation = ImmutableList.of();
    @JsonProperty("transaction")
    public void setTransaction(TransactionConfig transaction) {
      this.transaction = transaction;
    }
    @JsonProperty("jvm")
    public void setJvm(JvmConfig jvm) {
      this.jvm = jvm;
    }
    @JsonProperty("uiDefaults")
    public void setUiDefaults(UiDefaultsConfig uiDefaults) {
      this.uiDefaults = uiDefaults;
    }
    @JsonProperty("advanced")
    public void setAdvanced(AdvancedConfig advanced) {
      this.advanced = advanced;
    }
    @JsonProperty("gauges")
    public void setGauges(List<GaugeConfig> gauges) {
      this.gauges = gauges;
    }
    @JsonProperty("syntheticMonitors")
    public void setSyntheticMonitors(List<SyntheticMonitorConfig> syntheticMonitors) {
      this.syntheticMonitors = syntheticMonitors;
    }
    @JsonProperty("alerts")
    public void setAlerts(List<AlertConfig> alerts) {
      this.alerts = alerts;
    }
    @JsonProperty("plugins")
    public void setPlugins(List<PluginConfig> plugins) {
      this.plugins = plugins;
    }
    @JsonProperty("instrumentation")
    public void setInstrumentation(List<InstrumentationConfig> instrumentation) {
      this.instrumentation = instrumentation;
    }
    @Override
    TransactionConfig transaction() { throw new UnsupportedOperationException(); }
    @Override
    JvmConfig jvm() { throw new UnsupportedOperationException(); }
    @Override
    UiDefaultsConfig uiDefaults() { throw new UnsupportedOperationException(); }
    @Override
    AdvancedConfig advanced() { throw new UnsupportedOperationException(); }
    @Override
    List<GaugeConfig> gauges() { throw new UnsupportedOperationException(); }
    @Override
    List<SyntheticMonitorConfig> syntheticMonitors() { throw new UnsupportedOperationException(); }
    @Override
    List<AlertConfig> alerts() { throw new UnsupportedOperationException(); }
    @Override
    List<PluginConfig> plugins() { throw new UnsupportedOperationException(); }
    @Override
    List<InstrumentationConfig> instrumentation() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAllConfig fromJson(Json json) {
    ImmutableAllConfig.Builder builder = ImmutableAllConfig.builder();
    if (json.transaction != null) {
      builder.transaction(json.transaction);
    }
    if (json.jvm != null) {
      builder.jvm(json.jvm);
    }
    if (json.uiDefaults != null) {
      builder.uiDefaults(json.uiDefaults);
    }
    if (json.advanced != null) {
      builder.advanced(json.advanced);
    }
    if (json.gauges != null) {
      builder.addAllGauges(json.gauges);
    }
    if (json.syntheticMonitors != null) {
      builder.addAllSyntheticMonitors(json.syntheticMonitors);
    }
    if (json.alerts != null) {
      builder.addAllAlerts(json.alerts);
    }
    if (json.plugins != null) {
      builder.addAllPlugins(json.plugins);
    }
    if (json.instrumentation != null) {
      builder.addAllInstrumentation(json.instrumentation);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AllConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllConfig instance
   */
  public static ImmutableAllConfig copyOf(AllConfig instance) {
    if (instance instanceof ImmutableAllConfig) {
      return (ImmutableAllConfig) instance;
    }
    return ImmutableAllConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllConfig ImmutableAllConfig}.
   * <pre>
   * ImmutableAllConfig.builder()
   *    .transaction(org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig) // required {@link AllConfig#transaction() transaction}
   *    .jvm(org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig) // required {@link AllConfig#jvm() jvm}
   *    .uiDefaults(org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig) // required {@link AllConfig#uiDefaults() uiDefaults}
   *    .advanced(org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig) // required {@link AllConfig#advanced() advanced}
   *    .addGauges|addAllGauges(org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig) // {@link AllConfig#gauges() gauges} elements
   *    .addSyntheticMonitors|addAllSyntheticMonitors(org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig) // {@link AllConfig#syntheticMonitors() syntheticMonitors} elements
   *    .addAlerts|addAllAlerts(org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig) // {@link AllConfig#alerts() alerts} elements
   *    .addPlugins|addAllPlugins(org.glowroot.agent.config.PluginConfig) // {@link AllConfig#plugins() plugins} elements
   *    .addInstrumentation|addAllInstrumentation(org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig) // {@link AllConfig#instrumentation() instrumentation} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAllConfig builder
   */
  public static ImmutableAllConfig.Builder builder() {
    return new ImmutableAllConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllConfig ImmutableAllConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION = 0x1L;
    private static final long INIT_BIT_JVM = 0x2L;
    private static final long INIT_BIT_UI_DEFAULTS = 0x4L;
    private static final long INIT_BIT_ADVANCED = 0x8L;
    private long initBits = 0xfL;

    private @Nullable TransactionConfig transaction;
    private @Nullable JvmConfig jvm;
    private @Nullable UiDefaultsConfig uiDefaults;
    private @Nullable AdvancedConfig advanced;
    private ImmutableList.Builder<GaugeConfig> gauges = ImmutableList.builder();
    private ImmutableList.Builder<SyntheticMonitorConfig> syntheticMonitors = ImmutableList.builder();
    private ImmutableList.Builder<AlertConfig> alerts = ImmutableList.builder();
    private ImmutableList.Builder<PluginConfig> plugins = ImmutableList.builder();
    private ImmutableList.Builder<InstrumentationConfig> instrumentation = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AllConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AllConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      transaction(instance.transaction());
      jvm(instance.jvm());
      uiDefaults(instance.uiDefaults());
      advanced(instance.advanced());
      addAllGauges(instance.gauges());
      addAllSyntheticMonitors(instance.syntheticMonitors());
      addAllAlerts(instance.alerts());
      addAllPlugins(instance.plugins());
      addAllInstrumentation(instance.instrumentation());
      return this;
    }

    /**
     * Initializes the value for the {@link AllConfig#transaction() transaction} attribute.
     * @param transaction The value for transaction 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transaction(TransactionConfig transaction) {
      this.transaction = Preconditions.checkNotNull(transaction, "transaction");
      initBits &= ~INIT_BIT_TRANSACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link AllConfig#jvm() jvm} attribute.
     * @param jvm The value for jvm 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jvm(JvmConfig jvm) {
      this.jvm = Preconditions.checkNotNull(jvm, "jvm");
      initBits &= ~INIT_BIT_JVM;
      return this;
    }

    /**
     * Initializes the value for the {@link AllConfig#uiDefaults() uiDefaults} attribute.
     * @param uiDefaults The value for uiDefaults 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uiDefaults(UiDefaultsConfig uiDefaults) {
      this.uiDefaults = Preconditions.checkNotNull(uiDefaults, "uiDefaults");
      initBits &= ~INIT_BIT_UI_DEFAULTS;
      return this;
    }

    /**
     * Initializes the value for the {@link AllConfig#advanced() advanced} attribute.
     * @param advanced The value for advanced 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder advanced(AdvancedConfig advanced) {
      this.advanced = Preconditions.checkNotNull(advanced, "advanced");
      initBits &= ~INIT_BIT_ADVANCED;
      return this;
    }

    /**
     * Adds one element to {@link AllConfig#gauges() gauges} list.
     * @param element A gauges element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGauges(GaugeConfig element) {
      this.gauges.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllConfig#gauges() gauges} list.
     * @param elements An array of gauges elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGauges(GaugeConfig... elements) {
      this.gauges.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllConfig#gauges() gauges} list.
     * @param elements An iterable of gauges elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gauges(Iterable<? extends GaugeConfig> elements) {
      this.gauges = ImmutableList.builder();
      return addAllGauges(elements);
    }

    /**
     * Adds elements to {@link AllConfig#gauges() gauges} list.
     * @param elements An iterable of gauges elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGauges(Iterable<? extends GaugeConfig> elements) {
      this.gauges.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AllConfig#syntheticMonitors() syntheticMonitors} list.
     * @param element A syntheticMonitors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSyntheticMonitors(SyntheticMonitorConfig element) {
      this.syntheticMonitors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllConfig#syntheticMonitors() syntheticMonitors} list.
     * @param elements An array of syntheticMonitors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSyntheticMonitors(SyntheticMonitorConfig... elements) {
      this.syntheticMonitors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllConfig#syntheticMonitors() syntheticMonitors} list.
     * @param elements An iterable of syntheticMonitors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder syntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
      this.syntheticMonitors = ImmutableList.builder();
      return addAllSyntheticMonitors(elements);
    }

    /**
     * Adds elements to {@link AllConfig#syntheticMonitors() syntheticMonitors} list.
     * @param elements An iterable of syntheticMonitors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSyntheticMonitors(Iterable<? extends SyntheticMonitorConfig> elements) {
      this.syntheticMonitors.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AllConfig#alerts() alerts} list.
     * @param element A alerts element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAlerts(AlertConfig element) {
      this.alerts.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllConfig#alerts() alerts} list.
     * @param elements An array of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAlerts(AlertConfig... elements) {
      this.alerts.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllConfig#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder alerts(Iterable<? extends AlertConfig> elements) {
      this.alerts = ImmutableList.builder();
      return addAllAlerts(elements);
    }

    /**
     * Adds elements to {@link AllConfig#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAlerts(Iterable<? extends AlertConfig> elements) {
      this.alerts.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AllConfig#plugins() plugins} list.
     * @param element A plugins element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPlugins(PluginConfig element) {
      this.plugins.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllConfig#plugins() plugins} list.
     * @param elements An array of plugins elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPlugins(PluginConfig... elements) {
      this.plugins.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllConfig#plugins() plugins} list.
     * @param elements An iterable of plugins elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder plugins(Iterable<? extends PluginConfig> elements) {
      this.plugins = ImmutableList.builder();
      return addAllPlugins(elements);
    }

    /**
     * Adds elements to {@link AllConfig#plugins() plugins} list.
     * @param elements An iterable of plugins elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPlugins(Iterable<? extends PluginConfig> elements) {
      this.plugins.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link AllConfig#instrumentation() instrumentation} list.
     * @param element A instrumentation element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstrumentation(InstrumentationConfig element) {
      this.instrumentation.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllConfig#instrumentation() instrumentation} list.
     * @param elements An array of instrumentation elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstrumentation(InstrumentationConfig... elements) {
      this.instrumentation.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllConfig#instrumentation() instrumentation} list.
     * @param elements An iterable of instrumentation elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder instrumentation(Iterable<? extends InstrumentationConfig> elements) {
      this.instrumentation = ImmutableList.builder();
      return addAllInstrumentation(elements);
    }

    /**
     * Adds elements to {@link AllConfig#instrumentation() instrumentation} list.
     * @param elements An iterable of instrumentation elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInstrumentation(Iterable<? extends InstrumentationConfig> elements) {
      this.instrumentation.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllConfig ImmutableAllConfig}.
     * @return An immutable instance of AllConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAllConfig(
          transaction,
          jvm,
          uiDefaults,
          advanced,
          gauges.build(),
          syntheticMonitors.build(),
          alerts.build(),
          plugins.build(),
          instrumentation.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TRANSACTION) != 0) attributes.add("transaction");
      if ((initBits & INIT_BIT_JVM) != 0) attributes.add("jvm");
      if ((initBits & INIT_BIT_UI_DEFAULTS) != 0) attributes.add("uiDefaults");
      if ((initBits & INIT_BIT_ADVANCED) != 0) attributes.add("advanced");
      return "Cannot build AllConfig, some of required attributes are not set " + attributes;
    }
  }
}
