package org.glowroot.agent.central;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CentralConnection.CollectorTarget}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCollectorTarget.builder()}.
 */
@Generated(from = "CentralConnection.CollectorTarget", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCollectorTarget
    implements CentralConnection.CollectorTarget {
  private final String host;
  private final int port;

  private ImmutableCollectorTarget(String host, int port) {
    this.host = host;
    this.port = port;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public String host() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public int port() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CentralConnection.CollectorTarget#host() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectorTarget withHost(String value) {
    String newValue = Preconditions.checkNotNull(value, "host");
    if (this.host.equals(newValue)) return this;
    return new ImmutableCollectorTarget(newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CentralConnection.CollectorTarget#port() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectorTarget withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableCollectorTarget(this.host, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollectorTarget} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollectorTarget
        && equalTo((ImmutableCollectorTarget) another);
  }

  private boolean equalTo(ImmutableCollectorTarget another) {
    return host.equals(another.host)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Prints the immutable value {@code CollectorTarget} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CollectorTarget")
        .omitNullValues()
        .add("host", host)
        .add("port", port)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CentralConnection.CollectorTarget", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CentralConnection.CollectorTarget {
    @Nullable String host;
    int port;
    boolean portIsSet;
    @JsonProperty("host")
    public void setHost(String host) {
      this.host = host;
    }
    @JsonProperty("port")
    public void setPort(int port) {
      this.port = port;
      this.portIsSet = true;
    }
    @Override
    public String host() { throw new UnsupportedOperationException(); }
    @Override
    public int port() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCollectorTarget fromJson(Json json) {
    ImmutableCollectorTarget.Builder builder = ImmutableCollectorTarget.builder();
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.portIsSet) {
      builder.port(json.port);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CentralConnection.CollectorTarget} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CollectorTarget instance
   */
  public static ImmutableCollectorTarget copyOf(CentralConnection.CollectorTarget instance) {
    if (instance instanceof ImmutableCollectorTarget) {
      return (ImmutableCollectorTarget) instance;
    }
    return ImmutableCollectorTarget.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCollectorTarget ImmutableCollectorTarget}.
   * <pre>
   * ImmutableCollectorTarget.builder()
   *    .host(String) // required {@link CentralConnection.CollectorTarget#host() host}
   *    .port(int) // required {@link CentralConnection.CollectorTarget#port() port}
   *    .build();
   * </pre>
   * @return A new ImmutableCollectorTarget builder
   */
  public static ImmutableCollectorTarget.Builder builder() {
    return new ImmutableCollectorTarget.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCollectorTarget ImmutableCollectorTarget}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CentralConnection.CollectorTarget", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private static final long INIT_BIT_PORT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String host;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CollectorTarget} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(CentralConnection.CollectorTarget instance) {
      Preconditions.checkNotNull(instance, "instance");
      host(instance.host());
      port(instance.port());
      return this;
    }

    /**
     * Initializes the value for the {@link CentralConnection.CollectorTarget#host() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder host(String host) {
      this.host = Preconditions.checkNotNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link CentralConnection.CollectorTarget#port() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollectorTarget ImmutableCollectorTarget}.
     * @return An immutable instance of CollectorTarget
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollectorTarget build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCollectorTarget(host, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build CollectorTarget, some of required attributes are not set " + attributes;
    }
  }
}
