/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api.util;

import org.glowroot.agent.plugin.api.checker.Nullable;

public class Optional<T> {
    private static final Optional<?> ABSENT = new Optional<Object>(null);
    @Nullable
    private final T value;

    public static <T> Optional<T> fromNullable(@Nullable T value) {
        if (value == null) {
            Optional<?> t = ABSENT;
            return t;
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> of(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new Optional<T>(value);
    }

    private Optional(@Nullable T value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return this.value;
    }

    @Nullable
    public T orNull() {
        return this.value;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 2040732332;
        }
        return 1502476572 + this.value.hashCode();
    }
}

