/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.ext.client.java8;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.Beta;
import org.glassfish.tyrus.core.MessageHandlerManager;

@Beta
public class SessionBuilder {
    private static final BiConsumer NO_OP_BI_CONSUMER = (o, o2) -> {};
    private final WebSocketContainer container;
    private final List<Map.Entry<Class<?>, MessageHandler.Whole<?>>> wholeMessageHandlers = new ArrayList();
    private final List<Map.Entry<Class<?>, MessageHandler.Partial<?>>> partialMessageHandlers = new ArrayList();
    private URI uri;
    private ClientEndpointConfig clientEndpointConfig;
    private BiConsumer<Session, EndpointConfig> onOpen;
    private BiConsumer<Session, Throwable> onError;
    private BiConsumer<Session, CloseReason> onClose;

    public SessionBuilder(WebSocketContainer container) {
        this.container = container;
    }

    public SessionBuilder(String containerProviderClassName) {
        this((WebSocketContainer)ClientManager.createClient((String)containerProviderClassName));
    }

    public SessionBuilder() {
        this((WebSocketContainer)ClientManager.createClient());
    }

    public SessionBuilder clientEndpointConfig(ClientEndpointConfig clientEndpointConfig) {
        this.clientEndpointConfig = clientEndpointConfig;
        return this;
    }

    public SessionBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public <T> SessionBuilder messageHandler(Class<T> clazz, MessageHandler.Whole<T> messageHandler) {
        this.wholeMessageHandlers.add(new AbstractMap.SimpleEntry<Class<T>, MessageHandler.Whole<T>>(clazz, messageHandler));
        return this;
    }

    public <T> SessionBuilder messageHandlerPartial(Class<T> clazz, MessageHandler.Partial<T> messageHandler) {
        this.partialMessageHandlers.add(new AbstractMap.SimpleEntry<Class<T>, MessageHandler.Partial<T>>(clazz, messageHandler));
        return this;
    }

    public SessionBuilder onOpen(BiConsumer<Session, EndpointConfig> onOpen) {
        this.onOpen = onOpen;
        return this;
    }

    public SessionBuilder onError(BiConsumer<Session, Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public SessionBuilder onClose(BiConsumer<Session, CloseReason> onClose) {
        this.onClose = onClose;
        return this;
    }

    public Session connect() throws IOException, DeploymentException {
        if (this.clientEndpointConfig == null) {
            this.clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        }
        this.onOpen = this.onOpen != null ? this.onOpen : NO_OP_BI_CONSUMER;
        this.onClose = this.onClose != null ? this.onClose : NO_OP_BI_CONSUMER;
        this.onError = this.onError != null ? this.onError : NO_OP_BI_CONSUMER;
        MessageHandlerManager messageHandlerManager = MessageHandlerManager.fromDecoderClasses((List)this.clientEndpointConfig.getDecoders());
        try {
            for (Map.Entry<Class<?>, MessageHandler.Whole<?>> entry : this.wholeMessageHandlers) {
                messageHandlerManager.addMessageHandler(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Class<?>, MessageHandler.Whole<?>> entry : this.partialMessageHandlers) {
                messageHandlerManager.addMessageHandler(entry.getKey(), (MessageHandler.Partial)entry.getValue());
            }
        }
        catch (IllegalStateException ise) {
            throw new DeploymentException(ise.getMessage(), (Throwable)ise);
        }
        URI path = this.uri;
        ClientEndpointConfig clientEndpointConfig = this.clientEndpointConfig;
        final BiConsumer<Session, EndpointConfig> onOpen = this.onOpen;
        final BiConsumer<Session, Throwable> onError = this.onError;
        final BiConsumer<Session, CloseReason> onClose = this.onClose;
        Endpoint endpoint = new Endpoint(){

            public void onOpen(Session session, EndpointConfig config) {
                for (Map.Entry<Class<?>, MessageHandler.Whole<?>> entry : SessionBuilder.this.wholeMessageHandlers) {
                    session.addMessageHandler(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Class<?>, MessageHandler.Whole<?>> entry : SessionBuilder.this.partialMessageHandlers) {
                    session.addMessageHandler(entry.getKey(), (MessageHandler.Partial)entry.getValue());
                }
                onOpen.accept(session, config);
            }

            public void onClose(Session session, CloseReason closeReason) {
                onClose.accept(session, closeReason);
            }

            public void onError(Session session, Throwable thr) {
                onError.accept(session, thr);
            }
        };
        return this.container.connectToServer(endpoint, clientEndpointConfig, path);
    }

    public CompletableFuture<Session> connectAsync() {
        final CompletableFuture<Session> completableFuture = new CompletableFuture<Session>();
        ForkJoinTask<Void> forkJoinTask = new ForkJoinTask<Void>(){

            @Override
            public final Void getRawResult() {
                return null;
            }

            @Override
            public final void setRawResult(Void v) {
            }

            @Override
            protected boolean exec() {
                try {
                    completableFuture.complete(SessionBuilder.this.connect());
                    return true;
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                    return false;
                }
            }
        };
        ForkJoinPool.commonPool().execute(forkJoinTask);
        return completableFuture;
    }

    public CompletableFuture<Session> connectAsync(ExecutorService executorService) {
        CompletableFuture<Session> completableFuture = new CompletableFuture<Session>();
        Runnable runnable = () -> {
            try {
                completableFuture.complete(this.connect());
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        };
        executorService.execute(runnable);
        return completableFuture;
    }
}

