/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientFilter;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyTransportTimeoutFilter;
import org.glassfish.tyrus.container.grizzly.client.HttpCodecFilter;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientEngine;

public class GrizzlyClientSocket {
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig";
    private static final Logger LOGGER = Logger.getLogger(GrizzlyClientSocket.class.getName());
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    private final URI uri;
    private final long timeoutMs;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ThreadPoolConfig workerThreadPoolConfig;
    private final ThreadPoolConfig selectorThreadPoolConfig;
    private final ClientEngine engine;
    private final boolean sharedTransport;
    private final Integer sharedTransportTimeout;
    private final SocketAddress socketAddress;
    private static volatile TCPNIOTransport transport;
    private static final Object TRANSPORT_LOCK;

    GrizzlyClientSocket(URI uri, long timeoutMs, ClientEngine engine, Map<String, Object> properties) {
        SSLEngineConfigurator sslEngineConfigurator;
        this.uri = uri;
        this.timeoutMs = timeoutMs;
        SSLEngineConfigurator sSLEngineConfigurator = sslEngineConfigurator = properties == null ? null : (SSLEngineConfigurator)properties.get("org.glassfish.tyrus.client.sslEngineConfigurator");
        if (uri.getScheme().equalsIgnoreCase("wss") && sslEngineConfigurator == null) {
            SSLContextConfigurator defaultConfig = new SSLContextConfigurator();
            defaultConfig.retrieve(System.getProperties());
            sslEngineConfigurator = new SSLEngineConfigurator(defaultConfig, true, false, false);
        }
        try {
            String property;
            this.clientSSLEngineConfigurator = sslEngineConfigurator;
            this.workerThreadPoolConfig = Utils.getProperty(properties, WORKER_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
            this.selectorThreadPoolConfig = Utils.getProperty(properties, SELECTOR_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
            Boolean shared = Utils.getProperty(properties, "org.glassfish.tyrus.client.sharedContainer", Boolean.class);
            if ((shared == null || !shared.booleanValue()) && (property = System.getProperty("org.glassfish.tyrus.client.sharedContainer")) != null && property.equals("true")) {
                shared = true;
            }
            boolean bl = this.sharedTransport = shared == null ? false : shared;
            if (this.sharedTransport) {
                GrizzlyTransportTimeoutFilter.touch();
            }
            Integer sharedTransportTimeoutProperty = Utils.getProperty(properties, "org.glassfish.tyrus.client.sharedContainerIdleTimeout", Integer.class);
            this.sharedTransportTimeout = this.sharedTransport && sharedTransportTimeoutProperty != null ? sharedTransportTimeoutProperty : 30;
            this.engine = engine;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        this.socketAddress = this.processProxy(properties == null ? null : (String)properties.get(PROXY_URI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, DeploymentException {
        TCPNIOTransport privateTransport = null;
        try {
            if (this.sharedTransport) {
                privateTransport = GrizzlyClientSocket.getOrCreateSharedTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Transport failed to start.", e);
            Object object = TRANSPORT_LOCK;
            synchronized (object) {
                transport = null;
            }
            throw e;
        }
        for (Proxy proxy : this.proxies) {
            GrizzlyFuture<Connection> connectionGrizzlyFuture;
            try {
                if (!this.sharedTransport) {
                    privateTransport = GrizzlyClientSocket.createTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
                    privateTransport.start();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Transport failed to start.", e);
                throw e;
            }
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.sharedTransport ? transport : privateTransport){};
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
            final TCPNIOTransport finalPrivateTransport = privateTransport;
            ClientEngine.TimeoutHandler timeoutHandler = this.sharedTransport ? null : new ClientEngine.TimeoutHandler(){

                @Override
                public void handleTimeout() {
                    GrizzlyClientSocket.this.closeTransport(finalPrivateTransport);
                }
            };
            switch (proxy.type()) {
                case DIRECT: {
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, null, this.clientSSLEngineConfigurator, false, this.uri, timeoutHandler, this.sharedTransport, this.sharedTransportTimeout));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' (no proxy).", this.uri));
                    connectionGrizzlyFuture = connectorHandler.connect(this.socketAddress);
                    break;
                }
                default: {
                    InetSocketAddress inetSocketAddress;
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, null, this.clientSSLEngineConfigurator, true, this.uri, timeoutHandler, this.sharedTransport, this.sharedTransportTimeout));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", this.uri, proxy));
                    SocketAddress address = proxy.address();
                    if (address instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)address).isUnresolved()) {
                        address = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    }
                    connectionGrizzlyFuture = connectorHandler.connect(address);
                }
            }
            try {
                Connection connection = (Connection)connectionGrizzlyFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                LOGGER.log(Level.CONFIG, String.format("Connected to '%s'.", connection.getPeerAddress()));
                return;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), interruptedException);
                this.closeTransport(privateTransport);
            }
            catch (TimeoutException timeoutException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), timeoutException);
                this.closeTransport(privateTransport);
            }
            catch (ExecutionException executionException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), executionException);
                IOException ioException = null;
                Throwable cause = executionException.getCause();
                if (cause != null && cause instanceof IOException) {
                    ioException = (IOException)cause;
                    ProxySelector.getDefault().connectFailed(this.uri, this.socketAddress, ioException);
                }
                this.closeTransport(privateTransport);
                if (ioException == null) continue;
                throw ioException;
            }
        }
        throw new DeploymentException("Connection failed.");
    }

    private static TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        return GrizzlyClientSocket.createTransport(workerThreadPoolConfig, selectorThreadPoolConfig, false);
    }

    private static TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig, boolean sharedTransport) {
        TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
        if (workerThreadPoolConfig == null) {
            if (sharedTransport) {
                transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig());
            } else {
                transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(2).setCorePoolSize(2));
            }
        } else {
            transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
        }
        if (selectorThreadPoolConfig == null) {
            if (sharedTransport) {
                transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig());
            } else {
                transportBuilder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(1).setCorePoolSize(1));
            }
        } else {
            transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
        }
        return transportBuilder.build();
    }

    private SocketAddress processProxy(String proxyString) {
        try {
            if (proxyString != null) {
                URI proxyUri = new URI(proxyString);
                if (proxyUri.getHost() == null) {
                    LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                } else {
                    int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                    this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                }
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        this.addProxies(proxySelector, this.uri, "socket", this.proxies);
        this.addProxies(proxySelector, this.uri, "https", this.proxies);
        this.addProxies(proxySelector, this.uri, "http", this.proxies);
        this.proxies.add(Proxy.NO_PROXY);
        int port = this.uri.getPort();
        if (port == -1) {
            String scheme = this.uri.getScheme();
            assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
            if (scheme.equals("ws")) {
                port = 80;
            } else if (scheme.equals("wss")) {
                port = 443;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format(String.format("Not using proxy for URI '%s'.", this.uri), new Object[0]));
        }
        return new InetSocketAddress(this.uri.getHost(), port);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private static Processor createFilterChain(ClientEngine engine, SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean proxy, URI uri, ClientEngine.TimeoutHandler timeoutHandler, boolean sharedTransport, Integer sharedTransportTimeout) {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        Filter sslFilter = null;
        clientFilterChainBuilder.add(new TransportFilter());
        if (serverSSLEngineConfigurator != null || clientSSLEngineConfigurator != null) {
            sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
            if (proxy) {
                sslFilter = new FilterWrapper(sslFilter);
            }
            clientFilterChainBuilder.add(sslFilter);
        }
        if (sharedTransport) {
            clientFilterChainBuilder.add(new GrizzlyTransportTimeoutFilter(sharedTransportTimeout));
        }
        HttpCodecFilter httpCodecFilter = new HttpCodecFilter();
        clientFilterChainBuilder.add(httpCodecFilter);
        clientFilterChainBuilder.add(new GrizzlyClientFilter(engine, proxy, sslFilter, httpCodecFilter, uri, timeoutHandler, sharedTransport));
        return clientFilterChainBuilder.build();
    }

    private void closeTransport(TCPNIOTransport transport) {
        if (transport != null) {
            try {
                transport.shutdownNow();
            }
            catch (IOException e) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.INFO, "Exception thrown when closing Grizzly transport: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TCPNIOTransport getOrCreateSharedTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) throws IOException {
        Object object = TRANSPORT_LOCK;
        synchronized (object) {
            if (transport == null) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Starting shared container.");
                transport = GrizzlyClientSocket.createTransport(workerThreadPoolConfig, selectorThreadPoolConfig, true);
                transport.start();
            }
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeSharedTransport() {
        Object object = TRANSPORT_LOCK;
        synchronized (object) {
            if (transport != null) {
                try {
                    Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Stopping shared container.");
                    transport.shutdownNow();
                }
                catch (IOException e) {
                    Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.INFO, "Exception thrown when closing Grizzly transport: " + e.getMessage(), e);
                }
            }
            transport = null;
        }
    }

    static {
        TRANSPORT_LOCK = new Object();
    }

    static class FilterWrapper
    implements Filter {
        private final Filter filter;
        private boolean enabled = false;

        FilterWrapper(Filter filter) {
            this.filter = filter;
        }

        public void enable() {
            this.enabled = true;
        }

        @Override
        public void onAdded(FilterChain filterChain) {
            this.filter.onAdded(filterChain);
        }

        @Override
        public void onRemoved(FilterChain filterChain) {
            this.filter.onRemoved(filterChain);
        }

        @Override
        public void onFilterChainChanged(FilterChain filterChain) {
            this.filter.onFilterChainChanged(filterChain);
        }

        @Override
        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        @Override
        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        @Override
        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        @Override
        public NextAction handleAccept(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        @Override
        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (this.enabled) {
                return this.filter.handleEvent(ctx, event);
            }
            return ctx.getInvokeAction();
        }

        @Override
        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleClose(ctx);
            }
            return ctx.getInvokeAction();
        }

        @Override
        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            if (this.enabled) {
                this.filter.exceptionOccurred(ctx, error);
            } else {
                ctx.getInvokeAction();
            }
        }
    }
}

