/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketListener;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public abstract class WebSocketApplication
implements WebSocketListener {
    private final Map<WebSocket, Boolean> sockets = new ConcurrentHashMap<WebSocket, Boolean>();

    public abstract WebSocket createSocket(ProtocolHandler var1, WebSocketListener ... var2);

    @Override
    public void onClose(WebSocket socket, CloseReason closeReason) {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    public final boolean upgrade(UpgradeRequest request) {
        String upgradeHeader = request.getHeader("Upgrade");
        return request.getHeaders().get("Upgrade") != null && "websocket".equalsIgnoreCase(upgradeHeader) && this.isApplicationRequest(request);
    }

    public boolean onError(WebSocket webSocket, Throwable t) {
        return true;
    }

    public abstract void onHandShakeResponse(UpgradeRequest var1, UpgradeResponse var2);

    protected abstract boolean isApplicationRequest(UpgradeRequest var1);

    public abstract String getPath();

    public abstract List<Extension> getSupportedExtensions();

    public abstract List<String> getSupportedProtocols(List<String> var1);

    boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }
}

