/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.io.Writer;
import org.glassfish.tyrus.core.RemoteEndpoint;

class WriterToAsyncTextAdapter
extends Writer {
    private final RemoteEndpoint re;
    private String buffer = null;

    public WriterToAsyncTextAdapter(RemoteEndpoint re) {
        this.re = re;
    }

    private void sendBuffer(boolean last) {
        this.re.sendText(this.buffer, last);
    }

    @Override
    public void write(char[] chars, int index, int len) throws IOException {
        if (this.buffer != null) {
            this.sendBuffer(false);
        }
        this.buffer = new String(chars).substring(index, index + len);
    }

    @Override
    public void flush() throws IOException {
        this.sendBuffer(false);
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        this.sendBuffer(true);
    }
}

