/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.Session;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.ConnectionImpl;
import org.glassfish.tyrus.container.grizzly.WebSocketFilter;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeListener;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;
import org.glassfish.tyrus.websockets.frametypes.PingFrameType;
import org.glassfish.tyrus.websockets.frametypes.PongFrameType;

public class GrizzlyClientSocket
implements WebSocket,
TyrusClientSocket {
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig";
    public static final Logger LOGGER = Logger.getLogger(GrizzlyClientSocket.class.getName());
    private final URI uri;
    private final ProtocolHandler protocolHandler;
    private final SPIEndpoint endpoint;
    private TCPNIOTransport transport;
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final TyrusRemoteEndpoint remoteEndpoint;
    private final long timeoutMs;
    private final ClientEndpointConfig configuration;
    private final SPIHandshakeListener listener;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final String proxyUri;
    private final ThreadPoolConfig workerThreadPoolConfig;
    private final ThreadPoolConfig selectorThreadPoolConfig;
    private Session session = null;
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final List<Extension> responseExtensions = new ArrayList<Extension>();

    GrizzlyClientSocket(SPIEndpoint endpoint, URI uri, ClientEndpointConfig configuration, long timeoutMs, SPIHandshakeListener listener, SSLEngineConfigurator clientSSLEngineConfigurator, String proxyUri, ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        this.endpoint = endpoint;
        this.uri = uri;
        this.configuration = configuration;
        this.protocolHandler = WebSocketEngine.DEFAULT_VERSION.createHandler(true);
        this.protocolHandler.setContainer(endpoint.getWebSocketContainer());
        this.remoteEndpoint = new TyrusRemoteEndpoint(this);
        this.timeoutMs = timeoutMs;
        this.listener = listener;
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator;
        this.proxyUri = proxyUri;
        this.workerThreadPoolConfig = workerThreadPoolConfig;
        this.selectorThreadPoolConfig = selectorThreadPoolConfig;
        if (this.session == null) {
            this.session = endpoint.createSessionForRemoteEndpoint(this.remoteEndpoint, null, null);
        }
    }

    public void connect() {
        try {
            TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
            if (this.workerThreadPoolConfig == null) {
                transportBuilder.getWorkerThreadPoolConfig().setMaxPoolSize(1).setCorePoolSize(1);
            } else {
                transportBuilder.setWorkerThreadPoolConfig(this.workerThreadPoolConfig);
            }
            if (this.selectorThreadPoolConfig == null) {
                transportBuilder.getSelectorThreadPoolConfig().setMaxPoolSize(1).setCorePoolSize(1);
            } else {
                transportBuilder.setSelectorThreadPoolConfig(this.selectorThreadPoolConfig);
            }
            this.transport = transportBuilder.build();
            this.transport.start();
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                @Override
                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    org.glassfish.tyrus.websockets.Connection connection = GrizzlyClientSocket.getConnection(conn);
                    GrizzlyClientSocket.this.protocolHandler.setConnection(connection);
                    WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(connection, GrizzlyClientSocket.this.protocolHandler, RequestContext.Builder.create().requestURI(GrizzlyClientSocket.this.uri).build(), GrizzlyClientSocket.this, null);
                    GrizzlyClientSocket.this.prepareHandshake(holder.handshake);
                }
            };
            URI proxy = null;
            try {
                if (this.proxyUri != null && (proxy = new URI(this.proxyUri)).getHost() == null) {
                    LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", this.proxyUri));
                    proxy = null;
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", this.proxyUri), e);
            }
            connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(null, this.clientSSLEngineConfigurator, proxy != null));
            int port = this.uri.getPort();
            if (port == -1) {
                String scheme = this.uri.getScheme();
                assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
                if (scheme.equals("ws")) {
                    port = 80;
                } else if (scheme.equals("wss")) {
                    port = 443;
                }
            }
            if (proxy != null) {
                int proxyPort = proxy.getPort() == -1 ? 80 : proxy.getPort();
                connectorHandler.connect(new InetSocketAddress(proxy.getHost(), proxyPort));
            } else {
                connectorHandler.connect(new InetSocketAddress(this.uri.getHost(), port));
            }
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
            this.awaitOnConnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandshakeException(e.getMessage());
        }
    }

    private void prepareHandshake(HandShake handshake) {
        ArrayList<org.glassfish.tyrus.websockets.Extension> grizzlyExtensions = new ArrayList<org.glassfish.tyrus.websockets.Extension>();
        for (Extension e : this.configuration.getExtensions()) {
            org.glassfish.tyrus.websockets.Extension grizzlyExtension = new org.glassfish.tyrus.websockets.Extension(e.getName());
            for (Extension.Parameter p : e.getParameters()) {
                grizzlyExtension.getParameters().add(new Extension.Parameter(p.getName(), p.getValue()));
            }
            grizzlyExtensions.add(grizzlyExtension);
        }
        handshake.setExtensions(grizzlyExtensions);
        handshake.setSubProtocols(this.configuration.getPreferredSubprotocols());
        handshake.setResponseListener(new HandShake.HandShakeResponseListener(){

            @Override
            public void onResponseHeaders(Map<String, String> originalHeaders) {
                String value = originalHeaders.get("Sec-WebSocket-Extensions");
                if (value != null) {
                    GrizzlyClientSocket.this.responseExtensions.addAll(TyrusExtension.fromString(Arrays.asList(value)));
                }
                GrizzlyClientSocket.this.listener.onResponseHeaders(originalHeaders);
            }

            @Override
            public void onError(HandshakeException exception) {
                GrizzlyClientSocket.this.listener.onError(exception);
                GrizzlyClientSocket.this.onConnectLatch.countDown();
            }
        });
        handshake.prepareRequest();
        this.configuration.getConfigurator().beforeRequest(handshake.getRequest().getHeaders());
    }

    @Override
    public Future<DataFrame> send(String s) {
        if (this.isConnected()) {
            return this.protocolHandler.send(s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> send(byte[] bytes) {
        if (this.isConnected()) {
            return this.protocolHandler.send(bytes);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> sendPing(byte[] bytes) {
        DataFrame df = new DataFrame((FrameType)new PingFrameType(), bytes);
        return this.protocolHandler.send(df, false);
    }

    @Override
    public Future<DataFrame> sendPong(byte[] bytes) {
        DataFrame df = new DataFrame((FrameType)new PongFrameType(), bytes);
        return this.protocolHandler.send(df, false);
    }

    @Override
    public Future<DataFrame> stream(boolean b, String s) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public Future<DataFrame> stream(boolean b, byte[] bytes, int i, int i1) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, bytes, i, i1);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    @Override
    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), "Closing");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void close(int i) {
        this.close(i, null);
    }

    @Override
    public void close(int i, String s) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(i, s);
            this.closeTransport();
        }
        this.onClose(new ClosingFrame(i, s));
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    @Override
    public void onConnect() {
        this.state.set(State.CONNECTED);
        this.endpoint.onConnect(this.remoteEndpoint, null, this.responseExtensions);
        this.onConnectLatch.countDown();
    }

    @Override
    public void onMessage(String message) {
        this.awaitOnConnect();
        this.endpoint.onMessage((SPIRemoteEndpoint)this.remoteEndpoint, message);
    }

    @Override
    public void onMessage(byte[] bytes) {
        this.awaitOnConnect();
        this.endpoint.onMessage((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes));
    }

    @Override
    public void onFragment(boolean b, String s) {
        this.awaitOnConnect();
        this.endpoint.onPartialMessage((SPIRemoteEndpoint)this.remoteEndpoint, s, b);
    }

    @Override
    public void onFragment(boolean bool, byte[] bytes) {
        this.awaitOnConnect();
        this.endpoint.onPartialMessage((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes), bool);
    }

    @Override
    public void onClose(ClosingFrame dataFrame) {
        this.onConnectLatch.countDown();
        if (this.state.get() == State.CLOSED) {
            return;
        }
        if (!this.state.compareAndSet(State.CLOSING, State.CLOSED)) {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
            this.closeTransport();
        }
        CloseReason closeReason = null;
        if (dataFrame != null) {
            closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode(dataFrame.getCode()), dataFrame.getReason());
        }
        this.endpoint.onClose(this.remoteEndpoint, closeReason);
    }

    @Override
    public void onPing(DataFrame dataFrame) {
        this.awaitOnConnect();
        this.endpoint.onPing(this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
    }

    @Override
    public void onPong(DataFrame dataFrame) {
        this.awaitOnConnect();
        this.endpoint.onPong(this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
    }

    @Override
    public boolean add(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWriteTimeout(long timeoutMs) {
        this.protocolHandler.setWriteTimeout(timeoutMs);
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Processor createFilterChain(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean proxy) {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add(new TransportFilter());
        if (serverSSLEngineConfigurator != null || clientSSLEngineConfigurator != null) {
            clientFilterChainBuilder.add(new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator));
        }
        clientFilterChainBuilder.add(new HttpClientFilter());
        clientFilterChainBuilder.add(new WebSocketFilter(900L, proxy));
        return clientFilterChainBuilder.build();
    }

    private static org.glassfish.tyrus.websockets.Connection getConnection(Connection connection) {
        return new ConnectionImpl(connection);
    }

    private void closeTransport() {
        if (this.transport != null) {
            try {
                this.transport.stop();
            }
            catch (IOException e) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Transport closing problem.");
            }
        }
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

