/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;

public final class IndexedAttributeHolder
implements AttributeHolder {
    private volatile int count;
    private int size;
    private Object[] attributeValues;
    private int[] i2v;
    protected final DefaultAttributeBuilder attributeBuilder;
    protected final IndexedAttributeAccessor indexedAttributeAccessor;

    public IndexedAttributeHolder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = (DefaultAttributeBuilder)attributeBuilder;
        this.attributeValues = new Object[4];
        this.i2v = new int[4];
        this.i2v[3] = -1;
        this.i2v[2] = -1;
        this.i2v[1] = -1;
        this.i2v[0] = -1;
        this.indexedAttributeAccessor = new IndexedAttributeAccessorImpl();
    }

    @Override
    public Object getAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.getAttribute(attribute.index());
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            attribute = this.attributeBuilder.createAttribute(name);
        }
        this.indexedAttributeAccessor.setAttribute(attribute.index(), value);
    }

    @Override
    public Object removeAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            int index = attribute.index();
            Object value = this.indexedAttributeAccessor.getAttribute(index);
            if (value != null) {
                this.indexedAttributeAccessor.setAttribute(index, null);
            }
            return value;
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet<String> result = new HashSet<String>();
        int localSize = this.size;
        Object[] localAttributeValues = this.attributeValues;
        for (int i = 0; i < localSize; ++i) {
            Object value = localAttributeValues[i];
            if (value == null) continue;
            Attribute attribute = this.attributeBuilder.getAttributeByIndex(i);
            result.add(attribute.name());
        }
        return result;
    }

    @Override
    public void recycle() {
        for (int i = 0; i < this.size; ++i) {
            this.attributeValues[i] = null;
        }
    }

    @Override
    public void clear() {
        this.attributeValues = new Object[this.attributeValues.length];
        ++this.count;
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return this.indexedAttributeAccessor;
    }

    private static Object[] ensureSize(Object[] array, int size) {
        int arrayLength = array.length;
        int delta = size - arrayLength;
        int newLength = Math.max(arrayLength + delta, arrayLength * 3 / 2 + 1);
        return Arrays.copyOf(array, newLength);
    }

    private static int[] ensureSize(int[] array, int size) {
        int arrayLength = array.length;
        int delta = size - arrayLength;
        int newLength = Math.max(arrayLength + delta, arrayLength * 3 / 2 + 1);
        int[] newArray = Arrays.copyOf(array, newLength);
        Arrays.fill(newArray, array.length, newLength, -1);
        return newArray;
    }

    static /* synthetic */ int[] access$102(IndexedAttributeHolder x0, int[] x1) {
        x0.i2v = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$202(IndexedAttributeHolder x0, Object[] x1) {
        x0.attributeValues = x1;
        return x1;
    }

    protected final class IndexedAttributeAccessorImpl
    implements IndexedAttributeAccessor {
        protected IndexedAttributeAccessorImpl() {
        }

        @Override
        public Object getAttribute(int index) {
            int idx;
            int[] i2vLocal;
            if (IndexedAttributeHolder.this.count != 0 && index < (i2vLocal = IndexedAttributeHolder.this.i2v).length && (idx = i2vLocal[index]) != -1) {
                return IndexedAttributeHolder.this.attributeValues[idx];
            }
            return null;
        }

        @Override
        public void setAttribute(int index, Object value) {
            int mappedIdx;
            int[] localI2v = IndexedAttributeHolder.this.i2v;
            if (index >= localI2v.length || (mappedIdx = localI2v[index]) == -1) {
                mappedIdx = this.mapIndex(index);
            }
            ((IndexedAttributeHolder)IndexedAttributeHolder.this).attributeValues[mappedIdx] = value;
            IndexedAttributeHolder.this.count++;
        }

        private synchronized int mapIndex(int index) {
            int mappedIdx;
            if (index >= IndexedAttributeHolder.this.i2v.length) {
                IndexedAttributeHolder.access$102(IndexedAttributeHolder.this, IndexedAttributeHolder.ensureSize(IndexedAttributeHolder.this.i2v, index + 1));
            }
            if ((mappedIdx = IndexedAttributeHolder.this.i2v[index]) == -1) {
                if (IndexedAttributeHolder.this.size == IndexedAttributeHolder.this.attributeValues.length) {
                    IndexedAttributeHolder.access$202(IndexedAttributeHolder.this, IndexedAttributeHolder.ensureSize(IndexedAttributeHolder.this.attributeValues, IndexedAttributeHolder.this.size + 1));
                }
                IndexedAttributeHolder.this.count++;
                ((IndexedAttributeHolder)IndexedAttributeHolder.this).i2v[index] = mappedIdx = IndexedAttributeHolder.this.size++;
            }
            return mappedIdx;
        }
    }
}

