/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.StrictUtf8;
import org.glassfish.tyrus.websockets.Utf8Utils;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketEngine;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private final FrameType type;
    private boolean last = true;

    public DataFrame(FrameType type) {
        this.type = type;
    }

    public DataFrame(FrameType type, String data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, String data, boolean fin) {
        this.type = type;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(FrameType type, byte[] data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, byte[] data, boolean fin) {
        this.type = type;
        type.setPayload(this, data);
        this.last = fin;
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        if (this.payload != null) {
            this.bytes = Utf8Utils.encode(new StrictUtf8(), this.payload);
        }
        return this.bytes;
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + WebSocketEngine.toString(this.bytes) + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

