/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.BinaryBuffer;
import org.glassfish.tyrus.core.MessageTooBigException;

class TextBuffer {
    private StringBuffer buffer;
    private int bufferSize;
    private static final Logger LOGGER = Logger.getLogger(BinaryBuffer.class.getName());

    TextBuffer() {
    }

    void appendMessagePart(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (this.buffer.length() + message.length() > this.bufferSize) {
            MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
            LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
            throw messageTooBigException;
        }
        this.buffer.append(message);
    }

    String getBufferedContent() {
        return this.buffer.toString();
    }

    void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = new StringBuffer();
    }
}

