/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.AsyncMessageHandler;
import org.glassfish.tyrus.core.BasicMessageHandler;
import org.glassfish.tyrus.core.BinaryBuffer;
import org.glassfish.tyrus.core.CoderWrapper;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.InputStreamBuffer;
import org.glassfish.tyrus.core.MessageHandlerManager;
import org.glassfish.tyrus.core.MessageTooBigException;
import org.glassfish.tyrus.core.ReaderBuffer;
import org.glassfish.tyrus.core.RemoteEndpointWrapper;
import org.glassfish.tyrus.core.TextBuffer;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.ExecutorServiceProvider;

public class SessionImpl
implements Session {
    private final WebSocketContainer container;
    private final EndpointWrapper endpoint;
    private final RemoteEndpointWrapper.Basic basicRemote;
    private final RemoteEndpointWrapper.Async asyncRemote;
    private String negotiatedSubprotocol;
    private List<Extension> negotiatedExtensions;
    private final boolean isSecure;
    private final URI uri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private final Principal userPrincipal;
    private final Map<String, List<String>> requestParameterMap;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;
    private volatile long maxIdleTimeout = 0L;
    private ScheduledExecutorService service;
    private ScheduledFuture<?> idleTimeoutFuture = null;
    private final Object idleTimeoutLock = new Object();
    private final String id = UUID.randomUUID().toString();
    private static final Logger LOGGER = Logger.getLogger(SessionImpl.class.getName());
    private final Map<String, Object> userProperties = new HashMap<String, Object>();
    private final MessageHandlerManager handlerManager;
    private static final String SESSION_CLOSED = "The connection has been closed.";
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final TextBuffer textBuffer = new TextBuffer();
    private final BinaryBuffer binaryBuffer = new BinaryBuffer();
    private ReaderBuffer readerBuffer;
    private InputStreamBuffer inputStreamBuffer;

    SessionImpl(WebSocketContainer container, SPIRemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper, String subprotocol, List<Extension> extensions, boolean isSecure, URI uri, String queryString, Map<String, String> pathParameters, Principal principal, Map<String, List<String>> requestParameterMap) {
        this.container = container;
        this.endpoint = endpointWrapper;
        this.negotiatedSubprotocol = subprotocol;
        this.negotiatedExtensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions);
        this.isSecure = isSecure;
        this.uri = uri;
        this.queryString = queryString;
        this.pathParameters = pathParameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(pathParameters));
        this.basicRemote = new RemoteEndpointWrapper.Basic(this, remoteEndpoint, endpointWrapper);
        this.asyncRemote = new RemoteEndpointWrapper.Async(this, remoteEndpoint, endpointWrapper);
        this.handlerManager = MessageHandlerManager.fromDecoderInstances(endpointWrapper.getDecoders());
        this.userPrincipal = principal;
        Map<Object, Object> map = this.requestParameterMap = requestParameterMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, List<String>>(requestParameterMap));
        if (container != null) {
            this.maxTextMessageBufferSize = container.getDefaultMaxTextMessageBufferSize();
            this.maxBinaryMessageBufferSize = container.getDefaultMaxBinaryMessageBufferSize();
            this.service = ((ExecutorServiceProvider)((Object)container)).getScheduledExecutorService();
        }
    }

    @Override
    public String getProtocolVersion() {
        return "13";
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @Override
    public RemoteEndpoint.Async getAsyncRemote() {
        this.checkConnectionState(State.CLOSED, State.CLOSING);
        return this.asyncRemote;
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        this.checkConnectionState(State.CLOSED, State.CLOSING);
        return this.basicRemote;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() != State.CLOSED && this.state.get() != State.CLOSING;
    }

    @Override
    public void close() throws IOException {
        this.changeStateToClosing();
        this.basicRemote.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "no reason given"));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.checkConnectionState(State.CLOSED);
        this.changeStateToClosing();
        this.basicRemote.close(closeReason);
    }

    @Override
    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setMaxBinaryMessageBufferSize(int maxBinaryMessageBufferSize) {
        this.checkConnectionState(State.CLOSED);
        this.maxBinaryMessageBufferSize = maxBinaryMessageBufferSize;
    }

    @Override
    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setMaxTextMessageBufferSize(int maxTextMessageBufferSize) {
        this.checkConnectionState(State.CLOSED);
        this.maxTextMessageBufferSize = maxTextMessageBufferSize;
    }

    @Override
    public Set<Session> getOpenSessions() {
        this.checkConnectionState(State.CLOSED);
        return this.endpoint.getOpenSessions();
    }

    @Override
    public List<Extension> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    @Override
    public void setMaxIdleTimeout(long maxIdleTimeout) {
        this.checkConnectionState(State.CLOSED);
        this.maxIdleTimeout = maxIdleTimeout;
        this.restartIdleTimeoutExecutor();
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public WebSocketContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageHandler(MessageHandler handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.addMessageHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MessageHandler> getMessageHandlers() {
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            return this.handlerManager.getMessageHandlers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageHandler(MessageHandler handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.removeMessageHandler(handler);
        }
    }

    @Override
    public URI getRequestURI() {
        return this.uri;
    }

    @Override
    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartIdleTimeoutExecutor() {
        if (this.maxIdleTimeout < 1L) {
            return;
        }
        Object object = this.idleTimeoutLock;
        synchronized (object) {
            if (this.idleTimeoutFuture != null) {
                this.idleTimeoutFuture.cancel(false);
            }
            this.idleTimeoutFuture = this.service.schedule(new IdleTimeoutCommand(), this.getMaxIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void checkConnectionState(State ... states) {
        for (State s : states) {
            if (this.state.get() != s) continue;
            throw new IllegalStateException(SESSION_CLOSED);
        }
    }

    void setNegotiatedSubprotocol(String negotiatedSubprotocol) {
        this.negotiatedSubprotocol = negotiatedSubprotocol == null ? "" : negotiatedSubprotocol;
    }

    void setNegotiatedExtensions(List<Extension> negotiatedExtensions) {
        this.negotiatedExtensions = Collections.unmodifiableList(new ArrayList<Extension>(negotiatedExtensions));
    }

    private void checkMessageSize(Object message, long maxMessageSize) {
        long messageSize;
        if (maxMessageSize != -1L && (messageSize = (long)(message instanceof String ? ((String)message).getBytes(Charset.defaultCharset()).length : ((ByteBuffer)message).remaining())) > maxMessageSize) {
            throw new MessageTooBigException(String.format("Message too long; allowed message size is %d bytes. (Current message length is %d bytes).", maxMessageSize, messageSize));
        }
    }

    void notifyMessageHandlers(Object message, List<CoderWrapper<Decoder>> availableDecoders) {
        this.checkConnectionState(State.CLOSED);
        boolean decoded = false;
        if (availableDecoders.isEmpty()) {
            LOGGER.severe("No decoder found");
        }
        for (CoderWrapper<Decoder> decoder : availableDecoders) {
            for (MessageHandler mh : this.getOrderedMessageHandlers()) {
                Object object;
                Class<?> type;
                if (!(mh instanceof MessageHandler.Whole) || !(type = MessageHandlerManager.getHandlerType(mh)).isAssignableFrom(decoder.getType())) continue;
                if (mh instanceof BasicMessageHandler) {
                    this.checkMessageSize(message, ((BasicMessageHandler)mh).getMaxMessageSize());
                }
                if ((object = this.endpoint.decodeCompleteMessage(this, message, type, decoder)) == null) continue;
                ((MessageHandler.Whole)mh).onMessage(object);
                decoded = true;
                break;
            }
            if (!decoded) continue;
            break;
        }
    }

    <T> MessageHandler.Whole<T> getMessageHandler(Class<T> c) {
        for (MessageHandler mh : this.getOrderedMessageHandlers()) {
            if (MessageHandlerManager.getHandlerType(mh) != c) continue;
            return (MessageHandler.Whole)mh;
        }
        return null;
    }

    void notifyMessageHandlers(Object message, boolean last) {
        this.checkConnectionState(State.CLOSED);
        boolean handled = false;
        for (MessageHandler handler : this.getMessageHandlers()) {
            if (!(handler instanceof MessageHandler.Partial) || !MessageHandlerManager.getHandlerType(handler).isAssignableFrom(message.getClass())) continue;
            if (handler instanceof AsyncMessageHandler) {
                this.checkMessageSize(message, ((AsyncMessageHandler)handler).getMaxMessageSize());
            }
            ((MessageHandler.Partial)handler).onMessage(message, last);
            handled = true;
            break;
        }
        if (!handled) {
            if (message instanceof ByteBuffer) {
                this.notifyMessageHandlers((Object)((ByteBuffer)message).array(), last);
            } else {
                LOGGER.severe("Unhandled text message in EndpointWrapper");
            }
        }
    }

    void notifyPongHandler(PongMessage pongMessage) {
        Set<MessageHandler> messageHandlers = this.getMessageHandlers();
        for (MessageHandler handler : messageHandlers) {
            if (!MessageHandlerManager.getHandlerType(handler).equals(PongMessage.class)) continue;
            ((MessageHandler.Whole)handler).onMessage(pongMessage);
        }
    }

    boolean isWholeTextHandlerPresent() {
        return this.handlerManager.isWholeTextHandlerPresent();
    }

    boolean isWholeBinaryHandlerPresent() {
        return this.handlerManager.isWholeBinaryHandlerPresent();
    }

    boolean isPartialTextHandlerPresent() {
        return this.handlerManager.isPartialTextHandlerPresent();
    }

    boolean isPartialBinaryHandlerPresent() {
        return this.handlerManager.isPartialBinaryHandlerPresent();
    }

    boolean isReaderHandlerPresent() {
        return this.handlerManager.isReaderHandlerPresent();
    }

    boolean isInputStreamHandlerPresent() {
        return this.handlerManager.isInputStreamHandlerPresent();
    }

    boolean isPongHandlerPreset() {
        return this.handlerManager.isPongHandlerPresent();
    }

    private List<MessageHandler> getOrderedMessageHandlers() {
        Set<MessageHandler> handlers = this.getMessageHandlers();
        ArrayList<MessageHandler> result = new ArrayList<MessageHandler>();
        result.addAll(handlers);
        Collections.sort(result, new MessageHandlerComparator());
        return result;
    }

    State getState() {
        return this.state.get();
    }

    TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    BinaryBuffer getBinaryBuffer() {
        return this.binaryBuffer;
    }

    public void setState(State state) {
        this.checkConnectionState(State.CLOSED);
        this.state.set(state);
    }

    ReaderBuffer getReaderBuffer() {
        return this.readerBuffer;
    }

    InputStreamBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    void setReaderBuffer(ReaderBuffer readerBuffer) {
        this.readerBuffer = readerBuffer;
    }

    void setInputStreamBuffer(InputStreamBuffer inputStreamBuffer) {
        this.inputStreamBuffer = inputStreamBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionImpl");
        sb.append("{uri=").append(this.uri);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", endpoint=").append(this.endpoint);
        sb.append('}');
        return sb.toString();
    }

    private void changeStateToClosing() {
        this.state.compareAndSet(State.RUNNING, State.CLOSING);
        this.state.compareAndSet(State.RECEIVING_BINARY, State.CLOSING);
        this.state.compareAndSet(State.RECEIVING_TEXT, State.CLOSING);
    }

    private class IdleTimeoutCommand
    implements Runnable {
        private IdleTimeoutCommand() {
        }

        @Override
        public void run() {
            try {
                SessionImpl session = SessionImpl.this;
                if (session.isOpen()) {
                    session.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "Session closed by the container because of the idle timeout."));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Session could not been closed. " + e.getMessage());
            }
        }
    }

    private class MessageHandlerComparator
    implements Comparator<MessageHandler> {
        private MessageHandlerComparator() {
        }

        @Override
        public int compare(MessageHandler o1, MessageHandler o2) {
            if (o1 instanceof MessageHandler.Whole) {
                if (o2 instanceof MessageHandler.Whole) {
                    Class<?> type2;
                    Class<?> type1 = MessageHandlerManager.getHandlerType(o1);
                    if (type1.isAssignableFrom(type2 = MessageHandlerManager.getHandlerType(o2))) {
                        return 1;
                    }
                    if (type2.isAssignableFrom(type1)) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            if (o2 instanceof MessageHandler.Whole) {
                return 1;
            }
            return 0;
        }
    }

    public static enum State {
        RUNNING,
        RECEIVING_TEXT,
        RECEIVING_BINARY,
        CLOSING,
        CLOSED;

    }
}

