/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets.draft06;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.SecKey;

public class HandShake06
extends HandShake {
    private final SecKey secKey;
    private final List<String> enabledExtensions = Collections.emptyList();
    private final List<String> enabledProtocols = Collections.emptyList();

    public HandShake06(WebSocketRequest webSocketRequest, boolean client) {
        super(webSocketRequest, client);
        this.secKey = new SecKey();
    }

    public HandShake06(WebSocketRequest request) {
        super(request);
        String value = request.getFirstHeaderValue("Sec-WebSocket-Extensions");
        if (value != null) {
            this.setExtensions(HandShake.fromHeaders(Arrays.asList(value)));
        }
        this.secKey = SecKey.generateServerKey(new SecKey(request.getFirstHeaderValue("Sec-WebSocket-Key")));
    }

    @Override
    public void setHeaders(WebSocketResponse response) {
        response.setReasonPhrase("Switching Protocols");
        response.getHeaders().put("Sec-WebSocket-Accept", this.secKey.getSecKey());
        if (!this.getEnabledExtensions().isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Extensions", this.getHeaderFromList(this.getSubProtocols()));
        }
    }

    @Override
    public WebSocketRequest prepareRequest() {
        WebSocketRequest webSocketRequest = super.prepareRequest();
        webSocketRequest.putSingleHeader("Sec-WebSocket-Key", this.secKey.toString());
        webSocketRequest.putSingleHeader("Sec-WebSocket-Origin", this.getOrigin());
        webSocketRequest.putSingleHeader("Sec-WebSocket-Version", this.getVersion() + "");
        if (!this.getExtensions().isEmpty()) {
            webSocketRequest.putSingleHeader("Sec-WebSocket-Extensions", this.getHeaderFromList(this.getExtensions()));
        }
        return webSocketRequest;
    }

    protected int getVersion() {
        return 6;
    }

    @Override
    public void validateServerResponse(WebSocketResponse response) throws HandshakeException {
        super.validateServerResponse(response);
        this.secKey.validateServerKey(response.getHeaders().get("Sec-WebSocket-Accept"));
    }

    List<String> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

