/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.pfl.basic.reflection.Bridge;

public class FieldValueHelper {
    private static final Bridge bridge = Bridge.get();

    public static Object getFieldValue(Object obj, Field field) throws IllegalAccessException {
        if (field.isAccessible()) {
            return field.get(obj);
        }
        return FieldValueHelper.getPrivateFieldValue(obj, field);
    }

    private static Object getPrivateFieldValue(Object obj, Field field) throws IllegalAccessException {
        try {
            FieldValueHelper.makeFieldAccessible(field);
            return field.get(obj);
        }
        catch (Throwable t) {
            return FieldValueHelper.getInacessibleFieldValue(obj, field);
        }
    }

    private static void makeFieldAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    private static Object getInacessibleFieldValue(Object obj, Field field) {
        long offset = bridge.objectFieldOffset(field);
        if (!field.getType().isPrimitive()) {
            return bridge.getObject(obj, offset);
        }
        if (field.getType() == Integer.TYPE) {
            return bridge.getInt(obj, offset);
        }
        if (field.getType() == Byte.TYPE) {
            return bridge.getByte(obj, offset);
        }
        if (field.getType() == Long.TYPE) {
            return bridge.getLong(obj, offset);
        }
        if (field.getType() == Float.TYPE) {
            return Float.valueOf(bridge.getFloat(obj, offset));
        }
        if (field.getType() == Double.TYPE) {
            return bridge.getDouble(obj, offset);
        }
        if (field.getType() == Short.TYPE) {
            return bridge.getShort(obj, offset);
        }
        if (field.getType() == Character.TYPE) {
            return Character.valueOf(bridge.getChar(obj, offset));
        }
        if (field.getType() == Boolean.TYPE) {
            return bridge.getBoolean(obj, offset);
        }
        return null;
    }
}

