/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;

class ServerSourceDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ServerSourceDeliveryCallback.class);
    private final RuntimeContext rc;

    public ServerSourceDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw (RxRuntimeException)LOGGER.logSevereException((Throwable)new RxRuntimeException(LocalizationMessages.WSRM_1141_UNEXPECTED_MESSAGE_CLASS(message.getClass().getName(), JaxwsApplicationMessage.class.getName())));
        }
        this.deliver((JaxwsApplicationMessage)JaxwsApplicationMessage.class.cast(message));
    }

    public void deliver(JaxwsApplicationMessage message) {
        this.rc.sourceMessageHandler.attachAcknowledgementInfo(message);
        Packet outboundPacketCopy = message.getPacket().copy(true);
        this.rc.protocolHandler.appendSequenceHeader(outboundPacketCopy.getMessage(), message);
        this.rc.protocolHandler.appendAcknowledgementHeaders(outboundPacketCopy, message.getAcknowledgementData());
        this.rc.suspendedFiberStorage.resumeFiber(message.getCorrelationId(), outboundPacketCopy);
    }
}

