/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.security.secconv.WSSecureConversationRuntimeException;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.message.stream.LazyStreamBasedMessage;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityRecipient;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSCContract;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SubjectAccessor;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.WSITProviderSecurityEnvironment;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.provider.wsit.PolicyAlternativeHolder;
import com.sun.xml.wss.provider.wsit.PolicyResolverFactory;
import com.sun.xml.wss.provider.wsit.WSITAuthContextBase;
import com.sun.xml.wss.provider.wsit.WSITServerAuthModule;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import com.sun.xml.wss.util.ServletContextUtil;
import com.sun.xml.wss.util.WSSServletContextFacade;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

public class WSITServerAuthContext
extends WSITAuthContextBase
implements ServerAuthContext {
    protected static final String TRUE = "true";
    static final String SERVICE_ENDPOINT = "SERVICE_ENDPOINT";
    private final SessionManager sessionManager;
    private Set trustConfig;
    private Set wsscConfig;
    private CallbackHandler handler;
    final WeakReference<WSEndpoint> endPoint;
    private final WSITServerAuthModule authModule;
    static final String PIPE_HELPER = "PIPE_HELPER";

    public WSITServerAuthContext(String operation, Subject subject, Map<String, Object> map, CallbackHandler callbackHandler) {
        super(map);
        String jmacHandler;
        this.endPoint = new WeakReference<Object>(map.get("ENDPOINT"));
        boolean isSC = !this.getInBoundSCP(null).isEmpty() || !this.getOutBoundSCP(null).isEmpty();
        Set<PolicyAssertion> configAssertions = null;
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            for (SecurityPolicyHolder holder : p.getInMessagePolicyMap().values()) {
                if (configAssertions != null) {
                    configAssertions.addAll(holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/server"));
                } else {
                    configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/server");
                }
                if (this.trustConfig != null) {
                    this.trustConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/server"));
                } else {
                    this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/server");
                }
                if (this.wsscConfig != null) {
                    this.wsscConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/server"));
                    continue;
                }
                this.wsscConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/server");
            }
        }
        String isGF = System.getProperty("com.sun.aas.installRoot");
        Properties props = new Properties();
        if (isGF != null) {
            try {
                this.populateConfigProperties(configAssertions, props);
                jmacHandler = props.getProperty("jmac.callbackhandler");
                if (jmacHandler != null) {
                    this.handler = this.loadGFHandler(false, jmacHandler);
                } else if (callbackHandler != null) {
                    this.handler = callbackHandler;
                }
                if (this.handler == null) {
                    this.handler = this.loadGFHandler(false, jmacHandler);
                }
                this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), (Throwable)ex);
            }
        } else {
            this.handler = this.configureServerHandler(configAssertions, props);
            jmacHandler = props.getProperty("jmac.callbackhandler");
            if (jmacHandler != null) {
                try {
                    this.handler = this.loadGFHandler(false, jmacHandler);
                    this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
                }
                catch (XWSSecurityException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), ex);
                    throw new WebServiceException(LogStringsMessages.WSITPVD_0048_ERROR_POPULATING_SERVER_CONFIG_PROP(), (Throwable)ex);
                }
            } else {
                this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler, props);
            }
        }
        this.sessionManager = SessionManager.getSessionManager((WSEndpoint)this.endPoint.get(), isSC, props);
        this.authModule = new WSITServerAuthModule();
        this.authModule.initialize(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        try {
            boolean isSCMessage;
            Packet packet = this.getRequestPacket(messageInfo);
            HaContext.initFrom((Packet)packet);
            Packet ret = null;
            try {
                ret = this.validateRequest(packet, clientSubject, serviceSubject, messageInfo.getMap());
            }
            catch (XWSSecurityException ex) {
                throw this.getSOAPFaultException(ex);
            }
            if (messageInfo.getMap().get("THERE_WAS_A_FAULT") != null) {
                this.setResponsePacket(messageInfo, ret);
                AuthStatus ex = AuthStatus.SEND_FAILURE;
                return ex;
            }
            boolean bl = isSCMessage = messageInfo.getMap().get("IS_SC_ISSUE") != null || messageInfo.getMap().get("IS_SC_CANCEL") != null;
            if (isSCMessage) {
                this.setResponsePacket(messageInfo, ret);
                AuthStatus authStatus = AuthStatus.SEND_SUCCESS;
                return authStatus;
            }
            this.setRequestPacket(messageInfo, ret);
            AuthStatus authStatus = AuthStatus.SUCCESS;
            return authStatus;
        }
        finally {
            HaContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) {
        try {
            Packet retPacket = this.getResponsePacket(messageInfo);
            HaContext.initFrom((Packet)retPacket);
            Packet ret = null;
            ret = this.secureResponse(retPacket, serviceSubject, messageInfo.getMap());
            this.setResponsePacket(messageInfo, ret);
            if (messageInfo.getMap().get("THERE_WAS_A_FAULT") != null) {
                AuthStatus authStatus = AuthStatus.SEND_FAILURE;
                return authStatus;
            }
            AuthStatus authStatus = AuthStatus.SUCCESS;
            return authStatus;
        }
        finally {
            HaContext.clear();
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) {
        this.issuedTokenContextMap.clear();
        SessionManager.removeSessionManager((WSEndpoint)this.endPoint.get());
        NonceManager.deleteInstance((WSEndpoint)this.endPoint.get());
    }

    public Packet validateRequest(Packet packet, Subject clientSubject, Subject serviceSubject, Map<String, Object> sharedState) throws XWSSecurityException {
        WSDLBoundOperation cachedOperation;
        Message msg = packet.getInternalMessage();
        boolean isSCIssueMessage = false;
        boolean isSCCancelMessage = false;
        Object msgId = null;
        String action = null;
        boolean thereWasAFault = false;
        ProcessingContext ctx = this.initializeInboundProcessingContext(packet);
        ctx.setExtraneousProperty("javax.security.auth.Subject", clientSubject);
        PolicyResolver pr = PolicyResolverFactory.createPolicyResolver(this.policyAlternatives, this.cachedOperation(packet), this.pipeConfig, this.addVer, false, this.rmVer, this.mcVer);
        ctx.setExtraneousProperty("OperationResolver", pr);
        ctx.setExtraneousProperty("SessionManager", (Object)this.sessionManager);
        try {
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                msg = Messages.create((SOAPMessage)soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (WssSoapFaultException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), ex);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException(ex, this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (XWSSecurityException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), xwse);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException(xwse, this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (XWSSecurityRuntimeException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), xwse);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException(xwse, this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (WebServiceException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), xwse);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException((Exception)((Object)xwse), this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (WSSecureConversationRuntimeException wsre) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), wsre);
            thereWasAFault = true;
            QName faultCode = wsre.getFaultCode();
            if (faultCode != null) {
                faultCode = new QName(this.wsscVer.getNamespaceURI(), faultCode.getLocalPart());
            }
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException(faultCode, wsre, this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), se);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException((Exception)((Object)se), this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), ex);
            thereWasAFault = true;
            SOAPFaultException sfe = SOAPUtil.getSOAPFaultException(ex, this.soapFactory, this.soapVersion);
            msg = Messages.create((Throwable)sfe, (SOAPVersion)this.soapVersion);
        }
        if (thereWasAFault) {
            sharedState.put("THERE_WAS_A_FAULT", thereWasAFault);
            if (this.isAddressingEnabled()) {
                if (this.optimized) {
                    packet.setMessage(((JAXBFilterProcessingContext)ctx).getPVMessage());
                }
                return packet.createServerResponse(msg, this.addVer, this.soapVersion, this.addVer.getDefaultFaultAction());
            }
            packet.setMessage(msg);
            return packet;
        }
        packet.setMessage(msg);
        if (this.isAddressingEnabled()) {
            List<PolicyAssertion> policies;
            action = this.getAction(packet);
            if (this.wsscVer.getSCTRequestAction().equals(action) || this.wsscVer.getSCTRenewRequestAction().equals(action)) {
                isSCIssueMessage = true;
                sharedState.put("IS_SC_ISSUE", TRUE);
                if (this.wsscConfig != null) {
                    packet.invocationProperties.put("http://schemas.sun.com/ws/2006/05/sc/server", this.wsscConfig.iterator());
                }
            } else if (this.wsscVer.getSCTCancelRequestAction().equals(action)) {
                isSCCancelMessage = true;
                sharedState.put("IS_SC_CANCEL", TRUE);
            } else if (this.wsTrustVer.getIssueRequestAction().equals(action) || this.wsTrustVer.getValidateRequestAction().equals(action)) {
                sharedState.put("IS_TRUST_MESSAGE", TRUE);
                sharedState.put("TRUST_REQUEST_ACTION", action);
                if (this.trustConfig != null) {
                    packet.invocationProperties.put("http://schemas.sun.com/ws/2006/05/trust/server", this.trustConfig.iterator());
                }
                packet.invocationProperties.put("SecurityEnvironment", this.secEnv);
                packet.invocationProperties.put("WSTrustVersion", this.wsTrustVer);
                IssuedTokenContext ictx = ((ProcessingContextImpl)ctx).getTrustContext();
                if (ictx != null && ictx.getAuthnContextClass() != null) {
                    packet.invocationProperties.put("AuthnContextClass", ictx.getAuthnContextClass());
                }
            }
            if (isSCIssueMessage && !(policies = this.getInBoundSCP(packet.getMessage())).isEmpty()) {
                packet.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
            }
        }
        if (!isSCIssueMessage && (cachedOperation = this.cacheOperation(msg, packet)) == null && this.addVer != null) {
            cachedOperation = this.getWSDLOpFromAction(packet, true);
            packet.invocationProperties.put("WSDL_BOUND_OPERATION", cachedOperation);
        }
        sharedState.put("VALIDATE_REQ_PACKET", packet);
        Packet retPacket = null;
        if (isSCIssueMessage || isSCCancelMessage) {
            retPacket = this.invokeSecureConversationContract(packet, ctx, isSCIssueMessage);
            retPacket = this.secureResponse(retPacket, serviceSubject, sharedState);
        } else {
            this.updateSCSessionInfo(packet);
            retPacket = packet;
        }
        return retPacket;
    }

    public Packet secureResponse(Packet retPacket, Subject serviceSubject, Map<String, Object> sharedState) {
        boolean thereWasAFault;
        boolean isSCIssueMessage = sharedState.get("IS_SC_ISSUE") != null;
        boolean isSCCancelMessage = sharedState.get("IS_SC_CANCEL") != null;
        boolean isTrustMessage = sharedState.get("IS_TRUST_MESSAGE") != null;
        Packet packet = (Packet)sharedState.get("VALIDATE_REQ_PACKET");
        Boolean thereWasAFaultSTR = (Boolean)sharedState.get("THERE_WAS_A_FAULT");
        boolean bl = thereWasAFault = thereWasAFaultSTR != null && thereWasAFaultSTR != false;
        if (thereWasAFault) {
            return retPacket;
        }
        if (!this.optimized) {
            try {
                SOAPMessage sm = retPacket.getMessage().readAsSOAPMessage();
                Message newMsg = Messages.create((SOAPMessage)sm);
                retPacket.setMessage(newMsg);
            }
            catch (SOAPException ex) {
                throw new WebServiceException((Throwable)ex);
            }
        }
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(retPacket, isSCIssueMessage);
        ctx.setExtraneousProperty("SessionManager", (Object)this.sessionManager);
        Message msg = retPacket.getMessage();
        try {
            if (ctx.getSecurityPolicy() != null && ((MessagePolicy)ctx.getSecurityPolicy()).size() > 0) {
                if (!this.optimized) {
                    SOAPMessage soapMessage = msg.readAsSOAPMessage();
                    soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                    msg = Messages.create((SOAPMessage)soapMessage);
                } else {
                    msg = this.secureOutboundMessage(msg, ctx);
                }
            }
        }
        catch (WssSoapFaultException ex) {
            sharedState.put("THERE_WAS_A_FAULT", Boolean.TRUE);
            msg = Messages.create((SOAPFault)this.getSOAPFault(ex));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se);
        }
        finally {
            if (this.isSCCancel(retPacket)) {
                this.removeContext(packet);
            }
        }
        this.resetCachedOperation(retPacket);
        retPacket.setMessage(msg);
        return retPacket;
    }

    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        if (debug) {
            DumpFilter.process(ctx);
        }
        ctx.setSOAPMessage(message);
        NewSecurityRecipient.validateMessage(ctx);
        return ctx.getSOAPMessage();
    }

    protected Message verifyInboundMessage(Message message, ProcessingContext ctx) throws XWSSecurityException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
        LazyStreamBasedMessage lazyStreamMessage = (LazyStreamBasedMessage)message;
        AttachmentSet attachSet = null;
        if (!LazyStreamBasedMessage.mtomLargeData()) {
            attachSet = lazyStreamMessage.getAttachments();
        }
        SecurityRecipient recipient = null;
        recipient = attachSet == null || attachSet.isEmpty() ? new SecurityRecipient(lazyStreamMessage.readMessage(), this.soapVersion) : new SecurityRecipient(lazyStreamMessage.readMessage(), this.soapVersion, attachSet);
        recipient.setBodyPrologue(lazyStreamMessage.getBodyPrologue());
        recipient.setBodyEpilogue(lazyStreamMessage.getBodyEpilogue());
        return recipient.validateMessage(context);
    }

    @Override
    protected ProcessingContext initializeOutgoingProcessingContext(Packet packet, boolean isSCMessage) {
        ProcessingContextImpl ctx = null;
        if (this.optimized) {
            ctx = new JAXBFilterProcessingContext(packet.invocationProperties);
            ((JAXBFilterProcessingContext)ctx).setAddressingVersion(this.addVer);
            ((JAXBFilterProcessingContext)ctx).setSOAPVersion(this.soapVersion);
        } else {
            ctx = new ProcessingContextImpl(packet.invocationProperties);
        }
        if (this.addVer != null) {
            ctx.setAction(this.getAction(packet));
        }
        ctx.setTimestampTimeout(this.timestampTimeOut);
        ctx.setSecurityPolicyVersion(this.spVersion.namespaceUri);
        try {
            SecurityPolicyHolder holder;
            MessagePolicy policy = null;
            PolicyAlternativeHolder applicableAlternative = this.resolveAlternative(packet, isSCMessage);
            if (packet.getMessage().isFault()) {
                policy = this.getOutgoingFaultPolicy(packet);
            } else if (this.isRMMessage(packet) || this.isMakeConnectionMessage(packet)) {
                holder = applicableAlternative.getOutProtocolPM().get("RM");
                policy = holder.getMessagePolicy();
            } else if (this.isSCCancel(packet)) {
                holder = applicableAlternative.getOutProtocolPM().get("SC-CANCEL");
                policy = holder.getMessagePolicy();
            } else {
                policy = this.getOutgoingXWSSecurityPolicy(packet, isSCMessage);
            }
            if (debug && policy != null) {
                policy.dumpMessages(true);
            }
            if (policy != null) {
                ctx.setSecurityPolicy(policy);
            }
            if (this.isTrustMessage(packet)) {
                ctx.isTrustMessage(true);
            }
            if (isSCMessage) {
                ctx.setAlgorithmSuite(policy.getAlgorithmSuite());
            } else {
                ctx.setAlgorithmSuite(this.getAlgoSuite(this.getBindingAlgorithmSuite(packet)));
            }
            ctx.setSecurityEnvironment(this.secEnv);
            ctx.isInboundMessage(false);
            Map extProps = ctx.getExtraneousProperties();
            extProps.put("WSDLPort", this.pipeConfig.getWSDLPort());
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
        }
        return ctx;
    }

    private void removeContext(Packet packet) {
        String strId;
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        if (sct != null && (strId = sct.getIdentifier().toString()) != null) {
            this.issuedTokenContextMap.remove(strId);
            this.sessionManager.terminateSession(strId);
        }
    }

    @Override
    protected MessagePolicy getOutgoingXWSSecurityPolicy(Packet packet, boolean isSCMessage) {
        SecurityPolicyHolder sph;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            return this.getOutgoingXWSBootstrapPolicy(scToken);
        }
        MessagePolicy mp = null;
        PolicyAlternativeHolder applicableAlternative = this.resolveAlternative(packet, isSCMessage);
        WSDLBoundOperation wsdlOperation = this.cachedOperation(packet);
        if (applicableAlternative.getOutMessagePolicyMap() == null) {
            return new MessagePolicy();
        }
        if (this.isTrustMessage(packet)) {
            wsdlOperation = this.getWSDLOpFromAction(packet, false);
            this.cacheOperation(wsdlOperation, packet);
        }
        if ((sph = applicableAlternative.getOutMessagePolicyMap().get(wsdlOperation)) == null) {
            return new MessagePolicy();
        }
        mp = sph.getMessagePolicy();
        return mp;
    }

    protected MessagePolicy getOutgoingFaultPolicy(Packet packet) {
        WSDLBoundOperation cachedOp = this.cachedOperation(packet);
        PolicyAlternativeHolder applicableAlternative = this.resolveAlternative(packet, false);
        if (cachedOp != null) {
            WSDLOperation wsdlOperation = cachedOp.getOperation();
            QName faultDetail = packet.getMessage().getFirstDetailEntryName();
            WSDLFault fault = null;
            if (faultDetail != null) {
                fault = wsdlOperation.getFault(faultDetail);
            }
            SecurityPolicyHolder sph = applicableAlternative.getOutMessagePolicyMap().get(cachedOp);
            if (fault == null) {
                return sph != null ? sph.getMessagePolicy() : new MessagePolicy();
            }
            SecurityPolicyHolder faultPolicyHolder = sph.getFaultPolicy(fault);
            return faultPolicyHolder == null ? new MessagePolicy() : faultPolicyHolder.getMessagePolicy();
        }
        return null;
    }

    private CallbackHandler configureServerHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret == null) {
                RealmAuthenticationAdapter adapter = this.getRealmAuthenticationAdapter((WSEndpoint)this.endPoint.get());
                return new DefaultCallbackHandler("server", props, adapter);
            }
            Class hdlr = this.loadClass(ret);
            Object obj = hdlr.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof CallbackHandler) {
                return (CallbackHandler)obj;
            }
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
            throw new RuntimeException(LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0043_ERROR_CONFIGURE_SERVER_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0043_ERROR_CONFIGURE_SERVER_HANDLER(), e);
        }
    }

    @Override
    protected boolean bindingHasIssuedTokenPolicy() {
        return this.hasIssuedTokens;
    }

    @Override
    protected boolean bindingHasSecureConversationPolicy() {
        return this.hasSecureConversation;
    }

    @Override
    protected boolean bindingHasRMPolicy() {
        return this.hasReliableMessaging;
    }

    private Packet invokeSecureConversationContract(Packet packet, ProcessingContext ctx, boolean isSCTIssue) {
        List<PolicyAssertion> policies;
        IssuedTokenContextImpl ictx = new IssuedTokenContextImpl();
        ictx.getOtherProperties().put("SessionManager", (Object)this.sessionManager);
        Message msg = packet.getMessage();
        Message retMsg = null;
        String retAction = null;
        try {
            Subject subject = SubjectAccessor.getRequesterSubject(ctx);
            ictx.setRequestorSubject(subject);
            WSTrustElementFactory wsscEleFac = WSTrustElementFactory.newInstance(this.wsscVer);
            JAXBElement rstEle = (JAXBElement)msg.readPayloadAsJAXB(WSTrustElementFactory.getContext(this.wsTrustVer).createUnmarshaller());
            RequestSecurityToken rst = wsscEleFac.createRSTFrom(rstEle);
            URI requestType = rst.getRequestType();
            BaseSTSResponse rstr = null;
            WSSCContract scContract = WSSCFactory.newWSSCContract(this.wsscVer);
            scContract.setWSSCServerConfig((Iterator)packet.invocationProperties.get("http://schemas.sun.com/ws/2006/05/sc/server"));
            if (requestType.toString().equals(this.wsTrustVer.getIssueRequestTypeURI())) {
                List<PolicyAssertion> policies2 = this.getOutBoundSCP(packet.getMessage());
                rstr = scContract.issue(rst, ictx, (SecureConversationToken)policies2.get(0));
                retAction = this.wsscVer.getSCTResponseAction();
                SecurityContextToken sct = (SecurityContextToken)ictx.getSecurityToken();
                String sctId = sct.getIdentifier().toString();
                Session session = this.sessionManager.getSession(sctId);
                if (session == null) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0044_ERROR_SESSION_CREATION());
                    throw new WSSecureConversationException(LogStringsMessages.WSITPVD_0044_ERROR_SESSION_CREATION());
                }
                packet.invocationProperties.put("com.sun.xml.ws.sessionid", sctId);
                packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
            } else if (requestType.toString().equals(this.wsTrustVer.getRenewRequestTypeURI())) {
                List<PolicyAssertion> policies3 = this.getOutBoundSCP(packet.getMessage());
                retAction = this.wsscVer.getSCTRenewResponseAction();
                rstr = scContract.renew(rst, ictx, (SecureConversationToken)policies3.get(0));
            } else if (requestType.toString().equals(this.wsTrustVer.getCancelRequestTypeURI())) {
                retAction = this.wsscVer.getSCTCancelResponseAction();
                rstr = scContract.cancel(rst, ictx);
            } else {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0045_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
                throw new UnsupportedOperationException(LogStringsMessages.WSITPVD_0045_UNSUPPORTED_OPERATION_EXCEPTION(requestType));
            }
            retMsg = Messages.create((JAXBContext)WSTrustElementFactory.getContext(this.wsTrustVer), (Object)wsscEleFac.toJAXBElement(rstr), (SOAPVersion)this.soapVersion);
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0001_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0001_PROBLEM_MAR_UNMAR(), ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        catch (WSSecureConversationException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0046_ERROR_INVOKE_SC_CONTRACT(), ex);
        }
        Packet retPacket = this.addAddressingHeaders(packet, retMsg, retAction);
        if (isSCTIssue && !(policies = this.getOutBoundSCP(packet.getMessage())).isEmpty()) {
            retPacket.invocationProperties.put(Constants.SC_ASSERTION, policies.get(0));
        }
        return retPacket;
    }

    private Packet addAddressingHeaders(Packet packet, Message retMsg, String action) {
        Packet retPacket = packet.createServerResponse(retMsg, this.addVer, this.soapVersion, action);
        retPacket.proxy = packet.proxy;
        retPacket.invocationProperties.putAll(packet.invocationProperties);
        return retPacket;
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy, PolicyAlternativeHolder ph) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, true);
        ph.getInMessagePolicyMap().put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy, PolicyAlternativeHolder ph) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, true, false);
        ph.getOutMessagePolicyMap().put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol, PolicyAlternativeHolder ph) throws PolicyException {
        ph.getOutProtocolPM().put(protocol, this.constructPolicyHolder(effectivePolicy, true, false, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol, PolicyAlternativeHolder ph) throws PolicyException {
        ph.getInProtocolPM().put(protocol, this.constructPolicyHolder(effectivePolicy, true, true, false));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, true, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    private RealmAuthenticationAdapter getRealmAuthenticationAdapter(WSEndpoint wSEndpoint) {
        WSSServletContextFacade obj = ServletContextUtil.getServletContextFacade(wSEndpoint);
        return obj == null ? null : RealmAuthenticationAdapter.newInstance(obj);
    }

    private void updateSCSessionInfo(Packet packet) {
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        if (sct != null) {
            String sessionId = sct.getIdentifier().toString();
            packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
            packet.invocationProperties.put("com.sun.xml.ws.session", this.sessionManager.getSession(sessionId).getUserData());
        }
    }
}

