/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.security.spi.SecurityContext;
import com.sun.xml.wss.provider.wsit.ConfigHelper;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class PipeHelper
extends ConfigHelper {
    private final SEIModel seiModel;
    private final SOAPVersion soapVersion;
    private static final String SECURITY_CONTEXT_PROP = "META-INF/services/com.sun.xml.ws.security.spi.SecurityContext";
    private Class<?> secCntxt;
    private SecurityContext context;

    public PipeHelper(String layer, Map<String, Object> map, CallbackHandler cbh) {
        WSEndpoint endPoint;
        this.init(layer, PipeHelper.getAppCtxt(map), map, cbh);
        this.seiModel = (SEIModel)map.get("SEI_MODEL");
        WSBinding binding = (WSBinding)map.get("BINDING");
        if (binding == null && (endPoint = (WSEndpoint)map.get("ENDPOINT")) != null) {
            binding = endPoint.getBinding();
        }
        this.soapVersion = binding != null ? binding.getSOAPVersion() : SOAPVersion.SOAP_11;
        URL url = PipeHelper.loadFromClasspath(SECURITY_CONTEXT_PROP);
        if (url != null) {
            InputStream is = null;
            try {
                is = url.openStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int val = is.read();
                while (val != -1) {
                    os.write(val);
                    val = is.read();
                }
                String className = os.toString();
                this.secCntxt = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                if (this.secCntxt != null) {
                    this.context = (SecurityContext)this.secCntxt.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PipeHelper.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        }
    }

    @Override
    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject s) throws AuthException {
        ClientAuthConfig c = (ClientAuthConfig)this.getAuthConfig(false);
        if (c != null) {
            PipeHelper.addModel(info, this.map);
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    @Override
    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject s) throws AuthException {
        ServerAuthConfig c = (ServerAuthConfig)this.getAuthConfig(true);
        if (c != null) {
            PipeHelper.addModel(info, this.map);
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    public static URL loadFromClasspath(String configFileName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResource(configFileName);
        }
        return loader.getResource(configFileName);
    }

    public Subject getClientSubject() {
        Subject s = null;
        if (this.context != null) {
            s = this.context.getSubject();
        }
        if (s == null) {
            s = Subject.getSubject(AccessController.getContext());
        }
        if (s == null) {
            s = new Subject();
        }
        return s;
    }

    public void getSessionToken(Map<String, Object> m, MessageInfo info, Subject s) throws AuthException {
        ClientAuthConfig c = (ClientAuthConfig)this.getAuthConfig(false);
        if (c != null) {
            m.putAll(this.map);
            PipeHelper.addModel(info, this.map);
            c.getAuthContext(c.getAuthContextID(info), s, m);
        }
    }

    public Object getModelName() {
        WSDLPort wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL");
        return wsdlModel == null ? "unknown" : wsdlModel.getName();
    }

    public Packet makeFaultResponse(Packet response, Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        if (response == null) {
            response = new Packet();
        }
        try {
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
        catch (Exception e) {
            response = new Packet();
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
    }

    public boolean isTwoWay(boolean twoWayIsDefault, Packet request) {
        WSDLPort wsdlModel;
        boolean twoWay = twoWayIsDefault;
        Message m = request.getMessage();
        if (m != null && (wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL")) != null) {
            twoWay = !m.isOneWay(wsdlModel);
        }
        return twoWay;
    }

    public Packet getFaultResponse(Packet request, Packet response, Throwable t) {
        boolean twoWay = true;
        try {
            twoWay = this.isTwoWay(true, request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (twoWay) {
            return this.makeFaultResponse(response, t);
        }
        return new Packet();
    }

    @Override
    public void disable() {
        this.listenerWrapper.disableWithRefCount();
    }

    private static String getAppCtxt(Map<String, Object> map) {
        String rvalue = null;
        WSEndpoint wse = (WSEndpoint)map.get("ENDPOINT");
        Container container = (Container)map.get("CONTAINER");
        if (wse != null) {
            Module module;
            if (container != null && (module = (Module)container.getSPI(Module.class)) != null) {
                List beList = module.getBoundEndpoints();
                for (BoundEndpoint be : beList) {
                    WSEndpoint wsep = be.getEndpoint();
                    if (!wse.getPortName().equals(wsep.getPortName())) continue;
                    rvalue = be.getAddress().toASCIIString();
                }
            }
            if (rvalue == null) {
                rvalue = wse.getPortName().toString();
            }
        } else {
            WSService service = (WSService)map.get("SERVICE");
            if (service != null) {
                rvalue = service.getServiceName().toString();
            }
        }
        return rvalue;
    }

    private static void addModel(MessageInfo info, Map<String, Object> map) {
        Object model = map.get("WSDL_MODEL");
        if (model != null) {
            info.getMap().put("WSDL_MODEL", model);
        }
    }

    private static String getServerName(WSEndpoint wse) {
        return "localhost";
    }

    private static String getEndpointURI(WSEndpoint wse) {
        return wse.getPort().getAddress().getURI().toASCIIString();
    }

    public void authorize(Packet request) {
        Subject s = (Subject)request.invocationProperties.get("CLIENT_SUBJECT");
        if (s == null) {
            s = Subject.getSubject(AccessController.getContext());
        }
        if (this.context != null) {
            this.context.setSubject(s);
        }
    }
}

