/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common.client;

import com.sun.xml.ws.tx.coord.common.EndpointReferenceBuilder;
import com.sun.xml.ws.tx.coord.common.WSCUtil;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterType;
import jakarta.xml.ws.EndpointReference;
import org.w3c.dom.Element;

public abstract class RegistrationMessageBuilder {
    protected boolean durable = true;
    protected Element txIdElement;
    protected Element routingElement;
    protected String participantAddress;
    protected String protocolIdentifier;

    public RegistrationMessageBuilder durable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public RegistrationMessageBuilder txId(String txId) {
        this.txIdElement = WSCUtil.referenceElementTxId(txId);
        return this;
    }

    public RegistrationMessageBuilder routing() {
        this.routingElement = WSCUtil.referenceElementRoutingInfo();
        return this;
    }

    public RegistrationMessageBuilder participantAddress(String address) {
        this.participantAddress = address;
        return this;
    }

    public RegistrationMessageBuilder protocolIdentifier(String protocolIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
        return this;
    }

    public BaseRegisterType build() {
        if (this.participantAddress == null) {
            this.participantAddress = this.getDefaultParticipantAddress();
        }
        BaseRegisterType registerType = this.newRegistrationRequest();
        registerType.setParticipantProtocolService(this.getParticipantProtocolService());
        registerType.setProtocolIdentifier(this.protocolIdentifier);
        return registerType;
    }

    protected EndpointReference getParticipantProtocolService() {
        EndpointReferenceBuilder eprBuilder = this.getEndpointReferenceBuilder();
        return eprBuilder.address(this.participantAddress).referenceParameter(this.txIdElement).referenceParameter(this.routingElement).build();
    }

    protected abstract BaseRegisterType newRegistrationRequest();

    protected abstract String getDefaultParticipantAddress();

    protected abstract BaseRegisterResponseType buildRegistrationResponse();

    protected abstract EndpointReferenceBuilder getEndpointReferenceBuilder();
}

